/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.parse;

import au.com.codeka.carrot.parse.ParseException;
import au.com.codeka.carrot.parse.Token;

public class MacroToken
extends Token {
    private static final long serialVersionUID = -3710981054298651807L;
    private String macroName;
    private String helpers;

    public MacroToken(String image) throws ParseException {
        super(image);
    }

    @Override
    public int getType() {
        return 33;
    }

    @Override
    protected void parse() throws ParseException {
        this.content = this.image.substring(2, this.image.length() - 2).trim().replaceFirst("\\s", " ");
        int postBlank = this.content.indexOf(32);
        if (postBlank > 0) {
            this.macroName = this.content.substring(0, postBlank).toLowerCase();
            this.helpers = this.content.substring(postBlank).trim();
        } else {
            this.macroName = this.content;
            this.helpers = "";
        }
    }

    public String getMacroName() {
        return this.macroName;
    }

    public String getHelpers() {
        return this.helpers;
    }

    @Override
    public String toString() {
        if (this.helpers.length() == 0) {
            return "{! " + this.macroName + " !}";
        }
        return "{! " + this.macroName + " " + this.helpers + " !}";
    }
}

