/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.lib.tag;

import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.interpret.InterpretException;
import au.com.codeka.carrot.interpret.VariableFilter;
import au.com.codeka.carrot.lib.Tag;
import au.com.codeka.carrot.tree.Node;
import au.com.codeka.carrot.tree.NodeList;
import au.com.codeka.carrot.util.ForLoop;
import au.com.codeka.carrot.util.HelperStringTokenizer;
import au.com.codeka.carrot.util.ObjectIterator;
import java.io.IOException;
import java.io.Writer;

public class ForTag
implements Tag {
    final String LOOP = "loop";
    final String TAGNAME = "for";
    final String ENDTAGNAME = "endfor";

    @Override
    public void interpreter(NodeList carries, String helpers, CarrotInterpreter interpreter, Writer writer) throws CarrotException, IOException {
        String[] helper = new HelperStringTokenizer(helpers).allTokens();
        if (helper.length != 3) {
            throw new InterpretException("Tag 'for' expects 3 helpers >>> " + helper.length);
        }
        String item = helper[0];
        Object collection = VariableFilter.compute(helper[2], interpreter);
        ForLoop<Object> loop = ObjectIterator.getLoop(collection);
        int level = interpreter.getLevel() + 1;
        interpreter.assignRuntimeScope("loop", loop, level);
        while (loop.hasNext()) {
            interpreter.assignRuntimeScope(item, loop.next(), level);
            for (Node node : carries) {
                node.render(interpreter, writer);
            }
        }
    }

    @Override
    public String getEndTagName() {
        return "endfor";
    }

    @Override
    public String getName() {
        return "for";
    }
}

