/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.lib.tag;

import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.interpret.InterpretException;
import au.com.codeka.carrot.lib.Tag;
import au.com.codeka.carrot.tree.NodeList;
import au.com.codeka.carrot.util.HelperStringTokenizer;
import java.io.IOException;
import java.io.Writer;

public class CycleTag
implements Tag {
    final String LOOP_INDEX = "loop.index";
    final String TAGNAME = "cycle";

    @Override
    public void interpreter(NodeList carries, String helpers, CarrotInterpreter interpreter, Writer writer) throws CarrotException, IOException {
        String var = null;
        HelperStringTokenizer tk = new HelperStringTokenizer(helpers);
        String[] helper = tk.allTokens();
        if (helper.length == 1) {
            HelperStringTokenizer items = new HelperStringTokenizer(helper[0]);
            items.splitComma(true);
            String[] values = items.allTokens();
            Integer forindex = (Integer)interpreter.retraceVariable("loop.index");
            if (forindex == null) {
                forindex = 0;
            }
            if (values.length == 1) {
                var = values[0];
                if ((values = (String[])interpreter.retraceVariable(var)) == null) {
                    writer.write(interpreter.resolveString(var));
                }
            } else {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = interpreter.resolveString(values[i]);
                }
            }
            if (values != null) {
                writer.write(values[forindex % values.length]);
            }
        } else if (helper.length == 3) {
            HelperStringTokenizer items = new HelperStringTokenizer(helper[0]);
            items.splitComma(true);
            String[] values = items.allTokens();
            for (int i = 0; i < values.length; ++i) {
                values[i] = interpreter.resolveString(values[i]);
            }
            var = helper[2];
            interpreter.assignRuntimeScope(var, values);
        } else {
            throw new InterpretException("Tag 'cycle' expects 1 or 3 helper(s) >>> " + helper.length);
        }
    }

    @Override
    public String getEndTagName() {
        return null;
    }

    @Override
    public String getName() {
        return "cycle";
    }
}

