/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.lib.tag;

import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.interpret.InterpretException;
import au.com.codeka.carrot.lib.Tag;
import au.com.codeka.carrot.tree.Node;
import au.com.codeka.carrot.tree.NodeList;
import au.com.codeka.carrot.util.HelperStringTokenizer;
import au.com.codeka.carrot.util.ListOrderedMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;

public class BlockTag
implements Tag {
    final String BLOCKNAMES = "'BLK\"NAMES";
    final String TAGNAME = "block";
    final String ENDTAGNAME = "endblock";

    @Override
    public void interpreter(NodeList carries, String helpers, CarrotInterpreter interpreter, Writer writer) throws CarrotException, IOException {
        String[] helper = new HelperStringTokenizer(helpers).allTokens();
        if (helper.length != 1) {
            throw new InterpretException("Tag 'block' expects 1 helper >>> " + helper.length);
        }
        String blockName = interpreter.resolveString(helper[0]);
        ArrayList<String> blockNames = (ArrayList<String>)interpreter.fetchRuntimeScope("'BLK\"NAMES", 1);
        if (blockNames == null) {
            blockNames = new ArrayList<String>();
        }
        if (blockNames.contains(blockName)) {
            throw new InterpretException("Can't redefine the block with name >>> " + blockName);
        }
        blockNames.add(blockName);
        interpreter.assignRuntimeScope("'BLK\"NAMES", blockNames, 1);
        Object isChild = interpreter.fetchRuntimeScope("'IS\"CHILD", 1);
        if (isChild != null) {
            ListOrderedMap blockList = (ListOrderedMap)interpreter.fetchRuntimeScope("'BLK\"LIST", 1);
            if (!blockList.containsKey(blockName)) {
                throw new InterpretException("Dosen't define block in extends parent with name >>> " + blockName);
            }
            blockList.put(blockName, (Object)this.getBlockContent(carries, interpreter));
            return;
        }
        Object isParent = interpreter.fetchRuntimeScope("'IS\"PARENT", 1);
        if (isParent != null) {
            ListOrderedMap blockList = (ListOrderedMap)interpreter.fetchRuntimeScope("'BLK\"LIST", 1);
            blockList.put(blockName, (Object)this.getBlockContent(carries, interpreter));
            writer.write("<K2C9OL7B>" + blockName);
            return;
        }
        this.writeBlockContent(carries, interpreter, writer);
    }

    private void writeBlockContent(NodeList carries, CarrotInterpreter interpreter, Writer writer) throws CarrotException, IOException {
        for (Node node : carries) {
            node.render(interpreter, writer);
        }
    }

    private String getBlockContent(NodeList carrier, CarrotInterpreter interpreter) throws CarrotException, IOException {
        StringWriter writer = new StringWriter();
        this.writeBlockContent(carrier, interpreter, writer);
        return writer.toString();
    }

    @Override
    public String getEndTagName() {
        return "endblock";
    }

    @Override
    public String getName() {
        return "block";
    }
}

