/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.lib.filter;

import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.interpret.InterpretException;
import au.com.codeka.carrot.lib.Filter;
import au.com.codeka.carrot.util.ObjectStringEqual;

public class EqualFilter
implements Filter {
    @Override
    public Object filter(Object object, CarrotInterpreter interpreter, String ... arg) throws CarrotException {
        Object argObj;
        if (arg.length != 1) {
            throw new InterpretException("filter equal expects 1 arg >>> " + arg.length);
        }
        boolean isNull = false;
        if (arg[0].startsWith("'") || arg[0].startsWith("\"")) {
            argObj = arg[0].substring(1, arg[0].length() - 1);
        } else {
            argObj = interpreter.retraceVariable(arg[0]);
            isNull = argObj == null;
            if (isNull) {
                argObj = arg[0];
            }
        }
        if (object == null) {
            return isNull;
        }
        return ObjectStringEqual.evaluate(object, argObj);
    }

    @Override
    public String getName() {
        return "equal";
    }
}

