/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.interpret;

import java.util.HashMap;
import java.util.Map;

public class FloorBindings
implements Cloneable {
    private Map<Integer, Map<String, Object>> floor;

    public FloorBindings() {
        HashMap root = new HashMap();
        this.floor = new HashMap<Integer, Map<String, Object>>();
        this.floor.put(1, root);
    }

    public Object put(String name, Object value, int level) {
        this.checkKey(name);
        return this.getBindings(level).put(name, value);
    }

    public void putAll(Map<? extends String, ? extends Object> toMerge, int level) {
        if (toMerge == null) {
            throw new NullPointerException("toMerge map is null");
        }
        for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), level);
        }
    }

    public boolean containsKey(String key, int level) {
        return this.getBindings(level).containsKey(key);
    }

    public Object get(String key, int level) {
        this.checkKey(key);
        return this.getBindings(level).get(key);
    }

    public Object remove(Object key, int level) {
        return this.getBindings(level).remove(key);
    }

    public void clear(int level) {
        this.getBindings(level).clear();
    }

    public boolean containsValue(Object value, int level) {
        return this.getBindings(level).containsValue(value);
    }

    private Map<String, Object> getBindings(int level) {
        Map<String, Object> map = this.floor.get(level);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.floor.put(level, map);
        }
        return map;
    }

    private void checkKey(String key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        if (key.equals("")) {
            throw new IllegalArgumentException("key can not be empty");
        }
    }

    public FloorBindings clone() {
        FloorBindings fb = new FloorBindings();
        for (Map.Entry<Integer, Map<String, Object>> entry : this.floor.entrySet()) {
            fb.putAll(entry.getValue(), entry.getKey());
        }
        return fb;
    }
}

