/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.base;

import au.com.codeka.carrot.base.Application;
import au.com.codeka.carrot.base.Configuration;
import java.util.HashMap;
import java.util.Map;

public class Context {
    public static final int SCOPE_GLOBAL = 1;
    public static final int SCOPE_SESSION = 2;
    protected Map<String, Object> sessionBindings;
    protected Application application;

    public Context() {
        this.application = new Application();
        this.sessionBindings = new HashMap<String, Object>();
    }

    public Context(Application application) {
        if (application == null) {
            application = new Application();
        }
        this.application = application;
        this.sessionBindings = new HashMap<String, Object>();
    }

    public Application getApplication() {
        return this.application;
    }

    public Configuration getConfiguration() {
        return this.application.config;
    }

    public Object getAttribute(String varName, int scope) {
        switch (scope) {
            case 1: {
                return this.application.globalBindings.get(varName);
            }
            case 2: {
                return this.sessionBindings.get(varName);
            }
        }
        return null;
    }

    public Object getAttribute(String varName) {
        if (this.sessionBindings.containsKey(varName)) {
            return this.sessionBindings.get(varName);
        }
        if (this.application.globalBindings.containsKey(varName)) {
            return this.application.globalBindings.get(varName);
        }
        return null;
    }

    public void setAttribute(String varName, Object value, int scope) {
        switch (scope) {
            case 1: {
                this.application.globalBindings.put(varName, value);
                break;
            }
            case 2: {
                this.sessionBindings.put(varName, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal scope value.");
            }
        }
    }

    public void initBindings(Map<String, Object> bindings, int scope) {
        switch (scope) {
            case 1: {
                this.application.globalBindings = bindings;
                break;
            }
            case 2: {
                this.sessionBindings = bindings;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal scope value.");
            }
        }
    }

    public void setAttributes(Map<String, Object> bindings, int scope) {
        switch (scope) {
            case 1: {
                this.application.globalBindings.putAll(bindings);
                break;
            }
            case 2: {
                this.sessionBindings.putAll(bindings);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal scope value.");
            }
        }
    }

    public void reset(int scope) {
        switch (scope) {
            case 1: {
                this.application.globalBindings.clear();
                break;
            }
            case 2: {
                this.sessionBindings.clear();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal scope value.");
            }
        }
    }
}

