/*
 * Decompiled with CFR 0.152.
 */
package au.com.alderaan.eclipselink.mojo;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.tools.weaving.jpa.StaticWeaveProcessor;

public class EclipselinkStaticWeaveMojo
extends AbstractMojo {
    private String persistenceInfo;
    private String persistenceXMLLocation;
    private String source;
    private String target;
    private String logLevel = "OFF";
    private MavenProject project;
    private boolean includeProjectClasspath = false;

    public void execute() throws MojoExecutionException {
        try {
            if (this.includeProjectClasspath) {
                ClassRealm c = (ClassRealm)Thread.currentThread().getContextClassLoader();
                c.addURL(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
                for (URL url : this.buildClassPath()) {
                    c.addURL(url);
                }
            }
            StaticWeaveProcessor weave = new StaticWeaveProcessor(this.source, this.target);
            URL[] urls = this.buildClassPath();
            if (urls.length > 0) {
                URLClassLoader classLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
                weave.setClassLoader((ClassLoader)classLoader);
            }
            if (this.persistenceInfo != null) {
                weave.setPersistenceInfo(this.persistenceInfo);
            }
            if (this.persistenceXMLLocation != null) {
                weave.setPersistenceXMLLocation(this.persistenceXMLLocation);
            }
            weave.setLog((Writer)new PrintWriter(System.out));
            weave.setLogLevel(this.getLogLevel());
            weave.performWeaving();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed", (Exception)e);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Failed", (Exception)e);
        }
    }

    private int getLogLevel() {
        return AbstractSessionLog.translateStringToLoggingLevel((String)this.logLevel);
    }

    public void setLogLevel(String logLevel) {
        if (!("OFF".equalsIgnoreCase(logLevel) || "SEVERE".equalsIgnoreCase(logLevel) || "WARNING".equalsIgnoreCase(logLevel) || "INFO".equalsIgnoreCase(logLevel) || "CONFIG".equalsIgnoreCase(logLevel) || "FINE".equalsIgnoreCase(logLevel) || "FINER".equalsIgnoreCase(logLevel) || "FINEST".equalsIgnoreCase(logLevel) || "ALL".equalsIgnoreCase(logLevel))) {
            throw new IllegalArgumentException("Unknown log level: " + logLevel);
        }
        this.logLevel = logLevel.toUpperCase();
    }

    private URL[] buildClassPath() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Set artifacts = this.project.getArtifacts();
        for (Artifact a : artifacts) {
            urls.add(a.getFile().toURI().toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

