/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.util.Locale;
import java.util.Map;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.util.Contract;

public class LocalizableStringValue
implements StringValue {
    private Map<Object, String> lookup;
    private Locale locale;
    private String prefix;

    public LocalizableStringValue(Map<Object, String> lookup) {
        this(lookup, null, null);
    }

    public LocalizableStringValue(Map<Object, String> lookup, Locale locale) {
        this(lookup, null, locale);
    }

    public LocalizableStringValue(Map<Object, String> lookup, String prefix) {
        this(lookup, prefix, null);
    }

    public LocalizableStringValue(Map<Object, String> lookup, String prefix, Locale locale) {
        this.lookup = Contract.asNotNull(lookup, "map must not be null");
        this.prefix = prefix;
        this.setLocale(locale);
    }

    @Override
    public String getString(Object value) {
        String text;
        String key = this.getKey(value);
        if (key != null && (text = this.getLocalizedString(key)) != null) {
            return text;
        }
        return this.getFallbackString(value);
    }

    protected String getKey(Object value) {
        String key = this.lookup.get(value);
        if (key != null && this.prefix != null) {
            key = this.prefix + key;
        }
        return key;
    }

    protected String getFallbackString(Object value) {
        return StringValues.TO_STRING_UI.getString(value);
    }

    protected String getLocalizedString(String key) {
        return UIManagerExt.getString(key, this.getLocale());
    }

    public final void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale != null ? this.locale : Locale.getDefault();
    }
}

