/*
 * Decompiled with CFR 0.152.
 */
package at.stefangeyer.challonge.serializer.gson.adapter;

import at.stefangeyer.challonge.model.Match;
import at.stefangeyer.challonge.model.Participant;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.List;

public class ParticipantAdapter
implements JsonDeserializer<Participant> {
    public Participant deserialize(JsonElement src, Type typeOfSource, JsonDeserializationContext context) throws JsonParseException {
        JsonObject e = src.getAsJsonObject().has("participant") ? src.getAsJsonObject().get("participant").getAsJsonObject() : src.getAsJsonObject();
        long id = e.get("id").getAsLong();
        OffsetDateTime updatedAt = (OffsetDateTime)context.deserialize(e.get("updated_at"), OffsetDateTime.class);
        Long groupId = this.getOrNull(e, "group_id") != null ? Long.valueOf(this.getOrNull(e, "group_id").getAsLong()) : null;
        OffsetDateTime createdAt = (OffsetDateTime)context.deserialize(e.get("created_at"), OffsetDateTime.class);
        long tournamentId = e.get("tournament_id").getAsLong();
        int seed = e.get("seed").getAsInt();
        String name = this.getOrNull(e, "name") != null ? this.getOrNull(e, "name").getAsString() : null;
        String displayNameWithInvitationEmailAddress = this.getOrNull(e, "display_name_with_invitation_email_address") != null ? this.getOrNull(e, "display_name_with_invitation_email_address").getAsString() : null;
        String misc = this.getOrNull(e, "misc") != null ? this.getOrNull(e, "misc").getAsString() : null;
        String challongeUsername = this.getOrNull(e, "challonge_username") != null ? this.getOrNull(e, "challonge_username").getAsString() : null;
        String inviteEmail = this.getOrNull(e, "invite_email") != null ? this.getOrNull(e, "invite_email").getAsString() : null;
        boolean active = e.get("active").getAsBoolean();
        String attachedParticipatablePortraitUrl = this.getOrNull(e, "attached_participatable_portrait_url") != null ? this.getOrNull(e, "attached_participatable_portrait_url").getAsString() : null;
        boolean canCheckIn = e.get("can_check_in").getAsBoolean();
        String challongeEmailAddressVerified = this.getOrNull(e, "challonge_email_address_verified") != null ? this.getOrNull(e, "challonge_email_address_verified").getAsString() : null;
        boolean checkedIn = e.get("checked_in").getAsBoolean();
        OffsetDateTime checkedInAt = (OffsetDateTime)context.deserialize(e.get("checked_in_at"), OffsetDateTime.class);
        boolean confirmRemove = e.get("confirm_remove").getAsBoolean();
        String emailHash = this.getOrNull(e, "email_hash") != null ? this.getOrNull(e, "email_hash").getAsString() : null;
        Integer finalRank = this.getOrNull(e, "final_rank") != null ? Integer.valueOf(this.getOrNull(e, "final_rank").getAsInt()) : null;
        String icon = this.getOrNull(e, "icon") != null ? this.getOrNull(e, "icon").getAsString() : null;
        Long invitationId = this.getOrNull(e, "invitation_id") != null ? Long.valueOf(this.getOrNull(e, "invitation_id").getAsLong()) : null;
        boolean invitationPending = e.get("invitation_pending").getAsBoolean();
        boolean onWaitingList = e.get("on_waiting_list").getAsBoolean();
        boolean participatableOrInvitationAttached = e.get("participatable_or_invitation_attached").getAsBoolean();
        boolean reactivatable = e.get("reactivatable").getAsBoolean();
        boolean removable = e.get("removable").getAsBoolean();
        String displayName = e.get("display_name").getAsString();
        Boolean checkInOpen = e.get("check_in_open").getAsBoolean();
        Boolean hasIrrelevantSeed = e.get("has_irrelevant_seed").getAsBoolean();
        String username = this.getOrNull(e, "username") != null ? this.getOrNull(e, "username").getAsString() : null;
        List matches = (List)context.deserialize(e.get("matches"), new TypeToken<List<Match>>(){}.getType());
        return Participant.builder().id(Long.valueOf(id)).updatedAt(updatedAt).groupId(groupId).createdAt(createdAt).tournamentId(Long.valueOf(tournamentId)).seed(Integer.valueOf(seed)).name(name).displayNameWithInvitationEmailAddress(displayNameWithInvitationEmailAddress).misc(misc).challongeUsername(challongeUsername).inviteEmail(inviteEmail).active(Boolean.valueOf(active)).attachedParticipatablePortraitUrl(attachedParticipatablePortraitUrl).canCheckIn(Boolean.valueOf(canCheckIn)).challongeEmailAddressVerified(challongeEmailAddressVerified).checkedIn(Boolean.valueOf(checkedIn)).checkedInAt(checkedInAt).confirmRemove(Boolean.valueOf(confirmRemove)).emailHash(emailHash).finalRank(finalRank).icon(icon).invitationId(invitationId).invitationPending(Boolean.valueOf(invitationPending)).onWaitingList(Boolean.valueOf(onWaitingList)).participatableOrInvitationAttached(Boolean.valueOf(participatableOrInvitationAttached)).reactivatable(Boolean.valueOf(reactivatable)).displayName(displayName).checkInOpen(checkInOpen).hasIrrelevantSeed(hasIrrelevantSeed).removable(Boolean.valueOf(removable)).username(username).matches(matches).build();
    }

    private JsonElement getOrNull(JsonObject o, String key) {
        return !o.has(key) || o.get(key).isJsonNull() ? null : o.get(key);
    }
}

