/*
 * Decompiled with CFR 0.152.
 */
package at.stefangeyer.challonge.serializer.gson;

import at.stefangeyer.challonge.model.Attachment;
import at.stefangeyer.challonge.model.Match;
import at.stefangeyer.challonge.model.Participant;
import at.stefangeyer.challonge.model.Tournament;
import at.stefangeyer.challonge.model.query.MatchQuery;
import at.stefangeyer.challonge.model.query.ParticipantQuery;
import at.stefangeyer.challonge.model.query.TournamentQuery;
import at.stefangeyer.challonge.model.wrapper.MatchWrapperListWrapper;
import at.stefangeyer.challonge.model.wrapper.ParticipantWrapperListWrapper;
import at.stefangeyer.challonge.serializer.Serializer;
import at.stefangeyer.challonge.serializer.gson.adapter.AttachmentAdapter;
import at.stefangeyer.challonge.serializer.gson.adapter.MatchAdapter;
import at.stefangeyer.challonge.serializer.gson.adapter.MatchQueryAdapter;
import at.stefangeyer.challonge.serializer.gson.adapter.MatchWrapperListWrapperAdapter;
import at.stefangeyer.challonge.serializer.gson.adapter.OffsetDateTimeAdapter;
import at.stefangeyer.challonge.serializer.gson.adapter.ParticipantAdapter;
import at.stefangeyer.challonge.serializer.gson.adapter.ParticipantQueryAdapter;
import at.stefangeyer.challonge.serializer.gson.adapter.ParticipantWrapperListWrapperAdapter;
import at.stefangeyer.challonge.serializer.gson.adapter.TournamentAdapter;
import at.stefangeyer.challonge.serializer.gson.adapter.TournamentQueryAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;

public class GsonSerializer
implements Serializer {
    private final Gson gson;

    public GsonSerializer(GsonBuilder builder) {
        builder.registerTypeAdapter(Tournament.class, (Object)new TournamentAdapter());
        builder.registerTypeAdapter(Participant.class, (Object)new ParticipantAdapter());
        builder.registerTypeAdapter(Match.class, (Object)new MatchAdapter());
        builder.registerTypeAdapter(Attachment.class, (Object)new AttachmentAdapter());
        builder.registerTypeAdapter(TournamentQuery.class, (Object)new TournamentQueryAdapter());
        builder.registerTypeAdapter(ParticipantQuery.class, (Object)new ParticipantQueryAdapter());
        builder.registerTypeAdapter(MatchQuery.class, (Object)new MatchQueryAdapter());
        builder.registerTypeAdapter(ParticipantWrapperListWrapper.class, (Object)new ParticipantWrapperListWrapperAdapter());
        builder.registerTypeAdapter(MatchWrapperListWrapper.class, (Object)new MatchWrapperListWrapperAdapter());
        builder.registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeAdapter());
        this.gson = builder.create();
    }

    public GsonSerializer() {
        this(new GsonBuilder());
    }

    public String serialize(Object obj) {
        return this.gson.toJson(obj);
    }

    public <T> T deserialize(String string, Type type) {
        return (T)this.gson.fromJson(string, type);
    }

    public Gson getGson() {
        return this.gson;
    }
}

