/*
 * Decompiled with CFR 0.152.
 */
package at.stefangeyer.challonge.serializer.gson.adapter;

import at.stefangeyer.challonge.model.Tournament;
import at.stefangeyer.challonge.model.enumeration.RankedBy;
import at.stefangeyer.challonge.model.enumeration.TournamentState;
import at.stefangeyer.challonge.model.enumeration.TournamentType;
import at.stefangeyer.challonge.model.query.enumeration.GrandFinalsModifier;
import at.stefangeyer.challonge.model.wrapper.MatchWrapper;
import at.stefangeyer.challonge.model.wrapper.MatchWrapperListWrapper;
import at.stefangeyer.challonge.model.wrapper.ParticipantWrapper;
import at.stefangeyer.challonge.model.wrapper.ParticipantWrapperListWrapper;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class TournamentAdapter
implements JsonDeserializer<Tournament> {
    public Tournament deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject e = json.getAsJsonObject().has("tournament") ? json.getAsJsonObject().get("tournament").getAsJsonObject() : json.getAsJsonObject();
        long id = e.get("id").getAsLong();
        String url = e.get("url").getAsString();
        String name = e.get("name").getAsString();
        TournamentType tournamentType = TournamentType.valueOf((String)e.get("tournament_type").getAsString().replace(" ", "_").toUpperCase());
        String subdomain = this.getOrNull(e, "subdomain") != null ? this.getOrNull(e, "subdomain").getAsString() : null;
        String description = this.getOrNull(e, "description") != null ? this.getOrNull(e, "description").getAsString() : null;
        boolean openSignup = e.get("open_signup").getAsBoolean();
        boolean holdThirdPlaceMatch = e.get("hold_third_place_match").getAsBoolean();
        float pointsForMatchWin = e.get("pts_for_match_win").getAsFloat();
        float pointsForMatchTie = e.get("pts_for_match_tie").getAsFloat();
        float pointsForGameWin = e.get("pts_for_game_win").getAsFloat();
        float pointsForGameTie = e.get("pts_for_game_tie").getAsFloat();
        float pointsForBye = e.get("pts_for_bye").getAsFloat();
        int swissRounds = e.get("swiss_rounds").getAsInt();
        RankedBy rankedBy = this.getOrNull(e, "ranked_by") != null ? RankedBy.valueOf((String)this.getOrNull(e, "ranked_by").getAsString().replace(" ", "_").toUpperCase()) : null;
        float roundRobinPointsForGameWin = e.get("rr_pts_for_game_win").getAsFloat();
        float roundRobinPointsForGameTie = e.get("rr_pts_for_game_tie").getAsFloat();
        float roundRobinPointsForMatchWin = e.get("rr_pts_for_match_win").getAsFloat();
        float roundRobinPointsForMatchTie = e.get("rr_pts_for_match_tie").getAsFloat();
        boolean acceptAttachments = e.get("accept_attachments").getAsBoolean();
        boolean hideForum = e.get("hide_forum").getAsBoolean();
        boolean showRounds = e.get("show_rounds").getAsBoolean();
        boolean privateOnly = e.get("private").getAsBoolean();
        boolean notifyUsersWhenMatchesOpen = e.get("notify_users_when_matches_open").getAsBoolean();
        boolean notifyUsersWhenTheTournamentEnds = e.get("notify_users_when_the_tournament_ends").getAsBoolean();
        boolean sequentialPairings = e.get("sequential_pairings").getAsBoolean();
        Integer signupCap = this.getOrNull(e, "signup_cap") != null ? Integer.valueOf(this.getOrNull(e, "signup_cap").getAsInt()) : null;
        OffsetDateTime startAt = (OffsetDateTime)context.deserialize(this.getOrNull(e, "start_at"), OffsetDateTime.class);
        Long checkInDuration = this.getOrNull(e, "check_in_duration") != null ? Long.valueOf(this.getOrNull(e, "check_in_duration").getAsLong()) : null;
        boolean allowParticipantMatchReporting = e.get("allow_participant_match_reporting").getAsBoolean();
        boolean anonymousVoting = e.get("anonymous_voting").getAsBoolean();
        String category = this.getOrNull(e, "category") != null ? this.getOrNull(e, "category").getAsString() : null;
        OffsetDateTime completedAt = (OffsetDateTime)context.deserialize(e.get("completed_at"), OffsetDateTime.class);
        OffsetDateTime createdAt = (OffsetDateTime)context.deserialize(e.get("created_at"), OffsetDateTime.class);
        boolean createdByApi = e.get("created_by_api").getAsBoolean();
        boolean creditCapped = e.get("credit_capped").getAsBoolean();
        Long gameId = this.getOrNull(e, "game_id") != null ? Long.valueOf(this.getOrNull(e, "game_id").getAsLong()) : null;
        boolean groupStagesEnabled = e.get("group_stages_enabled").getAsBoolean();
        boolean hideSeeds = e.get("hide_seeds").getAsBoolean();
        int maxPredictionsPerUser = e.get("max_predictions_per_user").getAsInt();
        int participantsCount = e.get("participants_count").getAsInt();
        int predictionMethod = e.get("prediction_method").getAsInt();
        OffsetDateTime predictionsOpenedAt = (OffsetDateTime)context.deserialize(e.get("predictions_opened_at"), OffsetDateTime.class);
        int progressMeter = e.get("progress_meter").getAsInt();
        boolean quickAdvance = e.get("quick_advance").getAsBoolean();
        boolean requireScoreAgreement = e.get("require_score_agreement").getAsBoolean();
        OffsetDateTime startedAt = (OffsetDateTime)context.deserialize(e.get("started_at"), OffsetDateTime.class);
        OffsetDateTime startedCheckingInAt = (OffsetDateTime)context.deserialize(e.get("started_checking_in_at"), OffsetDateTime.class);
        TournamentState state = TournamentState.valueOf((String)e.get("state").getAsString().replace(" ", "_").toUpperCase());
        Boolean teams = this.getOrNull(e, "teams") != null ? Boolean.valueOf(this.getOrNull(e, "teams").getAsBoolean()) : null;
        ArrayList tieBreaks = new ArrayList();
        if (this.getOrNull(e, "tie_breaks") != null) {
            this.getOrNull(e, "tie_breaks").getAsJsonArray().forEach(inner -> tieBreaks.add(inner.getAsString()));
        }
        String descriptionSource = this.getOrNull(e, "description_source") != null ? this.getOrNull(e, "description_source").getAsString() : null;
        boolean participantsLocked = e.get("participants_locked").getAsBoolean();
        String gameName = this.getOrNull(e, "game_name") != null ? this.getOrNull(e, "game_name").getAsString() : null;
        boolean participantsSwappable = e.get("participants_swappable").getAsBoolean();
        boolean teamConvertable = e.get("team_convertable").getAsBoolean();
        boolean groupStagesWereStarted = e.get("group_stages_were_started").getAsBoolean();
        OffsetDateTime lockedAt = (OffsetDateTime)context.deserialize(e.get("locked_at"), OffsetDateTime.class);
        Long eventId = this.getOrNull(e, "event_id") != null ? Long.valueOf(this.getOrNull(e, "event_id").getAsLong()) : null;
        Boolean publicPredictionsBeforeStartTime = this.getOrNull(e, "public_predictions_before_start_time") != null ? Boolean.valueOf(this.getOrNull(e, "public_predictions_before_start_time").getAsBoolean()) : null;
        OffsetDateTime updatedAt = (OffsetDateTime)context.deserialize(e.get("updated_at"), OffsetDateTime.class);
        String fullChallongeUrl = this.getOrNull(e, "full_challonge_url") != null ? this.getOrNull(e, "full_challonge_url").getAsString() : null;
        String liveImageUrl = this.getOrNull(e, "live_image_url") != null ? this.getOrNull(e, "live_image_url").getAsString() : null;
        boolean reviewBeforeFinalizing = e.get("review_before_finalizing").getAsBoolean();
        boolean acceptingPredictions = e.get("accepting_predictions").getAsBoolean();
        GrandFinalsModifier grandFinalsModifier = null;
        if (this.getOrNull(e, "grand_finals_modifier") != null) {
            grandFinalsModifier = GrandFinalsModifier.valueOf((String)this.getOrNull(e, "grand_finals_modifier").getAsString().replace(" ", "_").toUpperCase());
        }
        ArrayList participants = new ArrayList();
        JsonElement pe = e.get("participants");
        if (pe != null && !pe.isJsonNull()) {
            participants.addAll(((ParticipantWrapperListWrapper)context.deserialize(pe, ParticipantWrapperListWrapper.class)).getParticipants().stream().map(ParticipantWrapper::getParticipant).collect(Collectors.toList()));
        }
        ArrayList matches = new ArrayList();
        JsonElement pm = e.get("matches");
        if (pm != null && !pm.isJsonNull()) {
            matches.addAll(((MatchWrapperListWrapper)context.deserialize(pm, MatchWrapperListWrapper.class)).getMatches().stream().map(MatchWrapper::getMatch).collect(Collectors.toList()));
        }
        return Tournament.builder().id(Long.valueOf(id)).name(name).url(url).tournamentType(tournamentType).subdomain(subdomain).description(description).openSignup(Boolean.valueOf(openSignup)).holdThirdPlaceMatch(Boolean.valueOf(holdThirdPlaceMatch)).pointsForMatchWin(Float.valueOf(pointsForMatchWin)).pointsForMatchTie(Float.valueOf(pointsForMatchTie)).pointsForGameWin(Float.valueOf(pointsForGameWin)).pointsForGameTie(Float.valueOf(pointsForGameTie)).pointsForBye(Float.valueOf(pointsForBye)).swissRounds(Integer.valueOf(swissRounds)).rankedBy(rankedBy).roundRobinPointsForGameWin(Float.valueOf(roundRobinPointsForGameWin)).roundRobinPointsForGameTie(Float.valueOf(roundRobinPointsForGameTie)).roundRobinPointsForMatchWin(Float.valueOf(roundRobinPointsForMatchWin)).roundRobinPointsForMatchTie(Float.valueOf(roundRobinPointsForMatchTie)).acceptAttachments(Boolean.valueOf(acceptAttachments)).hideForum(Boolean.valueOf(hideForum)).showRounds(Boolean.valueOf(showRounds)).privateOnly(Boolean.valueOf(privateOnly)).notifyUsersWhenMatchesOpen(Boolean.valueOf(notifyUsersWhenMatchesOpen)).notifyUsersWhenTheTournamentEnds(Boolean.valueOf(notifyUsersWhenTheTournamentEnds)).sequentialPairings(Boolean.valueOf(sequentialPairings)).signupCap(signupCap).startAt(startAt).checkInDuration(checkInDuration).allowParticipantMatchReporting(Boolean.valueOf(allowParticipantMatchReporting)).anonymousVoting(Boolean.valueOf(anonymousVoting)).category(category).completedAt(completedAt).createdAt(createdAt).createdByApi(Boolean.valueOf(createdByApi)).creditCapped(Boolean.valueOf(creditCapped)).gameId(gameId).groupStagesEnabled(Boolean.valueOf(groupStagesEnabled)).hideSeeds(Boolean.valueOf(hideSeeds)).maxPredictionsPerUser(Integer.valueOf(maxPredictionsPerUser)).participantsCount(Integer.valueOf(participantsCount)).predictionMethod(Integer.valueOf(predictionMethod)).predictionsOpenedAt(predictionsOpenedAt).progressMeter(Integer.valueOf(progressMeter)).quickAdvance(Boolean.valueOf(quickAdvance)).requireScoreAgreement(Boolean.valueOf(requireScoreAgreement)).startedAt(startedAt).startedCheckingInAt(startedCheckingInAt).state(state).teams(teams).tieBreaks(tieBreaks).updatedAt(updatedAt).descriptionSource(descriptionSource).fullChallongeUrl(fullChallongeUrl).liveImageUrl(liveImageUrl).reviewBeforeFinalizing(Boolean.valueOf(reviewBeforeFinalizing)).acceptingPredictions(Boolean.valueOf(acceptingPredictions)).participantsLocked(Boolean.valueOf(participantsLocked)).gameName(gameName).participantsSwappable(Boolean.valueOf(participantsSwappable)).teamConvertable(Boolean.valueOf(teamConvertable)).groupStagesWereStarted(Boolean.valueOf(groupStagesWereStarted)).lockedAt(lockedAt).eventId(eventId).publicPredictionsBeforeStartTime(publicPredictionsBeforeStartTime).grandFinalsModifier(grandFinalsModifier).participants(participants).matches(matches).build();
    }

    private JsonElement getOrNull(JsonObject o, String key) {
        return !o.has(key) || o.get(key).isJsonNull() ? null : o.get(key);
    }
}

