/*
 * Decompiled with CFR 0.152.
 */
package at.stefangeyer.challonge.serializer.gson.adapter;

import at.stefangeyer.challonge.model.Attachment;
import at.stefangeyer.challonge.model.Match;
import at.stefangeyer.challonge.model.enumeration.MatchState;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.List;

public class MatchAdapter
implements JsonDeserializer<Match> {
    public Match deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject e = json.getAsJsonObject().has("match") ? json.getAsJsonObject().get("match").getAsJsonObject() : json.getAsJsonObject();
        long id = e.get("id").getAsLong();
        long tournamentId = e.get("tournament_id").getAsLong();
        Integer attachmentCount = this.getOrNull(e, "attachment_count") != null ? Integer.valueOf(this.getOrNull(e, "attachment_count").getAsInt()) : null;
        OffsetDateTime createdAt = (OffsetDateTime)context.deserialize(e.get("created_at"), OffsetDateTime.class);
        Long groupId = this.getOrNull(e, "group_id") != null ? Long.valueOf(this.getOrNull(e, "group_id").getAsLong()) : null;
        boolean hasAttachment = e.get("has_attachment").getAsBoolean();
        String identifier = this.getOrNull(e, "identifier") != null ? this.getOrNull(e, "identifier").getAsString() : null;
        String location = this.getOrNull(e, "location") != null ? this.getOrNull(e, "location").getAsString() : null;
        OffsetDateTime updatedAt = (OffsetDateTime)context.deserialize(e.get("updated_at"), OffsetDateTime.class);
        MatchState state = MatchState.valueOf((String)e.get("state").getAsString().replace(" ", "_").toUpperCase());
        OffsetDateTime startedAt = (OffsetDateTime)context.deserialize(e.get("started_at"), OffsetDateTime.class);
        String scoresCsv = this.getOrNull(e, "scores_csv") != null ? this.getOrNull(e, "scores_csv").getAsString() : null;
        Long winnerId = this.getOrNull(e, "winner_id") != null ? Long.valueOf(this.getOrNull(e, "winner_id").getAsLong()) : null;
        Long loserId = this.getOrNull(e, "loser_id") != null ? Long.valueOf(this.getOrNull(e, "loser_id").getAsLong()) : null;
        Long player1Id = this.getOrNull(e, "player1_id") != null ? Long.valueOf(this.getOrNull(e, "player1_id").getAsLong()) : null;
        Long player2Id = this.getOrNull(e, "player2_id") != null ? Long.valueOf(this.getOrNull(e, "player2_id").getAsLong()) : null;
        boolean player1IsPrerequisiteMatchLoser = e.get("player1_is_prereq_match_loser").getAsBoolean();
        Long player1PrerequisiteMatchId = this.getOrNull(e, "player1_prereq_match_id") != null ? Long.valueOf(this.getOrNull(e, "player1_prereq_match_id").getAsLong()) : null;
        Integer player1Votes = this.getOrNull(e, "player1_votes") != null ? Integer.valueOf(this.getOrNull(e, "player1_votes").getAsInt()) : null;
        boolean player2IsPrerequisiteMatchLoser = e.get("player2_is_prereq_match_loser").getAsBoolean();
        Long player2PrerequisiteMatchId = this.getOrNull(e, "player2_prereq_match_id") != null ? Long.valueOf(this.getOrNull(e, "player2_prereq_match_id").getAsLong()) : null;
        Integer player2Votes = this.getOrNull(e, "player2_votes") != null ? Integer.valueOf(this.getOrNull(e, "player2_votes").getAsInt()) : null;
        String prerequisiteMatchIdsCsv = this.getOrNull(e, "prerequisite_match_ids_csv") != null ? this.getOrNull(e, "prerequisite_match_ids_csv").getAsString() : null;
        int round = e.get("round").getAsInt();
        OffsetDateTime scheduledTime = (OffsetDateTime)context.deserialize(e.get("scheduled_time"), OffsetDateTime.class);
        OffsetDateTime underwayAt = (OffsetDateTime)context.deserialize(e.get("underway_at"), OffsetDateTime.class);
        List attachments = (List)context.deserialize(e.get("attachments"), new TypeToken<List<Attachment>>(){}.getType());
        return Match.builder().id(Long.valueOf(id)).tournamentId(Long.valueOf(tournamentId)).attachmentCount(attachmentCount).createdAt(createdAt).groupId(groupId).hasAttachment(Boolean.valueOf(hasAttachment)).identifier(identifier).location(location).updatedAt(updatedAt).state(state).startedAt(startedAt).scoresCsv(scoresCsv).winnerId(winnerId).loserId(loserId).player1Id(player1Id).player2Id(player2Id).player1IsPrerequisiteMatchLoser(Boolean.valueOf(player1IsPrerequisiteMatchLoser)).player1PrerequisiteMatchId(player1PrerequisiteMatchId).player1Votes(player1Votes).player2IsPrerequisiteMatchLoser(Boolean.valueOf(player2IsPrerequisiteMatchLoser)).player2PrerequisiteMatchId(player2PrerequisiteMatchId).player2Votes(player2Votes).prerequisiteMatchIdsCsv(prerequisiteMatchIdsCsv).round(Integer.valueOf(round)).scheduledTime(scheduledTime).underwayAt(underwayAt).attachments(attachments).build();
    }

    private JsonElement getOrNull(JsonObject o, String key) {
        return !o.has(key) || o.get(key).isJsonNull() ? null : o.get(key);
    }
}

