/*
 * Decompiled with CFR 0.152.
 */
package at.stefangeyer.challonge.serializer.gson.adapter;

import at.stefangeyer.challonge.model.Attachment;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;

public class AttachmentAdapter
implements JsonDeserializer<Attachment> {
    public Attachment deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String assetUrl;
        JsonObject e = json.getAsJsonObject().has("match_attachment") ? json.getAsJsonObject().get("match_attachment").getAsJsonObject() : json.getAsJsonObject();
        long id = e.get("id").getAsLong();
        long matchId = e.get("match_id").getAsLong();
        long userId = e.get("user_id").getAsLong();
        String description = this.getOrNull(e, "description") != null ? this.getOrNull(e, "description").getAsString() : null;
        String url = this.getOrNull(e, "url") != null ? this.getOrNull(e, "url").getAsString() : null;
        String originalFileName = this.getOrNull(e, "original_file_name") != null ? this.getOrNull(e, "original_file_name").getAsString() : null;
        OffsetDateTime createdAt = (OffsetDateTime)context.deserialize(e.get("created_at"), OffsetDateTime.class);
        OffsetDateTime updatedAt = (OffsetDateTime)context.deserialize(e.get("updated_at"), OffsetDateTime.class);
        String assetFileName = this.getOrNull(e, "asset_file_name") != null ? this.getOrNull(e, "asset_file_name").getAsString() : null;
        String assetContentType = this.getOrNull(e, "asset_content_type") != null ? this.getOrNull(e, "asset_content_type").getAsString() : null;
        Long assetFileSize = this.getOrNull(e, "asset_file_size") != null ? Long.valueOf(this.getOrNull(e, "asset_file_size").getAsLong()) : null;
        String string = assetUrl = this.getOrNull(e, "asset_url") != null ? this.getOrNull(e, "asset_url").getAsString() : null;
        if (assetUrl != null) {
            assetUrl = "https:" + assetUrl;
        }
        return Attachment.builder().id(Long.valueOf(id)).matchId(Long.valueOf(matchId)).userId(Long.valueOf(userId)).description(description).url(url).originalFileName(originalFileName).createdAt(createdAt).updatedAt(updatedAt).assetFileName(assetFileName).assetContentType(assetContentType).assetFileSize(assetFileSize).assetUrl(assetUrl).build();
    }

    private JsonElement getOrNull(JsonObject o, String key) {
        return !o.has(key) || o.get(key).isJsonNull() ? null : o.get(key);
    }
}

