/*
 * Decompiled with CFR 0.152.
 */
package at.stefangeyer.challonge.rest.retrofit.util;

import at.stefangeyer.challonge.exception.DataAccessException;
import at.stefangeyer.challonge.rest.retrofit.util.RetrofitCallback;
import java.io.IOException;
import retrofit2.Callback;
import retrofit2.Response;

public class RetrofitUtil {
    public static <T> T parse(Response<T> response) throws DataAccessException {
        try {
            if (!response.isSuccessful()) {
                throw new DataAccessException("Request towards " + response.raw().request().url() + " was not successful (" + response.code() + ") and returned: " + (response.errorBody() != null ? response.errorBody().string() : null));
            }
            Object body = response.body();
            if (body != null) {
                return (T)body;
            }
            throw new DataAccessException("Received response body was null");
        }
        catch (IOException e) {
            throw new DataAccessException("Cannot read error body", (Throwable)e);
        }
    }

    public static int responseCount(okhttp3.Response response) {
        if (response == null) {
            return 0;
        }
        return 1 + RetrofitUtil.responseCount(response.priorResponse());
    }

    public static <T> Callback<T> callback(at.stefangeyer.challonge.async.Callback<T> onSuccess, at.stefangeyer.challonge.async.Callback<DataAccessException> onFailure, String errorMessage) {
        return new RetrofitCallback<T>(onSuccess, onFailure, errorMessage);
    }
}

