/*
 * Decompiled with CFR 0.152.
 */
package at.stefangeyer.challonge.rest.retrofit.util;

import at.stefangeyer.challonge.exception.DataAccessException;
import at.stefangeyer.challonge.rest.retrofit.util.RetrofitUtil;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class RetrofitCallback<T>
implements Callback<T> {
    private at.stefangeyer.challonge.async.Callback<T> onSuccess;
    private at.stefangeyer.challonge.async.Callback<DataAccessException> onFailure;
    private String errorMessage;

    public RetrofitCallback(at.stefangeyer.challonge.async.Callback<T> onSuccess, at.stefangeyer.challonge.async.Callback<DataAccessException> onFailure, String errorMessage) {
        this.onSuccess = onSuccess;
        this.onFailure = onFailure;
        this.errorMessage = errorMessage;
    }

    public void onResponse(Call<T> call, Response<T> response) {
        try {
            this.onSuccess.accept(RetrofitUtil.parse(response));
        }
        catch (DataAccessException e) {
            this.onFailure.accept((Object)e);
        }
    }

    public void onFailure(Call<T> call, Throwable t) {
        this.onFailure.accept((Object)new DataAccessException(this.errorMessage, t));
    }
}

