/*
 * Decompiled with CFR 0.152.
 */
package at.stefangeyer.challonge.rest.retrofit;

import at.stefangeyer.challonge.async.Callback;
import at.stefangeyer.challonge.exception.DataAccessException;
import at.stefangeyer.challonge.model.enumeration.MatchState;
import at.stefangeyer.challonge.model.enumeration.TournamentType;
import at.stefangeyer.challonge.model.query.AttachmentQuery;
import at.stefangeyer.challonge.model.query.enumeration.TournamentQueryState;
import at.stefangeyer.challonge.model.query.wrapper.MatchQueryWrapper;
import at.stefangeyer.challonge.model.query.wrapper.ParticipantQueryListWrapper;
import at.stefangeyer.challonge.model.query.wrapper.ParticipantQueryWrapper;
import at.stefangeyer.challonge.model.query.wrapper.TournamentQueryWrapper;
import at.stefangeyer.challonge.model.wrapper.AttachmentWrapper;
import at.stefangeyer.challonge.model.wrapper.MatchWrapper;
import at.stefangeyer.challonge.model.wrapper.ParticipantWrapper;
import at.stefangeyer.challonge.model.wrapper.TournamentWrapper;
import at.stefangeyer.challonge.rest.RestClient;
import at.stefangeyer.challonge.rest.retrofit.ChallongeRetrofit;
import at.stefangeyer.challonge.rest.retrofit.converter.RetrofitConverterFactory;
import at.stefangeyer.challonge.rest.retrofit.util.RetrofitUtil;
import at.stefangeyer.challonge.serializer.Serializer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

public class RetrofitRestClient
implements RestClient,
Closeable {
    private static final String BASE_URL = "https://api.challonge.com/v1/";
    private OkHttpClient httpClient;
    private boolean useHttp2;
    private ChallongeRetrofit challongeRetrofit;

    public RetrofitRestClient(ChallongeRetrofit challongeRetrofit, boolean useHttp2) {
        this.challongeRetrofit = challongeRetrofit;
        this.useHttp2 = useHttp2;
    }

    public RetrofitRestClient(boolean useHttp2) {
        this(null, useHttp2);
    }

    public RetrofitRestClient() {
        this(false);
    }

    public void initialize(at.stefangeyer.challonge.model.Credentials credentials, Serializer serializer) {
        if (this.challongeRetrofit != null) {
            return;
        }
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        if (!this.useHttp2) {
            httpClientBuilder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        }
        httpClientBuilder.authenticator((route, response) -> {
            String credential = Credentials.basic((String)credentials.getUsername(), (String)credentials.getKey(), (Charset)Charset.forName("UTF-8"));
            if (RetrofitUtil.responseCount(response) >= 5) {
                return null;
            }
            return response.request().newBuilder().header("Authorization", credential).build();
        });
        httpClientBuilder.addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder requestBuilder = original.newBuilder().header("Accept", "application/json").method(original.method(), original.body());
            return chain.proceed(requestBuilder.build());
        });
        this.httpClient = httpClientBuilder.build();
        RetrofitConverterFactory factory = new RetrofitConverterFactory(serializer);
        Retrofit retrofit = new Retrofit.Builder().client(this.httpClient).baseUrl(BASE_URL).addConverterFactory((Converter.Factory)factory).build();
        this.challongeRetrofit = (ChallongeRetrofit)retrofit.create(ChallongeRetrofit.class);
    }

    private void checkInitialized() {
        if (this.challongeRetrofit == null) {
            throw new IllegalStateException("Attempted to create rest client before initialization");
        }
    }

    public List<TournamentWrapper> getTournaments(TournamentQueryState state, TournamentType type, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String subdomain) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.getTournaments(state, type, createdAfter, createdBefore, subdomain).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while getting tournaments", (Throwable)e);
        }
        return (List)RetrofitUtil.parse(response);
    }

    public void getTournaments(TournamentQueryState state, TournamentType type, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String subdomain, Callback<List<TournamentWrapper>> onSuccess, Callback<DataAccessException> onFailure) {
        this.challongeRetrofit.getTournaments(state, type, createdAfter, createdBefore, subdomain).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while getting tournaments"));
    }

    public TournamentWrapper getTournament(String tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.getTournament(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while getting tournament " + tournament, (Throwable)e);
        }
        return (TournamentWrapper)RetrofitUtil.parse(response);
    }

    public void getTournament(String tournament, boolean includeParticipants, boolean includeMatches, Callback<TournamentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.getTournament(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while getting tournament"));
    }

    public TournamentWrapper createTournament(TournamentQueryWrapper tournamentData) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.createTournament(tournamentData).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while creating tournament", (Throwable)e);
        }
        return (TournamentWrapper)RetrofitUtil.parse(response);
    }

    public void createTournament(TournamentQueryWrapper tournamentData, Callback<TournamentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.createTournament(tournamentData).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while creating tournament"));
    }

    public TournamentWrapper updateTournament(String tournament, TournamentQueryWrapper tournamentData) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.updateTournament(tournament, tournamentData).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while updating tournament", (Throwable)e);
        }
        return (TournamentWrapper)RetrofitUtil.parse(response);
    }

    public void updateTournament(String tournament, TournamentQueryWrapper tournamentData, Callback<TournamentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.updateTournament(tournament, tournamentData).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while updating tournament"));
    }

    public TournamentWrapper deleteTournament(String tournament) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.deleteTournament(tournament).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while deleting tournament", (Throwable)e);
        }
        return (TournamentWrapper)RetrofitUtil.parse(response);
    }

    public void deleteTournament(String tournament, Callback<TournamentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.deleteTournament(tournament).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while deleting tournament"));
    }

    public TournamentWrapper processCheckIns(String tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.processCheckIns(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while check in processing", (Throwable)e);
        }
        return (TournamentWrapper)RetrofitUtil.parse(response);
    }

    public void processCheckIns(String tournament, boolean includeParticipants, boolean includeMatches, Callback<TournamentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.processCheckIns(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while check in processing"));
    }

    public TournamentWrapper abortCheckIn(String tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.abortCheckIn(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while check in abort", (Throwable)e);
        }
        return (TournamentWrapper)RetrofitUtil.parse(response);
    }

    public void abortCheckIn(String tournament, boolean includeParticipants, boolean includeMatches, Callback<TournamentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.abortCheckIn(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while check in abort"));
    }

    public TournamentWrapper startTournament(String tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.startTournament(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while starting tournament", (Throwable)e);
        }
        return (TournamentWrapper)RetrofitUtil.parse(response);
    }

    public void startTournament(String tournament, boolean includeParticipants, boolean includeMatches, Callback<TournamentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.startTournament(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while starting tournament"));
    }

    public TournamentWrapper finalizeTournament(String tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.finalizeTournament(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while finalizing tournament", (Throwable)e);
        }
        return (TournamentWrapper)RetrofitUtil.parse(response);
    }

    public void finalizeTournament(String tournament, boolean includeParticipants, boolean includeMatches, Callback<TournamentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.finalizeTournament(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while finalizing tournament"));
    }

    public TournamentWrapper resetTournament(String tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.resetTournament(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while resetting tournament", (Throwable)e);
        }
        return (TournamentWrapper)RetrofitUtil.parse(response);
    }

    public void resetTournament(String tournament, boolean includeParticipants, boolean includeMatches, Callback<TournamentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.resetTournament(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while resetting tournament"));
    }

    public TournamentWrapper openTournamentForPredictions(String tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.openTournamentForPredictions(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while opening tournament for predictions", (Throwable)e);
        }
        return (TournamentWrapper)RetrofitUtil.parse(response);
    }

    public void openTournamentForPredictions(String tournament, boolean includeParticipants, boolean includeMatches, Callback<TournamentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.openTournamentForPredictions(tournament, includeParticipants ? 1 : 0, includeMatches ? 1 : 0).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while opening tournament for predictions"));
    }

    public List<ParticipantWrapper> getParticipants(String tournament) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.getParticipants(tournament).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while getting participants", (Throwable)e);
        }
        return (List)RetrofitUtil.parse(response);
    }

    public void getParticipants(String tournament, Callback<List<ParticipantWrapper>> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.getParticipants(tournament).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while getting participants"));
    }

    public ParticipantWrapper getParticipant(String tournament, long participantId, boolean includeMatches) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.getParticipant(tournament, participantId, includeMatches ? 1 : 0).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while getting participant", (Throwable)e);
        }
        return (ParticipantWrapper)RetrofitUtil.parse(response);
    }

    public void getParticipant(String tournament, long participantId, boolean includeMatches, Callback<ParticipantWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.getParticipant(tournament, participantId, includeMatches ? 1 : 0).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while getting participant"));
    }

    public ParticipantWrapper addParticipant(String tournament, ParticipantQueryWrapper participant) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.addParticipant(tournament, participant).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while adding participant", (Throwable)e);
        }
        return (ParticipantWrapper)RetrofitUtil.parse(response);
    }

    public void addParticipant(String tournament, ParticipantQueryWrapper participant, Callback<ParticipantWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.addParticipant(tournament, participant).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while adding participant"));
    }

    public List<ParticipantWrapper> bulkAddParticipants(String tournament, ParticipantQueryListWrapper participants) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.bulkAddParticipants(tournament, participants).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while bulk adding participant", (Throwable)e);
        }
        return (List)RetrofitUtil.parse(response);
    }

    public void bulkAddParticipants(String tournament, ParticipantQueryListWrapper participants, Callback<List<ParticipantWrapper>> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.bulkAddParticipants(tournament, participants).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while bulk adding participant"));
    }

    public ParticipantWrapper updateParticipant(String tournament, long participantId, ParticipantQueryWrapper participant) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.updateParticipant(tournament, participantId, participant).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while updating participant", (Throwable)e);
        }
        return (ParticipantWrapper)RetrofitUtil.parse(response);
    }

    public void updateParticipant(String tournament, long participantId, ParticipantQueryWrapper participant, Callback<ParticipantWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.updateParticipant(tournament, participantId, participant).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while updating participant"));
    }

    public ParticipantWrapper checkInParticipant(String tournament, long participantId) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.checkInParticipant(tournament, participantId).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while checking in participant", (Throwable)e);
        }
        return (ParticipantWrapper)RetrofitUtil.parse(response);
    }

    public void checkInParticipant(String tournament, long participantId, Callback<ParticipantWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.checkInParticipant(tournament, participantId).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while checking in participant"));
    }

    public ParticipantWrapper undoCheckInParticipant(String tournament, long participantId) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.undoCheckInParticipant(tournament, participantId).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while undoing participant check in", (Throwable)e);
        }
        return (ParticipantWrapper)RetrofitUtil.parse(response);
    }

    public void undoCheckInParticipant(String tournament, long participantId, Callback<ParticipantWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.undoCheckInParticipant(tournament, participantId).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while undoing participant check in"));
    }

    public ParticipantWrapper deleteParticipant(String tournament, long participantId) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.deleteParticipant(tournament, participantId).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while deleting participant", (Throwable)e);
        }
        return (ParticipantWrapper)RetrofitUtil.parse(response);
    }

    public void deleteParticipant(String tournament, long participantId, Callback<ParticipantWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.deleteParticipant(tournament, participantId).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while deleting participant"));
    }

    public List<ParticipantWrapper> randomizeParticipants(String tournament) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.randomizeParticipants(tournament).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while randomizing participants", (Throwable)e);
        }
        return (List)RetrofitUtil.parse(response);
    }

    public void randomizeParticipants(String tournament, Callback<List<ParticipantWrapper>> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.randomizeParticipants(tournament).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while randomizing participants"));
    }

    public List<MatchWrapper> getMatches(String tournament, Long participantId, MatchState state) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.getMatches(tournament, participantId, state).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while getting matches", (Throwable)e);
        }
        return (List)RetrofitUtil.parse(response);
    }

    public void getMatches(String tournament, Long participantId, MatchState state, Callback<List<MatchWrapper>> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.getMatches(tournament, participantId, state).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while getting matches"));
    }

    public MatchWrapper getMatch(String tournament, long matchId, boolean includeAttachments) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.getMatch(tournament, matchId, includeAttachments ? 1 : 0).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while getting match", (Throwable)e);
        }
        return (MatchWrapper)RetrofitUtil.parse(response);
    }

    public void getMatch(String tournament, long matchId, boolean includeAttachments, Callback<MatchWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.getMatch(tournament, matchId, includeAttachments ? 1 : 0).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while getting match"));
    }

    public MatchWrapper updateMatch(String tournament, long matchId, MatchQueryWrapper match) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.updateMatch(tournament, matchId, match).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while updating match", (Throwable)e);
        }
        return (MatchWrapper)RetrofitUtil.parse(response);
    }

    public void updateMatch(String tournament, long matchId, MatchQueryWrapper match, Callback<MatchWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.updateMatch(tournament, matchId, match).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while updating match"));
    }

    public MatchWrapper markMatchAsUnderway(String tournament, long matchId) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.markMatchAsUnderway(tournament, matchId).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while marking match as underway", (Throwable)e);
        }
        return (MatchWrapper)RetrofitUtil.parse(response);
    }

    public void markMatchAsUnderway(String tournament, long matchId, Callback<MatchWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.markMatchAsUnderway(tournament, matchId).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while marking match as underway"));
    }

    public MatchWrapper unmarkMatchAsUnderway(String tournament, long matchId) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.unmarkMatchAsUnderway(tournament, matchId).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while unmarking match as underway", (Throwable)e);
        }
        return (MatchWrapper)RetrofitUtil.parse(response);
    }

    public void unmarkMatchAsUnderway(String tournament, long matchId, Callback<MatchWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.unmarkMatchAsUnderway(tournament, matchId).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while unmarking match as underway"));
    }

    public MatchWrapper reopenMatch(String tournament, long matchId) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.reopenMatch(tournament, matchId).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while reopening match", (Throwable)e);
        }
        return (MatchWrapper)RetrofitUtil.parse(response);
    }

    public void reopenMatch(String tournament, long matchId, Callback<MatchWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.reopenMatch(tournament, matchId).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while reopening match"));
    }

    public List<AttachmentWrapper> getAttachments(String tournament, long matchId) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.getAttachments(tournament, matchId).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while getting attachments", (Throwable)e);
        }
        return (List)RetrofitUtil.parse(response);
    }

    public void getAttachments(String tournament, long matchId, Callback<List<AttachmentWrapper>> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.getAttachments(tournament, matchId).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while getting attachments"));
    }

    public AttachmentWrapper getAttachment(String tournament, long matchId, long attachmentId) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.getAttachment(tournament, matchId, attachmentId).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while getting attachment", (Throwable)e);
        }
        return (AttachmentWrapper)RetrofitUtil.parse(response);
    }

    public void getAttachment(String tournament, long matchId, long attachmentId, Callback<AttachmentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.getAttachment(tournament, matchId, attachmentId).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while getting attachment"));
    }

    public AttachmentWrapper createAttachment(String tournament, long matchId, AttachmentQuery attachment) throws DataAccessException {
        Response response;
        MultipartBody.Part asset;
        this.checkInitialized();
        MultipartBody.Part url = this.createUrlPart(attachment);
        MultipartBody.Part desc = this.createDescriptionPart(attachment);
        try {
            asset = this.createAssetPart(attachment);
        }
        catch (IOException e) {
            throw new DataAccessException("Error creating the asset body part", (Throwable)e);
        }
        try {
            response = this.challongeRetrofit.createAttachment(tournament, matchId, asset, url, desc).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while creating attachment", (Throwable)e);
        }
        return (AttachmentWrapper)RetrofitUtil.parse(response);
    }

    public void createAttachment(String tournament, long matchId, AttachmentQuery attachment, Callback<AttachmentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        MultipartBody.Part asset;
        this.checkInitialized();
        MultipartBody.Part url = this.createUrlPart(attachment);
        MultipartBody.Part desc = this.createDescriptionPart(attachment);
        try {
            asset = this.createAssetPart(attachment);
        }
        catch (IOException e) {
            onFailure.accept((Object)new DataAccessException("Error creating the asset body part", (Throwable)e));
            return;
        }
        this.challongeRetrofit.createAttachment(tournament, matchId, asset, url, desc).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while creating attachment"));
    }

    public AttachmentWrapper updateAttachment(String tournament, long matchId, long attachmentId, AttachmentQuery attachment) throws DataAccessException {
        Response response;
        MultipartBody.Part asset;
        this.checkInitialized();
        MultipartBody.Part url = this.createUrlPart(attachment);
        MultipartBody.Part desc = this.createDescriptionPart(attachment);
        try {
            asset = this.createAssetPart(attachment);
        }
        catch (IOException e) {
            throw new DataAccessException("Error creating the asset body part", (Throwable)e);
        }
        try {
            response = this.challongeRetrofit.updateAttachment(tournament, matchId, attachmentId, asset, url, desc).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while updating attachment", (Throwable)e);
        }
        return (AttachmentWrapper)RetrofitUtil.parse(response);
    }

    public void updateAttachment(String tournament, long matchId, long attachmentId, AttachmentQuery attachment, Callback<AttachmentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        MultipartBody.Part asset;
        this.checkInitialized();
        MultipartBody.Part url = this.createUrlPart(attachment);
        MultipartBody.Part desc = this.createDescriptionPart(attachment);
        try {
            asset = this.createAssetPart(attachment);
        }
        catch (IOException e) {
            onFailure.accept((Object)new DataAccessException("Error creating the asset body part", (Throwable)e));
            return;
        }
        this.challongeRetrofit.updateAttachment(tournament, matchId, attachmentId, asset, url, desc).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while updating attachment"));
    }

    public AttachmentWrapper deleteAttachment(String tournament, long matchId, long attachmentId) throws DataAccessException {
        Response response;
        this.checkInitialized();
        try {
            response = this.challongeRetrofit.deleteAttachment(tournament, matchId, attachmentId).execute();
        }
        catch (IOException e) {
            throw new DataAccessException("Error while deleting attachment", (Throwable)e);
        }
        return (AttachmentWrapper)RetrofitUtil.parse(response);
    }

    public void deleteAttachment(String tournament, long matchId, long attachmentId, Callback<AttachmentWrapper> onSuccess, Callback<DataAccessException> onFailure) {
        this.checkInitialized();
        this.challongeRetrofit.deleteAttachment(tournament, matchId, attachmentId).enqueue(RetrofitUtil.callback(onSuccess, onFailure, "Error while deleting attachment"));
    }

    private MultipartBody.Part createAssetPart(AttachmentQuery attachment) throws IOException {
        if (attachment.getAsset() != null) {
            File asset = attachment.getAsset();
            MediaType mediaType = attachment.getAssetMimeType() != null ? MediaType.parse((String)attachment.getAssetMimeType()) : null;
            RequestBody requestBody = RequestBody.create((MediaType)mediaType, (File)attachment.getAsset());
            return MultipartBody.Part.createFormData((String)"match_attachment[asset]", (String)asset.getName(), (RequestBody)requestBody);
        }
        return null;
    }

    private MultipartBody.Part createUrlPart(AttachmentQuery attachment) {
        if (attachment.getUrl() != null) {
            return MultipartBody.Part.createFormData((String)"match_attachment[url]", (String)attachment.getUrl());
        }
        return null;
    }

    private MultipartBody.Part createDescriptionPart(AttachmentQuery attachment) {
        if (attachment.getDescription() != null) {
            return MultipartBody.Part.createFormData((String)"match_attachment[description]", (String)attachment.getDescription());
        }
        return null;
    }

    @Override
    public void close() {
        this.httpClient.connectionPool().evictAll();
    }
}

