/*
 * Decompiled with CFR 0.152.
 */
package at.stefangeyer.challonge.rest.retrofit;

import at.stefangeyer.challonge.model.enumeration.MatchState;
import at.stefangeyer.challonge.model.enumeration.TournamentType;
import at.stefangeyer.challonge.model.query.enumeration.TournamentQueryState;
import at.stefangeyer.challonge.model.query.wrapper.MatchQueryWrapper;
import at.stefangeyer.challonge.model.query.wrapper.ParticipantQueryListWrapper;
import at.stefangeyer.challonge.model.query.wrapper.ParticipantQueryWrapper;
import at.stefangeyer.challonge.model.query.wrapper.TournamentQueryWrapper;
import at.stefangeyer.challonge.model.wrapper.AttachmentWrapper;
import at.stefangeyer.challonge.model.wrapper.MatchWrapper;
import at.stefangeyer.challonge.model.wrapper.ParticipantWrapper;
import at.stefangeyer.challonge.model.wrapper.TournamentWrapper;
import java.time.OffsetDateTime;
import java.util.List;
import okhttp3.MultipartBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ChallongeRetrofit {
    @GET(value="tournaments.json")
    public Call<List<TournamentWrapper>> getTournaments(@Query(value="state") TournamentQueryState var1, @Query(value="type") TournamentType var2, @Query(value="created_after") OffsetDateTime var3, @Query(value="created_before") OffsetDateTime var4, @Query(value="subdomain") String var5);

    @GET(value="tournaments/{tournament}.json")
    public Call<TournamentWrapper> getTournament(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);

    @POST(value="tournaments.json")
    public Call<TournamentWrapper> createTournament(@Body TournamentQueryWrapper var1);

    @PUT(value="tournaments/{tournament}.json")
    public Call<TournamentWrapper> updateTournament(@Path(value="tournament") String var1, @Body TournamentQueryWrapper var2);

    @DELETE(value="tournaments/{tournament}.json")
    public Call<TournamentWrapper> deleteTournament(@Path(value="tournament") String var1);

    @POST(value="tournaments/{tournament}/process_check_ins.json")
    public Call<TournamentWrapper> processCheckIns(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);

    @POST(value="tournaments/{tournament}/abort_check_in.json")
    public Call<TournamentWrapper> abortCheckIn(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);

    @POST(value="tournaments/{tournament}/start.json")
    public Call<TournamentWrapper> startTournament(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);

    @POST(value="tournaments/{tournament}/finalize.json")
    public Call<TournamentWrapper> finalizeTournament(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);

    @POST(value="tournaments/{tournament}/reset.json")
    public Call<TournamentWrapper> resetTournament(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);

    @POST(value="tournaments/{tournament}/open_for_predictions.json")
    public Call<TournamentWrapper> openTournamentForPredictions(@Path(value="tournament") String var1, @Query(value="include_participants") int var2, @Query(value="include_matches") int var3);

    @GET(value="tournaments/{tournament}/participants.json")
    public Call<List<ParticipantWrapper>> getParticipants(@Path(value="tournament") String var1);

    @GET(value="tournaments/{tournament}/participants/{participant_id}.json")
    public Call<ParticipantWrapper> getParticipant(@Path(value="tournament") String var1, @Path(value="participant_id") long var2, @Query(value="include_matches") int var4);

    @POST(value="tournaments/{tournament}/participants.json")
    public Call<ParticipantWrapper> addParticipant(@Path(value="tournament") String var1, @Body ParticipantQueryWrapper var2);

    @POST(value="tournaments/{tournament}/participants/bulk_add.json")
    public Call<List<ParticipantWrapper>> bulkAddParticipants(@Path(value="tournament") String var1, @Body ParticipantQueryListWrapper var2);

    @PUT(value="tournaments/{tournament}/participants/{participant_id}.json")
    public Call<ParticipantWrapper> updateParticipant(@Path(value="tournament") String var1, @Path(value="participant_id") long var2, @Body ParticipantQueryWrapper var4);

    @POST(value="tournaments/{tournament}/participants/{participant_id}/check_in.json")
    public Call<ParticipantWrapper> checkInParticipant(@Path(value="tournament") String var1, @Path(value="participant_id") long var2);

    @POST(value="tournaments/{tournament}/participants/{participant_id}/undo_check_in.json")
    public Call<ParticipantWrapper> undoCheckInParticipant(@Path(value="tournament") String var1, @Path(value="participant_id") long var2);

    @DELETE(value="tournaments/{tournament}/participants/{participant_id}.json")
    public Call<ParticipantWrapper> deleteParticipant(@Path(value="tournament") String var1, @Path(value="participant_id") long var2);

    @POST(value="tournaments/{tournament}/participants/randomize.json")
    public Call<List<ParticipantWrapper>> randomizeParticipants(@Path(value="tournament") String var1);

    @GET(value="tournaments/{tournament}/matches.json")
    public Call<List<MatchWrapper>> getMatches(@Path(value="tournament") String var1, @Query(value="participant_id") Long var2, @Query(value="state") MatchState var3);

    @GET(value="tournaments/{tournament}/matches/{match_id}.json")
    public Call<MatchWrapper> getMatch(@Path(value="tournament") String var1, @Path(value="match_id") long var2, @Query(value="include_attachments") int var4);

    @PUT(value="tournaments/{tournament}/matches/{match_id}.json")
    public Call<MatchWrapper> updateMatch(@Path(value="tournament") String var1, @Path(value="match_id") long var2, @Body MatchQueryWrapper var4);

    @POST(value="tournaments/{tournament}/matches/{match_id}/mark_as_underway.json")
    public Call<MatchWrapper> markMatchAsUnderway(@Path(value="tournament") String var1, @Path(value="match_id") long var2);

    @POST(value="tournaments/{tournament}/matches/{match_id}/unmark_as_underway.json")
    public Call<MatchWrapper> unmarkMatchAsUnderway(@Path(value="tournament") String var1, @Path(value="match_id") long var2);

    @POST(value="tournaments/{tournament}/matches/{match_id}/reopen.json")
    public Call<MatchWrapper> reopenMatch(@Path(value="tournament") String var1, @Path(value="match_id") long var2);

    @GET(value="tournaments/{tournament}/matches/{match_id}/attachments.json")
    public Call<List<AttachmentWrapper>> getAttachments(@Path(value="tournament") String var1, @Path(value="match_id") long var2);

    @GET(value="tournaments/{tournament}/matches/{match_id}/attachments/{attachment_id}.json")
    public Call<AttachmentWrapper> getAttachment(@Path(value="tournament") String var1, @Path(value="match_id") long var2, @Path(value="attachment_id") long var4);

    @Multipart
    @POST(value="tournaments/{tournament}/matches/{match_id}/attachments.json")
    public Call<AttachmentWrapper> createAttachment(@Path(value="tournament") String var1, @Path(value="match_id") long var2, @Part MultipartBody.Part var4, @Part MultipartBody.Part var5, @Part MultipartBody.Part var6);

    @Multipart
    @PUT(value="tournaments/{tournament}/matches/{match_id}/attachments/{attachment_id}.json")
    public Call<AttachmentWrapper> updateAttachment(@Path(value="tournament") String var1, @Path(value="match_id") long var2, @Path(value="attachment_id") long var4, @Part MultipartBody.Part var6, @Part MultipartBody.Part var7, @Part MultipartBody.Part var8);

    @DELETE(value="tournaments/{tournament}/matches/{match_id}/attachments/{attachment_id}.json")
    public Call<AttachmentWrapper> deleteAttachment(@Path(value="tournament") String var1, @Path(value="match_id") long var2, @Path(value="attachment_id") long var4);
}

