/*
 * Decompiled with CFR 0.152.
 */
package at.stefangeyer.challonge.service;

import at.stefangeyer.challonge.async.Callback;
import at.stefangeyer.challonge.exception.DataAccessException;
import at.stefangeyer.challonge.model.Attachment;
import at.stefangeyer.challonge.model.Match;
import at.stefangeyer.challonge.model.Participant;
import at.stefangeyer.challonge.model.Tournament;
import at.stefangeyer.challonge.model.enumeration.MatchState;
import at.stefangeyer.challonge.model.enumeration.TournamentType;
import at.stefangeyer.challonge.model.query.AttachmentQuery;
import at.stefangeyer.challonge.model.query.MatchQuery;
import at.stefangeyer.challonge.model.query.ParticipantQuery;
import at.stefangeyer.challonge.model.query.TournamentQuery;
import at.stefangeyer.challonge.model.query.enumeration.TournamentQueryState;
import java.time.OffsetDateTime;
import java.util.List;

public interface ChallongeService {
    public List<Tournament> getTournaments(TournamentQueryState var1, TournamentType var2, OffsetDateTime var3, OffsetDateTime var4, String var5) throws DataAccessException;

    public void getTournaments(TournamentQueryState var1, TournamentType var2, OffsetDateTime var3, OffsetDateTime var4, String var5, Callback<List<Tournament>> var6, Callback<DataAccessException> var7);

    public Tournament getTournament(String var1, boolean var2, boolean var3) throws DataAccessException;

    public void getTournament(String var1, boolean var2, boolean var3, Callback<Tournament> var4, Callback<DataAccessException> var5);

    public Tournament createTournament(TournamentQuery var1) throws DataAccessException;

    public void createTournament(TournamentQuery var1, Callback<Tournament> var2, Callback<DataAccessException> var3);

    public Tournament updateTournament(Tournament var1, TournamentQuery var2) throws DataAccessException;

    public void updateTournament(Tournament var1, TournamentQuery var2, Callback<Tournament> var3, Callback<DataAccessException> var4);

    public Tournament deleteTournament(Tournament var1) throws DataAccessException;

    public void deleteTournament(Tournament var1, Callback<Tournament> var2, Callback<DataAccessException> var3);

    public Tournament processCheckIns(Tournament var1, boolean var2, boolean var3) throws DataAccessException;

    public void processCheckIns(Tournament var1, boolean var2, boolean var3, Callback<Tournament> var4, Callback<DataAccessException> var5);

    public Tournament abortCheckIn(Tournament var1, boolean var2, boolean var3) throws DataAccessException;

    public void abortCheckIn(Tournament var1, boolean var2, boolean var3, Callback<Tournament> var4, Callback<DataAccessException> var5);

    public Tournament startTournament(Tournament var1, boolean var2, boolean var3) throws DataAccessException;

    public void startTournament(Tournament var1, boolean var2, boolean var3, Callback<Tournament> var4, Callback<DataAccessException> var5);

    public Tournament finalizeTournament(Tournament var1, boolean var2, boolean var3) throws DataAccessException;

    public void finalizeTournament(Tournament var1, boolean var2, boolean var3, Callback<Tournament> var4, Callback<DataAccessException> var5);

    public Tournament resetTournament(Tournament var1, boolean var2, boolean var3) throws DataAccessException;

    public void resetTournament(Tournament var1, boolean var2, boolean var3, Callback<Tournament> var4, Callback<DataAccessException> var5);

    public Tournament openTournamentForPredictions(Tournament var1, boolean var2, boolean var3) throws DataAccessException;

    public void openTournamentForPredictions(Tournament var1, boolean var2, boolean var3, Callback<Tournament> var4, Callback<DataAccessException> var5);

    public List<Participant> getParticipants(Tournament var1) throws DataAccessException;

    public void getParticipants(Tournament var1, Callback<List<Participant>> var2, Callback<DataAccessException> var3);

    public Participant getParticipant(Tournament var1, long var2, boolean var4) throws DataAccessException;

    public void getParticipant(Tournament var1, long var2, boolean var4, Callback<Participant> var5, Callback<DataAccessException> var6);

    public Participant addParticipant(Tournament var1, ParticipantQuery var2) throws DataAccessException;

    public void addParticipant(Tournament var1, ParticipantQuery var2, Callback<Participant> var3, Callback<DataAccessException> var4);

    public List<Participant> bulkAddParticipants(Tournament var1, List<ParticipantQuery> var2) throws DataAccessException;

    public void bulkAddParticipants(Tournament var1, List<ParticipantQuery> var2, Callback<List<Participant>> var3, Callback<DataAccessException> var4);

    public Participant updateParticipant(Participant var1, ParticipantQuery var2) throws DataAccessException;

    public void updateParticipant(Participant var1, ParticipantQuery var2, Callback<Participant> var3, Callback<DataAccessException> var4);

    public Participant checkInParticipant(Participant var1) throws DataAccessException;

    public void checkInParticipant(Participant var1, Callback<Participant> var2, Callback<DataAccessException> var3);

    public Participant undoCheckInParticipant(Participant var1) throws DataAccessException;

    public void undoCheckInParticipant(Participant var1, Callback<Participant> var2, Callback<DataAccessException> var3);

    public Participant deleteParticipant(Participant var1) throws DataAccessException;

    public void deleteParticipant(Participant var1, Callback<Participant> var2, Callback<DataAccessException> var3);

    public List<Participant> randomizeParticipants(Tournament var1) throws DataAccessException;

    public void randomizeParticipants(Tournament var1, Callback<List<Participant>> var2, Callback<DataAccessException> var3);

    public List<Match> getMatches(Tournament var1, Participant var2, MatchState var3) throws DataAccessException;

    public void getMatches(Tournament var1, Participant var2, MatchState var3, Callback<List<Match>> var4, Callback<DataAccessException> var5);

    public Match getMatch(Tournament var1, long var2, boolean var4) throws DataAccessException;

    public void getMatch(Tournament var1, long var2, boolean var4, Callback<Match> var5, Callback<DataAccessException> var6);

    public Match updateMatch(Match var1, MatchQuery var2) throws DataAccessException;

    public void updateMatch(Match var1, MatchQuery var2, Callback<Match> var3, Callback<DataAccessException> var4);

    public Match markMatchAsUnderway(Match var1) throws DataAccessException;

    public void markMatchAsUnderway(Match var1, Callback<Match> var2, Callback<DataAccessException> var3);

    public Match unmarkMatchAsUnderway(Match var1) throws DataAccessException;

    public void unmarkMatchAsUnderway(Match var1, Callback<Match> var2, Callback<DataAccessException> var3);

    public Match reopenMatch(Match var1) throws DataAccessException;

    public void reopenMatch(Match var1, Callback<Match> var2, Callback<DataAccessException> var3);

    public List<Attachment> getAttachments(Match var1) throws DataAccessException;

    public void getAttachments(Match var1, Callback<List<Attachment>> var2, Callback<DataAccessException> var3);

    public Attachment getAttachment(Match var1, long var2) throws DataAccessException;

    public void getAttachment(Match var1, long var2, Callback<Attachment> var4, Callback<DataAccessException> var5);

    public Attachment createAttachment(Match var1, AttachmentQuery var2) throws DataAccessException;

    public void createAttachment(Match var1, AttachmentQuery var2, Callback<Attachment> var3, Callback<DataAccessException> var4);

    public Attachment updateAttachment(Match var1, Attachment var2, AttachmentQuery var3) throws DataAccessException;

    public void updateAttachment(Match var1, Attachment var2, AttachmentQuery var3, Callback<Attachment> var4, Callback<DataAccessException> var5);

    public Attachment deleteAttachment(Match var1, Attachment var2) throws DataAccessException;

    public void deleteAttachment(Match var1, Attachment var2, Callback<Attachment> var3, Callback<DataAccessException> var4);
}

