/*
 * Decompiled with CFR 0.152.
 */
package at.stefangeyer.challonge;

import at.stefangeyer.challonge.async.Callback;
import at.stefangeyer.challonge.exception.DataAccessException;
import at.stefangeyer.challonge.model.Attachment;
import at.stefangeyer.challonge.model.Credentials;
import at.stefangeyer.challonge.model.Match;
import at.stefangeyer.challonge.model.Participant;
import at.stefangeyer.challonge.model.Tournament;
import at.stefangeyer.challonge.model.enumeration.MatchState;
import at.stefangeyer.challonge.model.enumeration.TournamentType;
import at.stefangeyer.challonge.model.query.AttachmentQuery;
import at.stefangeyer.challonge.model.query.MatchQuery;
import at.stefangeyer.challonge.model.query.ParticipantQuery;
import at.stefangeyer.challonge.model.query.TournamentQuery;
import at.stefangeyer.challonge.model.query.enumeration.TournamentQueryState;
import at.stefangeyer.challonge.rest.RestClient;
import at.stefangeyer.challonge.serializer.Serializer;
import at.stefangeyer.challonge.service.ChallongeService;
import at.stefangeyer.challonge.service.implementation.SimpleChallongeService;
import java.time.OffsetDateTime;
import java.util.List;

public class Challonge
implements ChallongeService {
    private ChallongeService service;

    public Challonge(Credentials credentials, Serializer serializer, RestClient restClient) {
        restClient.initialize(credentials, serializer);
        this.service = new SimpleChallongeService(restClient);
    }

    @Override
    public final List<Tournament> getTournaments(TournamentQueryState state, TournamentType type, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String subdomain) throws DataAccessException {
        return this.service.getTournaments(state, type, createdAfter, createdBefore, subdomain);
    }

    public final List<Tournament> getTournaments() throws DataAccessException {
        return this.getTournaments(null, null, null, null, null);
    }

    @Override
    public final void getTournaments(TournamentQueryState state, TournamentType type, OffsetDateTime createdAfter, OffsetDateTime createdBefore, String subdomain, Callback<List<Tournament>> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.getTournaments(state, type, createdAfter, createdBefore, subdomain, onSuccess, onFailure);
    }

    public final void getTournaments(TournamentQueryState state, TournamentType type, OffsetDateTime createdAfter, OffsetDateTime createdBefore, Callback<List<Tournament>> onSuccess, Callback<DataAccessException> onFailure) {
        this.getTournaments(state, type, createdAfter, createdBefore, null, onSuccess, onFailure);
    }

    public final void getTournaments(Callback<List<Tournament>> onSuccess, Callback<DataAccessException> onFailure) {
        this.getTournaments(null, null, null, null, null, onSuccess, onFailure);
    }

    @Override
    public final Tournament getTournament(String tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        return this.service.getTournament(tournament, includeParticipants, includeMatches);
    }

    public final Tournament getTournament(String tournament) throws DataAccessException {
        return this.getTournament(tournament, false, false);
    }

    @Override
    public final void getTournament(String tournament, boolean includeParticipants, boolean includeMatches, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.getTournament(tournament, includeParticipants, includeMatches, onSuccess, onFailure);
    }

    public final void getTournament(String tournament, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.getTournament(tournament, false, false, onSuccess, onFailure);
    }

    @Override
    public final Tournament createTournament(TournamentQuery data) throws DataAccessException {
        return this.service.createTournament(data);
    }

    @Override
    public final void createTournament(TournamentQuery data, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.createTournament(data, onSuccess, onFailure);
    }

    @Override
    public final Tournament updateTournament(Tournament tournament, TournamentQuery data) throws DataAccessException {
        return this.service.updateTournament(tournament, data);
    }

    @Override
    public final void updateTournament(Tournament tournament, TournamentQuery data, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.updateTournament(tournament, data, onSuccess, onFailure);
    }

    @Override
    public final Tournament deleteTournament(Tournament tournament) throws DataAccessException {
        return this.service.deleteTournament(tournament);
    }

    @Override
    public final void deleteTournament(Tournament tournament, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.deleteTournament(tournament, onSuccess, onFailure);
    }

    @Override
    public final Tournament processCheckIns(Tournament tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        return this.service.processCheckIns(tournament, includeParticipants, includeMatches);
    }

    public final Tournament processCheckIns(Tournament tournament) throws DataAccessException {
        return this.processCheckIns(tournament, false, false);
    }

    @Override
    public final void processCheckIns(Tournament tournament, boolean includeParticipants, boolean includeMatches, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.processCheckIns(tournament, includeParticipants, includeMatches, onSuccess, onFailure);
    }

    public final void processCheckIns(Tournament tournament, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.processCheckIns(tournament, false, false, onSuccess, onFailure);
    }

    @Override
    public final Tournament abortCheckIn(Tournament tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        return this.service.abortCheckIn(tournament, includeParticipants, includeMatches);
    }

    public final Tournament abortCheckIn(Tournament tournament) throws DataAccessException {
        return this.abortCheckIn(tournament, false, false);
    }

    @Override
    public final void abortCheckIn(Tournament tournament, boolean includeParticipants, boolean includeMatches, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.abortCheckIn(tournament, includeParticipants, includeMatches, onSuccess, onFailure);
    }

    public final void abortCheckIn(Tournament tournament, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.abortCheckIn(tournament, false, false, onSuccess, onFailure);
    }

    @Override
    public final Tournament startTournament(Tournament tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        return this.service.startTournament(tournament, includeParticipants, includeMatches);
    }

    public final Tournament startTournament(Tournament tournament) throws DataAccessException {
        return this.startTournament(tournament, false, false);
    }

    @Override
    public final void startTournament(Tournament tournament, boolean includeParticipants, boolean includeMatches, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.startTournament(tournament, includeParticipants, includeMatches, onSuccess, onFailure);
    }

    public final void startTournament(Tournament tournament, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.startTournament(tournament, false, false, onSuccess, onFailure);
    }

    @Override
    public final Tournament finalizeTournament(Tournament tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        return this.service.finalizeTournament(tournament, includeParticipants, includeMatches);
    }

    public final Tournament finalizeTournament(Tournament tournament) throws DataAccessException {
        return this.finalizeTournament(tournament, false, false);
    }

    @Override
    public final void finalizeTournament(Tournament tournament, boolean includeParticipants, boolean includeMatches, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.finalizeTournament(tournament, includeParticipants, includeMatches, onSuccess, onFailure);
    }

    public final void finalizeTournament(Tournament tournament, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.finalizeTournament(tournament, false, false, onSuccess, onFailure);
    }

    @Override
    public final Tournament resetTournament(Tournament tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        return this.service.resetTournament(tournament, includeParticipants, includeMatches);
    }

    public final Tournament resetTournament(Tournament tournament) throws DataAccessException {
        return this.resetTournament(tournament, false, false);
    }

    @Override
    public final void resetTournament(Tournament tournament, boolean includeParticipants, boolean includeMatches, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.resetTournament(tournament, includeParticipants, includeMatches, onSuccess, onFailure);
    }

    public final void resetTournament(Tournament tournament, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.resetTournament(tournament, false, false, onSuccess, onFailure);
    }

    @Override
    public final Tournament openTournamentForPredictions(Tournament tournament, boolean includeParticipants, boolean includeMatches) throws DataAccessException {
        return this.service.openTournamentForPredictions(tournament, includeParticipants, includeMatches);
    }

    public final Tournament openTournamentForPredictions(Tournament tournament) throws DataAccessException {
        return this.openTournamentForPredictions(tournament, false, false);
    }

    @Override
    public final void openTournamentForPredictions(Tournament tournament, boolean includeParticipants, boolean includeMatches, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.openTournamentForPredictions(tournament, includeParticipants, includeMatches, onSuccess, onFailure);
    }

    public final void openTournamentForPredictions(Tournament tournament, Callback<Tournament> onSuccess, Callback<DataAccessException> onFailure) {
        this.openTournamentForPredictions(tournament, false, false, onSuccess, onFailure);
    }

    @Override
    public final List<Participant> getParticipants(Tournament tournament) throws DataAccessException {
        return this.service.getParticipants(tournament);
    }

    @Override
    public final void getParticipants(Tournament tournament, Callback<List<Participant>> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.getParticipants(tournament, onSuccess, onFailure);
    }

    @Override
    public final Participant getParticipant(Tournament tournament, long participantId, boolean includeMatches) throws DataAccessException {
        return this.service.getParticipant(tournament, participantId, includeMatches);
    }

    public final Participant getParticipant(Tournament tournament, long participantId) throws DataAccessException {
        return this.service.getParticipant(tournament, participantId, false);
    }

    @Override
    public final void getParticipant(Tournament tournament, long participantId, boolean includeMatches, Callback<Participant> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.getParticipant(tournament, participantId, includeMatches, onSuccess, onFailure);
    }

    public final void getParticipant(Tournament tournament, long participantId, Callback<Participant> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.getParticipant(tournament, participantId, false, onSuccess, onFailure);
    }

    @Override
    public final Participant addParticipant(Tournament tournament, ParticipantQuery data) throws DataAccessException {
        return this.service.addParticipant(tournament, data);
    }

    @Override
    public final void addParticipant(Tournament tournament, ParticipantQuery data, Callback<Participant> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.addParticipant(tournament, data, onSuccess, onFailure);
    }

    @Override
    public final List<Participant> bulkAddParticipants(Tournament tournament, List<ParticipantQuery> data) throws DataAccessException {
        return this.service.bulkAddParticipants(tournament, data);
    }

    @Override
    public final void bulkAddParticipants(Tournament tournament, List<ParticipantQuery> data, Callback<List<Participant>> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.bulkAddParticipants(tournament, data, onSuccess, onFailure);
    }

    @Override
    public final Participant updateParticipant(Participant participant, ParticipantQuery data) throws DataAccessException {
        return this.service.updateParticipant(participant, data);
    }

    @Override
    public final void updateParticipant(Participant participant, ParticipantQuery data, Callback<Participant> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.updateParticipant(participant, data, onSuccess, onFailure);
    }

    @Override
    public final Participant checkInParticipant(Participant participant) throws DataAccessException {
        return this.service.checkInParticipant(participant);
    }

    @Override
    public final void checkInParticipant(Participant participant, Callback<Participant> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.checkInParticipant(participant, onSuccess, onFailure);
    }

    @Override
    public final Participant undoCheckInParticipant(Participant participant) throws DataAccessException {
        return this.service.undoCheckInParticipant(participant);
    }

    @Override
    public final void undoCheckInParticipant(Participant participant, Callback<Participant> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.undoCheckInParticipant(participant, onSuccess, onFailure);
    }

    @Override
    public final Participant deleteParticipant(Participant participant) throws DataAccessException {
        return this.service.deleteParticipant(participant);
    }

    @Override
    public final void deleteParticipant(Participant participant, Callback<Participant> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.deleteParticipant(participant, onSuccess, onFailure);
    }

    @Override
    public final List<Participant> randomizeParticipants(Tournament tournament) throws DataAccessException {
        return this.service.randomizeParticipants(tournament);
    }

    @Override
    public final void randomizeParticipants(Tournament tournament, Callback<List<Participant>> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.randomizeParticipants(tournament, onSuccess, onFailure);
    }

    @Override
    public final List<Match> getMatches(Tournament tournament, Participant participant, MatchState state) throws DataAccessException {
        return this.service.getMatches(tournament, participant, state);
    }

    public final List<Match> getMatches(Tournament tournament, Participant participant) throws DataAccessException {
        return this.getMatches(tournament, participant, null);
    }

    public final List<Match> getMatches(Tournament tournament) throws DataAccessException {
        return this.getMatches(tournament, (Participant)null, null);
    }

    @Override
    public final void getMatches(Tournament tournament, Participant participant, MatchState state, Callback<List<Match>> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.getMatches(tournament, participant, state, onSuccess, onFailure);
    }

    public final void getMatches(Tournament tournament, Participant participant, Callback<List<Match>> onSuccess, Callback<DataAccessException> onFailure) {
        this.getMatches(tournament, participant, null, onSuccess, onFailure);
    }

    public final void getMatches(Tournament tournament, Callback<List<Match>> onSuccess, Callback<DataAccessException> onFailure) {
        this.getMatches(tournament, null, null, onSuccess, onFailure);
    }

    @Override
    public final Match getMatch(Tournament tournament, long matchId, boolean includeAttachments) throws DataAccessException {
        return this.service.getMatch(tournament, matchId, includeAttachments);
    }

    public final Match getMatch(Tournament tournament, long matchId) throws DataAccessException {
        return this.getMatch(tournament, matchId, false);
    }

    @Override
    public final void getMatch(Tournament tournament, long matchId, boolean includeAttachments, Callback<Match> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.getMatch(tournament, matchId, includeAttachments, onSuccess, onFailure);
    }

    public final void getMatch(Tournament tournament, long matchId, Callback<Match> onSuccess, Callback<DataAccessException> onFailure) {
        this.getMatch(tournament, matchId, false, onSuccess, onFailure);
    }

    @Override
    public final Match updateMatch(Match match, MatchQuery data) throws DataAccessException {
        return this.service.updateMatch(match, data);
    }

    @Override
    public final void updateMatch(Match match, MatchQuery data, Callback<Match> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.updateMatch(match, data, onSuccess, onFailure);
    }

    @Override
    public final Match markMatchAsUnderway(Match match) throws DataAccessException {
        return this.service.markMatchAsUnderway(match);
    }

    @Override
    public final void markMatchAsUnderway(Match match, Callback<Match> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.markMatchAsUnderway(match, onSuccess, onFailure);
    }

    @Override
    public final Match unmarkMatchAsUnderway(Match match) throws DataAccessException {
        return this.service.unmarkMatchAsUnderway(match);
    }

    @Override
    public final void unmarkMatchAsUnderway(Match match, Callback<Match> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.unmarkMatchAsUnderway(match, onSuccess, onFailure);
    }

    @Override
    public final Match reopenMatch(Match match) throws DataAccessException {
        return this.service.reopenMatch(match);
    }

    @Override
    public final void reopenMatch(Match match, Callback<Match> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.reopenMatch(match, onSuccess, onFailure);
    }

    @Override
    public final List<Attachment> getAttachments(Match match) throws DataAccessException {
        return this.service.getAttachments(match);
    }

    @Override
    public final void getAttachments(Match match, Callback<List<Attachment>> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.getAttachments(match, onSuccess, onFailure);
    }

    @Override
    public final Attachment getAttachment(Match match, long attachmentId) throws DataAccessException {
        return this.service.getAttachment(match, attachmentId);
    }

    @Override
    public final void getAttachment(Match match, long attachmentId, Callback<Attachment> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.getAttachment(match, attachmentId, onSuccess, onFailure);
    }

    @Override
    public final Attachment createAttachment(Match match, AttachmentQuery data) throws DataAccessException {
        return this.service.createAttachment(match, data);
    }

    @Override
    public final void createAttachment(Match match, AttachmentQuery data, Callback<Attachment> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.createAttachment(match, data, onSuccess, onFailure);
    }

    @Override
    public final Attachment updateAttachment(Match match, Attachment attachment, AttachmentQuery data) throws DataAccessException {
        return this.service.updateAttachment(match, attachment, data);
    }

    @Override
    public final void updateAttachment(Match match, Attachment attachment, AttachmentQuery data, Callback<Attachment> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.updateAttachment(match, attachment, data, onSuccess, onFailure);
    }

    @Override
    public final Attachment deleteAttachment(Match match, Attachment attachment) throws DataAccessException {
        return this.service.deleteAttachment(match, attachment);
    }

    @Override
    public final void deleteAttachment(Match match, Attachment attachment, Callback<Attachment> onSuccess, Callback<DataAccessException> onFailure) {
        this.service.deleteAttachment(match, attachment, onSuccess, onFailure);
    }
}

