/*
 * Decompiled with CFR 0.152.
 */
package at.stefangeyer.challonge.model.query;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class AttachmentQuery {
    private File asset;
    private String url;
    private String description;

    public String getAssetMimeType() throws IOException {
        return this.asset != null ? Files.probeContentType(this.asset.toPath()) : null;
    }

    AttachmentQuery(File asset, String url, String description) {
        this.asset = asset;
        this.url = url;
        this.description = description;
    }

    public static AttachmentQueryBuilder builder() {
        return new AttachmentQueryBuilder();
    }

    public File getAsset() {
        return this.asset;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public void setAsset(File asset) {
        this.asset = asset;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttachmentQuery)) {
            return false;
        }
        AttachmentQuery other = (AttachmentQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$asset = this.getAsset();
        File other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttachmentQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "AttachmentQuery(asset=" + this.getAsset() + ", url=" + this.getUrl() + ", description=" + this.getDescription() + ")";
    }

    public static class AttachmentQueryBuilder {
        private File asset;
        private String url;
        private String description;

        AttachmentQueryBuilder() {
        }

        public AttachmentQueryBuilder asset(File asset) {
            this.asset = asset;
            return this;
        }

        public AttachmentQueryBuilder url(String url) {
            this.url = url;
            return this;
        }

        public AttachmentQueryBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AttachmentQuery build() {
            return new AttachmentQuery(this.asset, this.url, this.description);
        }

        public String toString() {
            return "AttachmentQuery.AttachmentQueryBuilder(asset=" + this.asset + ", url=" + this.url + ", description=" + this.description + ")";
        }
    }
}

