/*
 * Decompiled with CFR 0.152.
 */
package at.salzburgresearch.nodekeeper.eca.function;

import at.salzburgresearch.nodekeeper.eca.function.Concat;
import at.salzburgresearch.nodekeeper.eca.function.CurrentNodeData;
import at.salzburgresearch.nodekeeper.eca.function.CurrentNodeLabel;
import at.salzburgresearch.nodekeeper.eca.function.Function;
import at.salzburgresearch.nodekeeper.eca.function.NodeData;
import at.salzburgresearch.nodekeeper.eca.function.OrFunction;
import at.salzburgresearch.nodekeeper.eca.function.Parent;
import at.salzburgresearch.nodekeeper.eca.function.PathNode;
import at.salzburgresearch.nodekeeper.eca.function.SearchReplace;
import at.salzburgresearch.nodekeeper.eca.function.StaticValueFunction;
import at.salzburgresearch.nodekeeper.eca.function.ToUpperCase;
import java.util.HashMap;

public class FunctionFactory {
    public static HashMap<String, Class> functions = new HashMap<String, Class>(){
        {
            this.put("currentNodeData", CurrentNodeData.class);
            this.put("currentNodeLabel", CurrentNodeLabel.class);
            this.put("staticValue", StaticValueFunction.class);
            this.put("toUpperCase", ToUpperCase.class);
            this.put("nodeData", NodeData.class);
            this.put("pathNode", PathNode.class);
            this.put("searchReplace", SearchReplace.class);
            this.put("concat", Concat.class);
            this.put("parentNode", Parent.class);
            this.put("or", OrFunction.class);
        }
    };

    public static Function createFunction(String clazzname, Object ... args) {
        try {
            if (!functions.containsKey(clazzname)) {
                throw new RuntimeException(String.format("Function %s is not supported", clazzname));
            }
            Function f = (Function)functions.get(clazzname).newInstance();
            f.init(args);
            return f;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(String.format("Function %s cannot be instantiated", clazzname), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Function %s cannot be instantiated", clazzname), e);
        }
    }
}

