/*
 * Decompiled with CFR 0.152.
 */
package at.salzburgresearch.nodekeeper.eca;

import at.salzburgresearch.nodekeeper.NodeKeeper;
import at.salzburgresearch.nodekeeper.NodeListener;
import at.salzburgresearch.nodekeeper.eca.Action;
import at.salzburgresearch.nodekeeper.eca.Binding;
import at.salzburgresearch.nodekeeper.eca.Condition;
import at.salzburgresearch.nodekeeper.eca.Event;
import at.salzburgresearch.nodekeeper.eca.Rule;
import at.salzburgresearch.nodekeeper.eca.function.Function;
import at.salzburgresearch.nodekeeper.eca.function.FunctionFactory;
import at.salzburgresearch.nodekeeper.eca.function.StaticValueFunction;
import at.salzburgresearch.nodekeeper.exception.NodeKeeperException;
import at.salzburgresearch.nodekeeper.model.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleHandler {
    HashMap<String, Rule> rules = new HashMap();
    NodeKeeper nodeKeeper;

    public RuleHandler(NodeKeeper nodeKeeper) {
        this.nodeKeeper = nodeKeeper;
    }

    public void readRules(InputStream stream) throws NodeKeeperException, IOException, InterruptedException {
        List<Rule> rs = InputOutputHandler.parseRules(stream);
        ArrayList<String> keys = new ArrayList<String>(this.rules.keySet());
        for (String ruleid : keys) {
            this.removeRule(this.rules.get(ruleid));
        }
        for (Rule rule : rs) {
            this.addRule(rule);
        }
    }

    public void writeRules(OutputStream stream) throws ParserConfigurationException, TransformerException, IOException {
        ArrayList<Rule> r = new ArrayList<Rule>();
        for (String ruleid : this.rules.keySet()) {
            r.add(this.rules.get(ruleid));
        }
        InputOutputHandler.serializeRules(r, stream);
    }

    public void addRule(Rule rule) throws NodeKeeperException, IOException, InterruptedException {
        this.deactivateRule(rule);
        this.activateRule(rule);
        this.rules.put(rule.id, rule);
    }

    public Rule getRule(String id) {
        return this.rules.get(id);
    }

    public Set<String> getRuleIds() {
        return this.rules.keySet();
    }

    public void removeRule(Rule rule) {
        this.deactivateRule(rule);
        this.rules.remove(rule.id);
    }

    private void activateRule(final Rule rule) throws NodeKeeperException, IOException, InterruptedException {
        rule.setNodeListener(new NodeListener(){

            private void execute(Node node) throws InterruptedException, IOException, NodeKeeperException {
                HashMap<String, String> bindings = this.bindVariables(node);
                if (this.checkConditions(bindings)) {
                    for (Action action : rule.actions) {
                        action.execute(this.nodekeeper, bindings);
                    }
                }
            }

            private HashMap<String, String> bindVariables(Node node) {
                HashMap<String, String> bindings = new HashMap<String, String>();
                for (Binding binding : rule.bindings) {
                    bindings.put(binding.name, binding.execute(this.nodekeeper, node));
                }
                return bindings;
            }

            private boolean checkConditions(HashMap<String, String> bindings) {
                boolean result = true;
                for (Condition condition : rule.conditions) {
                    result = condition.execute(bindings);
                }
                return result;
            }

            public void onNodeCreated(Node node) throws InterruptedException, NodeKeeperException {
                if (rule.event.type == Event.Type.nodeCreated || rule.event.type == Event.Type.nodeCreatedUpdated) {
                    try {
                        this.execute(node);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onNodeUpdated(Node node) throws InterruptedException, NodeKeeperException {
                if (rule.event.type == Event.Type.nodeUpdated || rule.event.type == Event.Type.nodeCreatedUpdated) {
                    try {
                        this.execute(node);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onNodeDeleted(Node node) throws InterruptedException, NodeKeeperException {
                if (rule.event.type == Event.Type.nodeDeleted) {
                    try {
                        this.execute(node);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            public Class getType() {
                return rule.event.nodeType;
            }
        });
        this.nodeKeeper.addListener(rule.event.pattern, rule.getNodeListener());
        this.nodeKeeper.startListeners();
    }

    private void deactivateRule(Rule rule) {
        if (this.rules.containsKey(rule.id)) {
            Rule r = this.rules.get(rule.id);
            this.nodeKeeper.removeListener(r.event.pattern, r.getNodeListener());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InputOutputHandler {
        public static List<Rule> parseRules(InputStream inputStream) throws IOException {
            try {
                ArrayList<Rule> rules = new ArrayList<Rule>();
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(inputStream);
                NodeList rulesNodes = doc.getDocumentElement().getChildNodes();
                for (int i = 0; i < rulesNodes.getLength(); ++i) {
                    Object type;
                    org.w3c.dom.Node ruleNode = rulesNodes.item(i);
                    if (ruleNode.getNodeType() != 1) continue;
                    Element ruleElement = (Element)ruleNode;
                    Rule rule = new Rule();
                    if (ruleElement.getAttribute("name") != null) {
                        rule.id = ruleElement.getAttribute("name");
                    }
                    NodeList events = ruleElement.getElementsByTagName("event");
                    NodeList bindings = ruleElement.getElementsByTagName("bindings");
                    NodeList conditions = ruleElement.getElementsByTagName("conditions");
                    NodeList actions = ruleElement.getElementsByTagName("actions");
                    for (int j = 0; j < events.getLength(); ++j) {
                        org.w3c.dom.Node eventNode = events.item(j);
                        if (eventNode.getNodeType() != 1) continue;
                        Element eventElement = (Element)eventNode;
                        String typeString = eventElement.getAttribute("type");
                        if (typeString == null) {
                            throw new IOException(String.format("Type of event #$s in rule #%s must be set", j, i));
                        }
                        if (eventElement.getElementsByTagName("params").getLength() < 0) {
                            throw new IOException(String.format("Type of event #$s in rule #%s must have a param", j, i));
                        }
                        Event.Type type2 = Event.Type.valueOf(typeString);
                        if (type2 == null) {
                            throw new IOException(String.format("Type %s of event #$s in rule #%s is not supported", typeString, j, i));
                        }
                        rule.event = new Event(type2, eventElement.getElementsByTagName("param").item(0).getTextContent().trim());
                    }
                    if (rule.event == null) {
                        throw new IOException(String.format("Rule #%s must contain an event element", i));
                    }
                    if (bindings.getLength() > 0) {
                        NodeList bindingList = bindings.item(0).getChildNodes();
                        for (int j = 0; j < bindingList.getLength(); ++j) {
                            Function f;
                            org.w3c.dom.Node bindingNode = bindingList.item(j);
                            if (bindingNode.getNodeType() != 1) continue;
                            Element bindingElement = (Element)bindingNode;
                            String name = bindingElement.getAttribute("name");
                            type = bindingElement.getAttribute("type");
                            if (type == null || type.equals("")) {
                                f = new StaticValueFunction();
                                f.init(bindingElement.getTextContent().trim());
                                rule.bindings.add(new Binding(name, f));
                                continue;
                            }
                            f = InputOutputHandler.createFunction(type, bindingElement.getChildNodes());
                            rule.bindings.add(new Binding(name, f));
                        }
                    }
                    if (actions.getLength() > 0) {
                        NodeList actionList = actions.item(0).getChildNodes();
                        for (int j = 0; j < actionList.getLength(); ++j) {
                            org.w3c.dom.Node actionNode = actionList.item(j);
                            if (actionNode.getNodeType() != 1) continue;
                            Element actionElement = (Element)actionNode;
                            String typeString = actionElement.getAttribute("type");
                            if (typeString == null) {
                                throw new IOException(String.format("Type of action #$s in rule #%s must be set", j, i));
                            }
                            type = Action.Type.valueOf(typeString);
                            if (type == null) {
                                throw new IOException(String.format("Type %s of event #$s in rule #%s is not supported", typeString, j, i));
                            }
                            NodeList paramNodes = actionElement.getElementsByTagName("param");
                            String[] params = new String[paramNodes.getLength()];
                            for (int k = 0; k < paramNodes.getLength(); ++k) {
                                org.w3c.dom.Node paramNode = paramNodes.item(k);
                                if (paramNode.getNodeType() != 1) continue;
                                Element paramElement = (Element)paramNode;
                                params[k] = paramElement.getTextContent().trim();
                            }
                            rule.actions.add(new Action((Action.Type)((Object)type), params));
                        }
                    }
                    rules.add(rule);
                }
                return rules;
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }

        private static Function createFunction(String name, NodeList params) {
            Function f = FunctionFactory.createFunction(name, new Object[0]);
            ArrayList<StaticValueFunction> paramObjects = new ArrayList<StaticValueFunction>();
            for (int i = 0; i < params.getLength(); ++i) {
                Function fx;
                org.w3c.dom.Node paramNode = params.item(i);
                if (paramNode.getNodeType() != 1) continue;
                Element param = (Element)paramNode;
                String pname = param.getAttribute("name");
                String ptype = param.getAttribute("type");
                if (ptype == null || ptype.equals("")) {
                    fx = new StaticValueFunction();
                    fx.init(param.getTextContent());
                    paramObjects.add((StaticValueFunction)fx);
                    continue;
                }
                fx = InputOutputHandler.createFunction(ptype, param.getChildNodes());
                paramObjects.add((StaticValueFunction)fx);
            }
            f.init(paramObjects.toArray());
            return f;
        }

        public static void serializeRules(List<Rule> rules, OutputStream stream) throws ParserConfigurationException, TransformerException, IOException {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("rules");
            doc.appendChild(rootElement);
            for (Rule rule : rules) {
                rootElement.appendChild(rule.toElement(doc));
            }
            DOMSource domSource = new DOMSource(doc);
            StreamResult result = new StreamResult(stream);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            stream.flush();
        }
    }
}

