/*
 * Decompiled with CFR 0.152.
 */
package at.salzburgresearch.nodekeeper.eca;

import at.salzburgresearch.nodekeeper.NodeKeeper;
import at.salzburgresearch.nodekeeper.exception.NodeKeeperException;
import at.salzburgresearch.nodekeeper.model.Node;
import java.io.IOException;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Action {
    private Type type;
    private String[] args;

    public Action(Type type, String ... args) {
        this.type = type;
        this.args = args;
    }

    public void execute(NodeKeeper nodeKeeper, HashMap<String, String> bindings) throws InterruptedException, NodeKeeperException, IOException {
        switch (this.type) {
            case createUpdateNode: {
                this.createUpdateNode(nodeKeeper, bindings);
                break;
            }
            case deleteNode: {
                this.deleteNode(nodeKeeper, bindings);
            }
        }
    }

    private void createUpdateNode(NodeKeeper nodeKeeper, HashMap<String, String> bindings) throws InterruptedException, IOException, NodeKeeperException {
        nodeKeeper.writeNode(this.prepareNode(nodeKeeper, bindings), String.class);
    }

    private void deleteNode(NodeKeeper nodeKeeper, HashMap<String, String> bindings) throws NodeKeeperException, InterruptedException {
        nodeKeeper.deleteNode(this.prepareNode(nodeKeeper, bindings));
    }

    private Node prepareNode(NodeKeeper nodeKeeper, HashMap<String, String> bindings) {
        String data = this.args.length > 1 ? this.args[1] : "";
        String label = this.args[0];
        for (String name : bindings.keySet()) {
            data = data.replaceAll("\\{" + name + "\\}", bindings.get(name));
            label = label.replaceAll("\\{" + name + "\\}", bindings.get(name));
        }
        Node<String> node = new Node<String>(label, data);
        return node;
    }

    public Element toElement(Document doc) {
        Element element = doc.createElement("action");
        element.setAttribute("type", this.type.name());
        for (String arg : this.args) {
            Element p = doc.createElement("param");
            p.setTextContent(arg);
            element.appendChild(p);
        }
        return element;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        createUpdateNode,
        deleteNode;

    }
}

