/*
 * Decompiled with CFR 0.152.
 */
package at.salzburgresearch.nodekeeper;

import at.salzburgresearch.nodekeeper.NodeListener;
import at.salzburgresearch.nodekeeper.exception.NodeKeeperException;
import at.salzburgresearch.nodekeeper.handlers.DataHandler;
import at.salzburgresearch.nodekeeper.handlers.impl.BooleanHandler;
import at.salzburgresearch.nodekeeper.handlers.impl.DictionaryDataHandler;
import at.salzburgresearch.nodekeeper.handlers.impl.IntegerHandler;
import at.salzburgresearch.nodekeeper.handlers.impl.StringDataHandler;
import at.salzburgresearch.nodekeeper.model.Node;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeKeeper
implements Watcher {
    private static Logger log = LoggerFactory.getLogger(NodeKeeper.class);
    private static HashMap<Class, DataHandler> handlers = new HashMap();
    private static final String PATH_SEPARATOR = "/";
    private ZooKeeper zk;
    private Properties properties;
    private String startNode;
    private String connectionString;
    private int sessionTimeout;
    private HashMap<String, List<NodeListener>> listeners = new HashMap();

    public NodeKeeper(String connectionString, int sessionTimeout, Properties properties, String startNode) throws InterruptedException, IOException, NodeKeeperException {
        this.properties = properties;
        this.startNode = startNode == null ? PATH_SEPARATOR : startNode;
        this.connectionString = connectionString;
        this.sessionTimeout = sessionTimeout;
        this.addDataHandler(new StringDataHandler());
        this.addDataHandler(new DictionaryDataHandler());
        this.addDataHandler(new IntegerHandler());
        this.addDataHandler(new BooleanHandler());
        final CountDownLatch connectedSignal = new CountDownLatch(1);
        this.zk = new ZooKeeper(connectionString, sessionTimeout, new Watcher(){

            public void process(WatchedEvent event) {
                switch (event.getState()) {
                    case SyncConnected: {
                        connectedSignal.countDown();
                    }
                }
            }
        });
        connectedSignal.await();
        log.info(" - nodekeeper initialized");
    }

    public void startListeners() throws InterruptedException, NodeKeeperException, IOException {
        try {
            this.deleteRemoved();
            this.appendWatcherToSubnodes(this.startNode);
        }
        catch (KeeperException e) {
            throw new NodeKeeperException("cannot append listeners");
        }
    }

    private void appendWatcherToSubnodes(String path) throws KeeperException, InterruptedException, NodeKeeperException, IOException {
        Stat stat = this.zk.exists(path, (Watcher)this);
        if (stat != null) {
            Watcher.Event.EventType version = this.getStatus(path, stat.getVersion());
            if (version != null) {
                this.handleNode(path, stat, version);
            }
            for (String child : this.zk.getChildren(path, (Watcher)this)) {
                this.appendWatcherToSubnodes((path.equals(PATH_SEPARATOR) ? "" : path) + PATH_SEPARATOR + child);
            }
        }
    }

    private void handleNode(String path, Stat stat, Watcher.Event.EventType version) throws KeeperException, InterruptedException, NodeKeeperException, IOException {
        this.setStatus(path, stat.getVersion());
        for (String pattern : this.listeners.keySet()) {
            if (!path.matches(pattern)) continue;
            for (NodeListener listener : this.listeners.get(pattern)) {
                if (handlers.containsKey(listener.getType())) {
                    switch (version) {
                        case NodeCreated: {
                            listener.onNodeCreated(new Node(path, handlers.get(listener.getType()).parse(this.zk.getData(path, (Watcher)this, stat))));
                            this.setStatus(path, stat.getVersion());
                            break;
                        }
                        case NodeDataChanged: {
                            listener.onNodeUpdated(new Node(path, handlers.get(listener.getType()).parse(this.zk.getData(path, (Watcher)this, stat))));
                            this.setStatus(path, stat.getVersion());
                            break;
                        }
                        case NodeDeleted: {
                            listener.onNodeDeleted(new Node(path));
                            this.removeStatus(path);
                        }
                    }
                    continue;
                }
                throw new NodeKeeperException(String.format("cannot handle type %s", listener.getType()));
            }
        }
    }

    public void process(WatchedEvent watchedEvent) {
        try {
            if (watchedEvent.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                for (String child : this.zk.getChildren(watchedEvent.getPath(), (Watcher)this)) {
                    this.appendWatcherToSubnodes(watchedEvent.getPath().equals(PATH_SEPARATOR) ? PATH_SEPARATOR + child : watchedEvent.getPath() + PATH_SEPARATOR + child);
                }
            } else {
                Stat stat = this.zk.exists(watchedEvent.getPath(), (Watcher)this);
                if (stat != null && watchedEvent.getPath().equals(this.startNode)) {
                    this.appendWatcherToSubnodes(watchedEvent.getPath());
                } else {
                    this.handleNode(watchedEvent.getPath(), stat, watchedEvent.getType());
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
        catch (NodeKeeperException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ZooKeeper getZooKeeper() {
        return this.zk;
    }

    public void shutdown() throws InterruptedException {
        if (this.zk != null) {
            this.zk.close();
            log.info(" - nodekeeper closed");
        }
    }

    public <T> Node<T> readNode(String path, Class<T> clazz) throws InterruptedException, NodeKeeperException, IOException {
        try {
            Stat stat = this.zk.exists(path, false);
            if (stat != null && handlers.containsKey(clazz)) {
                byte[] data = this.zk.getData(path, false, stat);
                return new Node(path, handlers.get(clazz).parse(data), stat.getVersion());
            }
        }
        catch (KeeperException e) {
            throw new NodeKeeperException("cannot read node");
        }
        return null;
    }

    private void buildRecursively(String path, byte[] data) throws InterruptedException, NodeKeeperException {
        try {
            if (this.zk.exists(path, false) == null) {
                if (path.contains(PATH_SEPARATOR) && path.lastIndexOf(PATH_SEPARATOR) > 0) {
                    this.buildRecursively(path.substring(0, path.lastIndexOf(PATH_SEPARATOR)), data);
                }
                this.zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (KeeperException e) {
            throw new NodeKeeperException(String.format("error while creating node '#s'", path));
        }
    }

    public <T> void writeNode(Node<T> node, Class<T> clazz) throws InterruptedException, NodeKeeperException, IOException {
        block6: {
            try {
                Stat stat = this.zk.exists(node.getPath(), false);
                if (stat != null) {
                    if (handlers.containsKey(clazz)) {
                        this.zk.setData(node.getPath(), handlers.get(clazz).serialize(node.getData()), stat.getVersion());
                        break block6;
                    }
                    throw new NodeKeeperException(String.format("cannot find handler for '%s'", node.getData().getClass().getName()));
                }
                if (node.getPath().contains(PATH_SEPARATOR) && node.getPath().lastIndexOf(PATH_SEPARATOR) > 0) {
                    this.buildRecursively(node.getPath().substring(0, node.getPath().lastIndexOf(PATH_SEPARATOR)), String.format("created by %s", this.getClass().getName()).getBytes());
                }
                if (handlers.containsKey(clazz)) {
                    this.zk.create(node.getPath(), handlers.get(clazz).serialize(node.getData()), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    break block6;
                }
                throw new NodeKeeperException(String.format("cannot find handler for '%s'", node.getData().getClass().getName()));
            }
            catch (KeeperException e) {
                throw new NodeKeeperException(String.format("cannot write data for node '%s'", node.getPath()));
            }
        }
    }

    public <T> void deleteNode(Node<T> node) throws InterruptedException, NodeKeeperException {
        try {
            Stat stat = this.zk.exists(node.getPath(), false);
            if (stat != null) {
                this.zk.delete(node.getPath(), stat.getVersion());
            }
        }
        catch (KeeperException e) {
            throw new NodeKeeperException(String.format("cannot delete node '%s'", node.getPath()));
        }
    }

    public <T> Set<Node<T>> listChildrenNodes(String path, Class<T> clazz) throws InterruptedException, NodeKeeperException {
        try {
            HashSet<Node<T>> nodes = new HashSet<Node<T>>();
            for (String key : this.zk.getChildren(path, false)) {
                Node<T> node = this.readNode(path.equals(PATH_SEPARATOR) ? path + key : path + PATH_SEPARATOR + key, clazz);
                if (node == null) continue;
                nodes.add(node);
            }
            return nodes;
        }
        catch (KeeperException e) {
            throw new NodeKeeperException(String.format("cannot read children for '%s'", path));
        }
        catch (IOException e) {
            throw new NodeKeeperException(String.format("cannot read children for '%s'", path));
        }
    }

    public void addListener(String pathPattern, NodeListener listener) throws NodeKeeperException {
        listener.nodekeeper = this;
        if (!this.listeners.containsKey(pathPattern)) {
            this.listeners.put(pathPattern, new ArrayList());
        }
        this.listeners.get(pathPattern).add(listener);
    }

    private void deleteRemoved() throws KeeperException, InterruptedException, NodeKeeperException {
        for (String path : this.properties.stringPropertyNames()) {
            for (String pathPattern : this.listeners.keySet()) {
                if (!path.matches(pathPattern) || this.zk.exists(path, false) != null) continue;
                Node node = new Node(path);
                for (NodeListener listener : this.listeners.get(pathPattern)) {
                    listener.onNodeDeleted(node);
                }
                this.removeStatus(path);
            }
        }
    }

    public void addDataHandler(DataHandler dataHandler) {
        handlers.put(dataHandler.getType(), dataHandler);
    }

    private Watcher.Event.EventType getStatus(String path, int version) throws KeeperException, InterruptedException {
        if (!this.properties.containsKey(path)) {
            return Watcher.Event.EventType.NodeCreated;
        }
        int current_version = Integer.parseInt(this.properties.getProperty(path));
        if (current_version != version) {
            return Watcher.Event.EventType.NodeDataChanged;
        }
        return null;
    }

    private void setStatus(String path, int version) throws KeeperException, InterruptedException {
        this.properties.setProperty(path, String.valueOf(version));
    }

    private void removeStatus(String path) {
        this.properties.remove(path);
    }
}

