/*
 * Decompiled with CFR 0.152.
 */
package at.rseiler.spbee.core.util;

import at.rseiler.spbee.core.pojo.TypeInfo;

public final class StringUtil {
    private StringUtil() {
    }

    public static String firstCharToLowerCase(String value) {
        return Character.toLowerCase(value.charAt(0)) + value.substring(1);
    }

    public static String transformToJavaClassName(String spName) {
        StringBuilder sb = new StringBuilder(spName.length());
        sb.append(Character.toUpperCase(spName.charAt(0)));
        for (int i = 1; i < spName.length(); ++i) {
            char c = spName.charAt(i);
            if (c == '_') continue;
            if (spName.charAt(i - 1) == '_') {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static TypeInfo getTypeInfo(String type) {
        TypeInfo typeInfo;
        if (type.contains("<")) {
            String[] split = type.split("<|>");
            typeInfo = new TypeInfo(split[0], split[1]);
        } else {
            typeInfo = new TypeInfo(type);
        }
        return typeInfo;
    }

    public static String getSimpleClassName(String qualifiedClassName) {
        return qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
    }

    public static String getPackage(String qualifiedClassName) {
        return qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf(46));
    }

    public static String getQualifiedMapperClassName(String qualifiedClassName, String name) {
        return StringUtil.getPackage(qualifiedClassName) + ".mapper." + StringUtil.getSimpleClassName(qualifiedClassName) + StringUtil.transformToJavaClassName(name) + "Mapper";
    }

    public static String getQualifiedStoredProcedureClassName(String spPackage, String spClassName) {
        return spPackage + ".storedprocedure." + spClassName;
    }

    public static String getQualifiedDtoClassName(String type) {
        return StringUtil.getPackage(type) + "." + StringUtil.getSimpleClassName(type) + "Impl";
    }
}

