/*
 * Decompiled with CFR 0.152.
 */
package at.rseiler.spbee.core.util;

import at.rseiler.spbee.core.pojo.AnnotationValueInfo;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;

public final class ElementConverter {
    private ElementConverter() {
    }

    public static AnnotationValueInfo convert(String simpleName, Object value, String type) {
        if (value instanceof Boolean || value instanceof Byte || value instanceof Character || value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Short || value instanceof Integer || value instanceof String) {
            return new AnnotationValueInfo(simpleName, value, type, AnnotationValueInfo.Kind.BASIC);
        }
        if (value instanceof DeclaredType) {
            return new AnnotationValueInfo(simpleName, value.toString(), type, AnnotationValueInfo.Kind.DECLARED_TYPE);
        }
        if (value instanceof Element) {
            return new AnnotationValueInfo(simpleName, value.toString(), type, AnnotationValueInfo.Kind.ELEMENT);
        }
        if (value instanceof List) {
            ArrayList<AnnotationValueInfo> list = new ArrayList<AnnotationValueInfo>();
            for (AnnotationValue annotationValueObj : (List)value) {
                list.add(ElementConverter.convert("", annotationValueObj.getValue(), annotationValueObj.toString()));
            }
            return new AnnotationValueInfo(simpleName, list, type, AnnotationValueInfo.Kind.LIST);
        }
        throw new RuntimeException("Failed to convert: simpleName=" + simpleName + ", value=" + value.toString() + ", type=" + type);
    }
}

