/*
 * Decompiled with CFR 0.152.
 */
package at.rseiler.spbee.core.pojo;

import at.rseiler.spbee.core.annotation.MappingConstructor;
import at.rseiler.spbee.core.annotation.ReturnNull;
import at.rseiler.spbee.core.annotation.RowMapper;
import at.rseiler.spbee.core.annotation.StoredProcedure;
import at.rseiler.spbee.core.pojo.AnnotationInfo;
import at.rseiler.spbee.core.pojo.TypeInfo;
import at.rseiler.spbee.core.pojo.Variable;
import at.rseiler.spbee.core.pojo.annotation.MappingConstructorData;
import at.rseiler.spbee.core.pojo.annotation.RowMapperData;
import at.rseiler.spbee.core.pojo.annotation.StoredProcedureData;
import at.rseiler.spbee.core.util.ElementConverter;
import at.rseiler.spbee.core.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;

public class StoredProcedureMethod
implements Serializable {
    private static final long serialVersionUID = 3118412026258156516L;
    private String qualifiedDtoClassName;
    private String methodName;
    private TypeInfo returnTypeInfo;
    private List<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();
    private boolean returnNull;
    private StoredProcedureData storedProcedure;
    private RowMapperData rowMapper;
    private MappingConstructorData mappingConstructor;
    private List<Variable> arguments = new LinkedList<Variable>();

    private StoredProcedureMethod() {
    }

    public StoredProcedureMethod addArgument(Variable argument) {
        this.arguments.add(argument);
        return this;
    }

    public boolean useNullInsteadOfAnException() {
        return this.returnNull;
    }

    public String getQualifiedClassName() {
        String name;
        StringBuilder sb = new StringBuilder(this.storedProcedure.getName());
        if (this.mappingConstructor != null) {
            name = StringUtil.transformToJavaClassName(this.mappingConstructor.getName());
            sb.append("With").append(name);
        }
        if (this.rowMapper != null) {
            name = StringUtil.getSimpleClassName(this.rowMapper.getType());
            sb.append("With").append(name);
        }
        String spClassName = StringUtil.transformToJavaClassName(sb.toString());
        String spPackage = StringUtil.getPackage(this.qualifiedDtoClassName);
        return StringUtil.getQualifiedStoredProcedureClassName(spPackage, spClassName);
    }

    public String getPackage() {
        return StringUtil.getPackage(this.getQualifiedClassName());
    }

    public String getSimpleClassName() {
        String name;
        String spName = StringUtil.transformToJavaClassName(this.getStoredProcedureName());
        StringBuilder sb = new StringBuilder(spName);
        if (this.mappingConstructor != null) {
            name = StringUtil.transformToJavaClassName(this.mappingConstructor.getName());
            sb.append("With").append(name);
        }
        if (this.rowMapper != null) {
            name = StringUtil.getSimpleClassName(this.rowMapper.getType());
            sb.append("With").append(name);
        }
        return sb.toString();
    }

    public String getStoredProcedureName() {
        return this.storedProcedure.getName();
    }

    public String getDtoFieldName() {
        return StringUtil.firstCharToLowerCase(this.getSimpleClassName());
    }

    public String getMethodName() {
        return this.methodName;
    }

    public TypeInfo getReturnTypeInfo() {
        return this.returnTypeInfo;
    }

    public List<Variable> getArguments() {
        return this.arguments;
    }

    public String getQualifiedRowMapperClass() {
        if (this.rowMapper != null) {
            return this.rowMapper.getType();
        }
        String name = this.mappingConstructor != null ? this.mappingConstructor.getName() : "Default";
        String returnType = this.returnTypeInfo.getGenericType().orElse(this.returnTypeInfo.getType());
        return StringUtil.getQualifiedMapperClassName(returnType, name);
    }

    public List<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return "StoredProcedureMethod{qualifiedDtoClassName='" + this.qualifiedDtoClassName + '\'' + ", annotations=" + this.annotations + ", storedProcedure=" + this.storedProcedure + ", rowMapper=" + this.rowMapper + ", returnNull=" + this.returnNull + ", mappingConstructor=" + this.mappingConstructor + ", methodName='" + this.methodName + '\'' + ", returnTypeInfo=" + this.returnTypeInfo + ", arguments=" + this.arguments + '}';
    }

    public static class Builder {
        private final StoredProcedureMethod storedProcedureMethod = new StoredProcedureMethod();

        public Builder dtoClassName(String dtoClassName) {
            this.storedProcedureMethod.qualifiedDtoClassName = dtoClassName;
            return this;
        }

        public Builder methodName(String methodName) {
            this.storedProcedureMethod.methodName = methodName;
            return this;
        }

        public Builder returnTypeInfo(TypeInfo returnTypeInfo) {
            this.storedProcedureMethod.returnTypeInfo = returnTypeInfo;
            return this;
        }

        public Builder annotations(List<AnnotationMirror> annotations) {
            LinkedList<AnnotationInfo> annotationInfos = new LinkedList<AnnotationInfo>();
            for (AnnotationMirror annotation : annotations) {
                AnnotationInfo annotationInfo = new AnnotationInfo(annotation.getAnnotationType().toString());
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
                    String simpleName = entry.getKey().getSimpleName().toString();
                    Object value = entry.getValue().getValue();
                    String type = entry.getValue().toString();
                    annotationInfo.addAnnotationValueInfo(ElementConverter.convert(simpleName, value, type));
                }
                annotationInfos.add(annotationInfo);
            }
            this.storedProcedureMethod.annotations = annotationInfos;
            return this;
        }

        public Builder annotationInfos(List<AnnotationInfo> annotations) {
            this.storedProcedureMethod.annotations = annotations;
            return this;
        }

        public Builder storedProcedure(StoredProcedure storedProcedure) {
            this.storedProcedureMethod.storedProcedure = new StoredProcedureData(storedProcedure);
            return this;
        }

        public Builder rowMapper(RowMapper rowMapper) {
            this.storedProcedureMethod.rowMapper = rowMapper != null ? new RowMapperData(rowMapper) : null;
            return this;
        }

        public Builder returnNull(ReturnNull returnNull) {
            this.storedProcedureMethod.returnNull = returnNull != null;
            return this;
        }

        public Builder mappingConstructor(MappingConstructor mappingConstructor) {
            this.storedProcedureMethod.mappingConstructor = mappingConstructor != null ? new MappingConstructorData(mappingConstructor) : null;
            return this;
        }

        public StoredProcedureMethod build() {
            return this.storedProcedureMethod;
        }
    }
}

