/*
 * Decompiled with CFR 0.152.
 */
package at.rseiler.spbee.core.generator;

import at.rseiler.spbee.core.generator.AbstractGenerator;
import at.rseiler.spbee.core.pojo.DtoClass;
import at.rseiler.spbee.core.pojo.ResultSetClass;
import at.rseiler.spbee.core.pojo.ResultSetVariable;
import at.rseiler.spbee.core.pojo.StoredProcedureMethod;
import at.rseiler.spbee.core.pojo.Variable;
import at.rseiler.spbee.core.util.CodeModelUtil;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Types;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.sql.DataSource;

public class StoredProcedureGenerator
extends AbstractGenerator {
    private static final String SPRING_SQL_RETURN_RESULT_SET = "org.springframework.jdbc.core.SqlReturnResultSet";
    private static final String SPRING_STORED_PROCEDURE = "org.springframework.jdbc.object.StoredProcedure";
    private static final String SPRING_SQL_PARAMETER = "org.springframework.jdbc.core.SqlParameter";
    private final Map<String, ResultSetClass> resultSetsMap;

    public StoredProcedureGenerator(ProcessingEnvironment processingEnv, Map<String, ResultSetClass> resultSetsMap) {
        super(processingEnv);
        this.resultSetsMap = resultSetsMap;
    }

    public void generateStoredProcedureClasses(List<DtoClass> dtoClasses) throws JClassAlreadyExistsException, IOException {
        HashSet<String> storedProcedureNames = new HashSet<String>();
        for (DtoClass dtoClass : dtoClasses) {
            for (StoredProcedureMethod storedProcedureMethod : dtoClass.getStoredProcedureMethods()) {
                if (storedProcedureNames.contains(storedProcedureMethod.getQualifiedClassName())) continue;
                this.generateStoredProcedure(storedProcedureMethod);
                storedProcedureNames.add(storedProcedureMethod.getQualifiedClassName());
            }
        }
    }

    private void generateStoredProcedure(StoredProcedureMethod storedProcedureMethod) throws JClassAlreadyExistsException, IOException {
        JCodeModel model = new JCodeModel();
        JDefinedClass spClass = this.createClass(model, storedProcedureMethod.getPackage(), storedProcedureMethod.getSimpleClassName());
        this.createConstructor(model, spClass, storedProcedureMethod);
        this.addExecuteMethod(model, spClass, storedProcedureMethod);
        this.generateClass(model, storedProcedureMethod.getQualifiedClassName());
    }

    private JDefinedClass createClass(JCodeModel model, String spPackage, String className) throws JClassAlreadyExistsException {
        JPackage jPackage = model._package(spPackage);
        JDefinedClass aClass = jPackage._class(className);
        CodeModelUtil.annotateGenerated(aClass);
        aClass._extends(model.directClass(SPRING_STORED_PROCEDURE));
        return aClass;
    }

    private void createConstructor(JCodeModel model, JDefinedClass spClass, StoredProcedureMethod storedProcedureMethod) {
        JMethod constructor = spClass.constructor(1);
        JVar dataSource = constructor.param(DataSource.class, "dataSource");
        JBlock body = constructor.body();
        body.add((JStatement)JExpr.invoke((String)"super").arg((JExpression)dataSource).arg(storedProcedureMethod.getStoredProcedureName()));
        this.declareSqlParameters(model, storedProcedureMethod, body);
        this.declareResultSets(model, body, storedProcedureMethod);
        body.add((JStatement)JExpr.invoke((String)"compile"));
    }

    private void declareSqlParameters(JCodeModel model, StoredProcedureMethod storedProcedureMethod, JBlock body) {
        for (Variable variable : storedProcedureMethod.getArguments()) {
            String sqlType = StoredProcedureGenerator.getSqlParameter(variable.getTypeInfo().getGenericTypeOrType());
            JInvocation sqlParameter = JExpr._new((JClass)model.directClass(SPRING_SQL_PARAMETER));
            sqlParameter.arg(variable.getName());
            sqlParameter.arg((JExpression)model.directClass(Types.class.getCanonicalName()).staticRef(sqlType));
            body.add((JStatement)JExpr.invoke((String)"declareParameter").arg((JExpression)sqlParameter));
        }
    }

    private void declareResultSets(JCodeModel model, JBlock body, StoredProcedureMethod storedProcedureMethod) {
        String type = storedProcedureMethod.getReturnTypeInfo().getGenericType().orElse(storedProcedureMethod.getReturnTypeInfo().getType());
        if (!"void".equals(type)) {
            if (this.resultSetsMap.containsKey(type)) {
                this.multipleResultSets(model, body, type);
            } else {
                this.singleResultSet(model, body, storedProcedureMethod);
            }
        }
    }

    private void multipleResultSets(JCodeModel model, JBlock body, String type) {
        List<ResultSetVariable> variables = this.resultSetsMap.get(type).getResultSetVariables();
        for (int i = 0; i < variables.size(); ++i) {
            ResultSetVariable variable = variables.get(i);
            JInvocation newMapper = JExpr._new((JClass)model.directClass(variable.getRowMapper()));
            JInvocation sqlReturnResultSet = JExpr._new((JClass)model.directClass(SPRING_SQL_RETURN_RESULT_SET)).arg("#result-set-" + i).arg((JExpression)newMapper);
            body.add((JStatement)JExpr.invoke((String)"declareParameter").arg((JExpression)sqlReturnResultSet));
        }
    }

    private void singleResultSet(JCodeModel model, JBlock body, StoredProcedureMethod storedProcedureMethod) {
        JInvocation newMapper = JExpr._new((JClass)model.directClass(storedProcedureMethod.getQualifiedRowMapperClass()));
        JInvocation sqlReturnResultSet = JExpr._new((JClass)model.directClass(SPRING_SQL_RETURN_RESULT_SET)).arg("#result-set-0").arg((JExpression)newMapper);
        body.add((JStatement)JExpr.invoke((String)"declareParameter").arg((JExpression)sqlReturnResultSet));
    }

    private void addExecuteMethod(JCodeModel model, JDefinedClass aClass, StoredProcedureMethod storedProcedureMethod) {
        JMethod method = aClass.method(1, (JType)CodeModelUtil.getMapStringObject(model), "execute");
        JInvocation superExecute = JExpr._super().invoke("execute");
        JBlock block = method.body();
        boolean hasArrayType = storedProcedureMethod.getArguments().stream().anyMatch(this::isArrayType);
        JVar connection = null;
        if (hasArrayType) {
            connection = block.decl((JType)model.directClass(Connection.class.getCanonicalName()), "conn");
            block.assign((JAssignmentTarget)connection, JExpr._null());
            JTryBlock tryBlock = method.body()._try();
            JCatchBlock catchBlock = tryBlock._catch(model.directClass(SQLException.class.getCanonicalName()));
            JInvocation exception = JExpr._new((JClass)model.directClass("org.springframework.jdbc.UncategorizedSQLException")).arg((JExpression)JExpr._this().invoke("getClass").invoke("getCanonicalName")).arg((JExpression)JExpr._this().invoke("getSql")).arg((JExpression)catchBlock.param("e"));
            catchBlock.body()._throw((JExpression)exception);
            JTryBlock connCloseTryBlock = tryBlock._finally()._if(connection.ne(JExpr._null()))._then()._try();
            connCloseTryBlock.body().add((JStatement)connection.invoke("close"));
            JCatchBlock closeConnCatchBlock = connCloseTryBlock._catch(model.directClass(SQLException.class.getCanonicalName()));
            JInvocation runtimeException = JExpr._new((JClass)model.directClass(RuntimeException.class.getCanonicalName())).arg(JExpr.lit((String)"Failed to close connection")).arg((JExpression)closeConnCatchBlock.param("e"));
            closeConnCatchBlock.body()._throw((JExpression)runtimeException);
            block = tryBlock.body();
            block.assign((JAssignmentTarget)connection, (JExpression)JExpr.invoke((String)"getJdbcTemplate").invoke("getDataSource").invoke("getConnection"));
        }
        for (Variable variable : storedProcedureMethod.getArguments()) {
            JVar param = method.param((JType)model.directClass(variable.getTypeInfo().asString()), variable.getName());
            if (hasArrayType && this.isArrayType(variable)) {
                superExecute.arg((JExpression)connection.invoke("createArrayOf").arg(this.getArrayType(variable.getTypeInfo().asString())).arg((JExpression)param));
                continue;
            }
            superExecute.arg((JExpression)param);
        }
        block._return((JExpression)superExecute);
    }

    private boolean isArrayType(Variable variable) {
        return variable.getTypeInfo().asString().contains("[]");
    }

    public static String getSqlParameter(String type) {
        switch (type) {
            case "boolean": 
            case "java.lang.Boolean": {
                return "BOOLEAN";
            }
            case "byte": 
            case "java.lang.Byte": {
                return "TINYINT";
            }
            case "short": 
            case "java.lang.Short": {
                return "SMALLINT";
            }
            case "int": 
            case "java.lang.Integer": {
                return "INTEGER";
            }
            case "long": 
            case "java.lang.Long": {
                return "BIGINT";
            }
            case "float": 
            case "java.lang.Float": {
                return "FLOAT";
            }
            case "double": 
            case "java.lang.Double": {
                return "DOUBLE";
            }
            case "byte[]": 
            case "java.lang.Byte[]": {
                return "BINARY";
            }
            case "java.lang.String": {
                return "VARCHAR";
            }
            case "java.sql.Date": 
            case "java.util.Date": {
                return "DATE";
            }
            case "java.math.BigDecimal": {
                return "DOUBLE";
            }
        }
        if (type.contains("[]")) {
            return "ARRAY";
        }
        throw new RuntimeException("Unknown SqlType: " + type);
    }

    private String getArrayType(String type) {
        switch (type) {
            case "java.lang.Boolean[]": {
                return "bool";
            }
            case "java.lang.Character[]": {
                return "char";
            }
            case "java.lang.Byte[]": {
                return "smallint";
            }
            case "java.lang.Short[]": {
                return "smallint";
            }
            case "java.lang.Integer[]": {
                return "int";
            }
            case "java.lang.Long[]": {
                return "bigint";
            }
            case "java.lang.Float[]": {
                return "float";
            }
            case "java.lang.Decimal[]": 
            case "java.math.BigDecimal[]": {
                return "numeric";
            }
            case "java.lang.String[]": {
                return "varchar";
            }
            case "java.sql.Date[]": 
            case "java.util.Date[]": {
                return "date";
            }
        }
        throw new RuntimeException("Unknown array type: " + type);
    }
}

