/*
 * Decompiled with CFR 0.152.
 */
package at.rseiler.spbee.core.generator;

import at.rseiler.spbee.core.generator.AbstractGenerator;
import at.rseiler.spbee.core.pojo.MapperClass;
import at.rseiler.spbee.core.pojo.Variable;
import at.rseiler.spbee.core.util.CodeModelUtil;
import at.rseiler.spbee.core.util.StringUtil;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;

public class MapperGenerator
extends AbstractGenerator {
    private static final String SPRING_ROW_MAPPER = "org.springframework.jdbc.core.RowMapper";

    public MapperGenerator(ProcessingEnvironment processingEnv) {
        super(processingEnv);
    }

    public void generateMappers(Collection<MapperClass> mapperClasses) throws JClassAlreadyExistsException, ClassNotFoundException, IOException {
        for (MapperClass mapperClass : mapperClasses) {
            this.generateMapper(mapperClass);
        }
    }

    private void generateMapper(MapperClass mapperClass) throws JClassAlreadyExistsException, ClassNotFoundException, IOException {
        String type = mapperClass.getType();
        String qualifiedClassName = mapperClass.getQualifiedMapperClassName();
        JCodeModel model = new JCodeModel();
        JClass typeJClass = model.directClass(type);
        JDefinedClass mapperJDefinedClass = this.createClass(model, qualifiedClassName, typeJClass);
        this.createMapRow(model, mapperJDefinedClass, typeJClass, mapperClass.getVariables());
        this.generateClass(model, qualifiedClassName);
    }

    private JDefinedClass createClass(JCodeModel model, String qualifiedClassName, JClass typeJClass) throws JClassAlreadyExistsException {
        String className = StringUtil.getSimpleClassName(qualifiedClassName);
        String aPackage = StringUtil.getPackage(qualifiedClassName);
        JPackage jPackage = model._package(aPackage);
        JDefinedClass aClass = jPackage._class(className);
        CodeModelUtil.annotateGenerated(aClass);
        aClass._implements(model.directClass(SPRING_ROW_MAPPER).narrow(typeJClass));
        return aClass;
    }

    private void createMapRow(JCodeModel model, JDefinedClass mapperClass, JClass type, List<Variable> mapperVariables) throws ClassNotFoundException {
        JMethod method = mapperClass.method(1, (JType)type, "mapRow");
        method._throws(SQLException.class);
        method.param((JType)model.directClass(ResultSet.class.getCanonicalName()), "rs");
        method.param(model.parseType("int"), "rowNum");
        JInvocation invocation = JExpr._new((JClass)type);
        for (int i = 0; i < mapperVariables.size(); ++i) {
            Variable variable = mapperVariables.get(i);
            String methodName = MapperGenerator.getResultSetMethod(variable.getTypeInfo().getGenericTypeOrType());
            invocation.arg((JExpression)JExpr.invoke((JExpression)JExpr.ref((String)"rs"), (String)methodName).arg(JExpr.lit((int)(i + 1))));
        }
        method.body()._return((JExpression)invocation);
    }

    private static String getResultSetMethod(String type) {
        switch (type) {
            case "boolean": 
            case "java.lang.Boolean": {
                return "getBoolean";
            }
            case "byte": 
            case "java.lang.Byte": {
                return "getByte";
            }
            case "short": 
            case "java.lang.Short": {
                return "getShort";
            }
            case "int": 
            case "java.lang.Integer": {
                return "getInt";
            }
            case "long": 
            case "java.lang.Long": {
                return "getLong";
            }
            case "float": 
            case "java.lang.Float": {
                return "getFloat";
            }
            case "double": 
            case "java.lang.Double": {
                return "getDouble";
            }
            case "byte[]": 
            case "java.lang.Byte[]": {
                return "getByte";
            }
            case "java.lang.String": {
                return "getString";
            }
            case "java.sql.Date": 
            case "java.util.Date": {
                return "getDate";
            }
            case "java.math.BigDecimal": {
                return "getBigDecimal";
            }
        }
        return "getObject";
    }
}

