/*
 * Decompiled with CFR 0.152.
 */
package at.rseiler.spbee.core.generator;

import at.rseiler.spbee.core.exception.MultipleObjectsReturned;
import at.rseiler.spbee.core.exception.ObjectDoesNotExist;
import at.rseiler.spbee.core.generator.AbstractGenerator;
import at.rseiler.spbee.core.pojo.AnnotationInfo;
import at.rseiler.spbee.core.pojo.AnnotationValueInfo;
import at.rseiler.spbee.core.pojo.DtoClass;
import at.rseiler.spbee.core.pojo.ResultSetClass;
import at.rseiler.spbee.core.pojo.ResultSetVariable;
import at.rseiler.spbee.core.pojo.StoredProcedureMethod;
import at.rseiler.spbee.core.pojo.Variable;
import at.rseiler.spbee.core.util.CodeModelUtil;
import at.rseiler.spbee.core.util.StringUtil;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.processing.ProcessingEnvironment;
import javax.sql.DataSource;

public class DtoGenerator
extends AbstractGenerator {
    private static final String SPRING_ANNOTATION_AUTOWIRED = "org.springframework.beans.factory.annotation.Autowired";
    private static final String SPRING_ANNOTATION_SERVICE = "org.springframework.stereotype.Service";
    private final Properties config;
    private final Map<String, ResultSetClass> resultSetMap;

    public DtoGenerator(ProcessingEnvironment processingEnv, Properties config, Map<String, ResultSetClass> resultSetMap) {
        super(processingEnv);
        this.config = config;
        this.resultSetMap = resultSetMap;
    }

    public void generateDtoClasses(List<DtoClass> dtoClasses) throws JClassAlreadyExistsException, IOException {
        for (DtoClass dtoClass : dtoClasses) {
            DtoClassGeneratorInstance dtoClassGeneratorInstance = new DtoClassGeneratorInstance(this.config, dtoClass, this.resultSetMap).createClass().createConstructor().addStoredProcedureMethods();
            this.generateClass(dtoClassGeneratorInstance.getModel(), dtoClass.getQualifiedClassName());
        }
    }

    private static class DtoClassGeneratorInstance {
        private final Properties config;
        private final DtoClass dtoClass;
        private final Map<String, ResultSetClass> resultSetMap;
        private JCodeModel model = new JCodeModel();
        private JDefinedClass dtoJClass;
        private JMethod constructor;
        private JVar dataSource;
        private Map<String, JFieldVar> spFields = new HashMap<String, JFieldVar>();

        public DtoClassGeneratorInstance(Properties config, DtoClass dtoClass, Map<String, ResultSetClass> resultSetMap) {
            this.config = config;
            this.dtoClass = dtoClass;
            this.resultSetMap = resultSetMap;
        }

        public JCodeModel getModel() {
            return this.model;
        }

        private DtoClassGeneratorInstance createClass() throws JClassAlreadyExistsException {
            JPackage dtoJPackage = this.model._package(this.dtoClass.getPackage());
            this.dtoJClass = dtoJPackage._class(this.dtoClass.getSimpleClassName());
            CodeModelUtil.annotateGenerated(this.dtoJClass);
            this.dtoJClass.annotate(this.model.directClass(DtoGenerator.SPRING_ANNOTATION_SERVICE));
            this.addSuperClassOrInterface();
            return this;
        }

        public DtoClassGeneratorInstance createConstructor() {
            this.constructor = this.dtoJClass.constructor(1);
            this.constructor.annotate(this.model.directClass(DtoGenerator.SPRING_ANNOTATION_AUTOWIRED));
            this.dataSource = this.constructor.param(DataSource.class, "dataSource");
            if (this.dtoClass.hasDataSourceConstructor()) {
                this.constructor.body().add((JStatement)JExpr.invoke((String)"super").arg((JExpression)this.dataSource));
            }
            return this;
        }

        public DtoClassGeneratorInstance addStoredProcedureMethods() throws JClassAlreadyExistsException {
            for (StoredProcedureMethod storedProcedureMethod : this.dtoClass.getStoredProcedureMethods()) {
                String fieldName = storedProcedureMethod.getDtoFieldName();
                if (!this.spFields.containsKey(fieldName)) {
                    this.spFields.put(fieldName, this.addConstructorField(storedProcedureMethod));
                }
                this.addDtoMethod(storedProcedureMethod, this.spFields.get(fieldName));
            }
            return this;
        }

        private void addSuperClassOrInterface() {
            if (this.dtoClass.isAnInterface()) {
                this.dtoJClass._implements(this.model.directClass(this.dtoClass.getSuperQualifiedClassName()));
            } else {
                this.dtoJClass._extends(this.model.directClass(this.dtoClass.getSuperQualifiedClassName()));
            }
        }

        private JFieldVar addConstructorField(StoredProcedureMethod storedProcedureMethod) {
            if (this.constructor == null) {
                throw new RuntimeException("Invalid Usage. createConstructor() must be called first.");
            }
            JClass jClass = this.model.directClass(storedProcedureMethod.getQualifiedClassName());
            JFieldVar field = this.dtoJClass.field(12, (JType)jClass, storedProcedureMethod.getDtoFieldName());
            this.constructor.body().assign((JAssignmentTarget)field, (JExpression)JExpr._new((JClass)jClass).arg((JExpression)this.dataSource));
            return field;
        }

        private void addDtoMethod(StoredProcedureMethod storedProcedureMethod, JFieldVar field) throws JClassAlreadyExistsException {
            JClass returnClass = this.getReturnClass(storedProcedureMethod);
            JMethod method = this.dtoJClass.method(1, (JType)returnClass, storedProcedureMethod.getMethodName());
            this.addAnnotations(storedProcedureMethod, method);
            JInvocation execute = this.getExecute(storedProcedureMethod, field, method);
            JVar interceptorIdObject = null;
            if (this.config.containsKey("interceptor")) {
                JInvocation before = this.model.ref(this.config.getProperty("interceptor")).staticInvoke("before");
                before.arg(JExpr.lit((String)storedProcedureMethod.getStoredProcedureName()));
                for (JExpression arg : execute.listArgs()) {
                    before.arg(arg);
                }
                interceptorIdObject = method.body().decl((JType)this.model.directClass(Object.class.getCanonicalName()), "interceptorIdObject");
                method.body().assign((JAssignmentTarget)interceptorIdObject, (JExpression)before);
            }
            if ("void".equals(storedProcedureMethod.getReturnTypeInfo().getType())) {
                method.body().add((JStatement)execute);
                this.addInterceptorCallAfter(storedProcedureMethod, method, execute, interceptorIdObject);
            } else if (this.resultSetMap.containsKey(storedProcedureMethod.getReturnTypeInfo().getType())) {
                this.multipleResultSets(storedProcedureMethod, returnClass, method, execute, interceptorIdObject);
            } else {
                this.singleResultSet(storedProcedureMethod, returnClass, method, execute, interceptorIdObject);
            }
        }

        private JInvocation getExecute(StoredProcedureMethod storedProcedureMethod, JFieldVar field, JMethod method) {
            JInvocation execute = JExpr.invoke((JExpression)field, (String)"execute");
            for (Variable variable : storedProcedureMethod.getArguments()) {
                JVar param = method.param((JType)this.model.directClass(variable.getTypeInfo().asString()), variable.getName());
                execute.arg((JExpression)param);
            }
            return execute;
        }

        private JClass getReturnClass(StoredProcedureMethod storedProcedureMethod) {
            Optional<String> genericType = storedProcedureMethod.getReturnTypeInfo().getGenericType();
            JClass returnClass = this.model.ref(storedProcedureMethod.getReturnTypeInfo().getType());
            if (genericType.isPresent()) {
                returnClass = returnClass.narrow(this.model.ref(genericType.get()));
            }
            return returnClass;
        }

        private void addAnnotations(StoredProcedureMethod storedProcedureMethod, JMethod method) throws JClassAlreadyExistsException {
            for (AnnotationInfo annotationInfo : storedProcedureMethod.getAnnotations()) {
                JAnnotationUse jAnnotationUse = method.annotate(this.model.ref(annotationInfo.getAnnotationType()));
                for (AnnotationValueInfo annotationValueInfo : annotationInfo.getAnnotationValueInfos()) {
                    this.addAnnotationParam(jAnnotationUse, annotationValueInfo);
                }
            }
        }

        private void multipleResultSets(StoredProcedureMethod storedProcedureMethod, JClass returnClass, JMethod method, JInvocation execute, JVar interceptorIdObject) {
            JVar map = method.body().decl((JType)CodeModelUtil.getMapStringObject(this.model), "map");
            method.body().assign((JAssignmentTarget)map, (JExpression)execute);
            this.addInterceptorCallAfter(storedProcedureMethod, method, execute, interceptorIdObject);
            JInvocation resultSetsInvoke = JExpr._new((JClass)returnClass);
            ArrayList<JVar> args = new ArrayList<JVar>();
            List<ResultSetVariable> variables = this.resultSetMap.get(storedProcedureMethod.getReturnTypeInfo().getType()).getResultSetVariables();
            for (int i = 0; i < variables.size(); ++i) {
                JConditional condition;
                JVar obj;
                JVar list;
                JClass varType;
                ResultSetVariable variable = variables.get(i);
                Optional<String> genericType = variable.getTypeInfo().getGenericType();
                if (genericType.isPresent()) {
                    if (Optional.class.getCanonicalName().equals(variable.getTypeInfo().getType())) {
                        varType = CodeModelUtil.getGenericList(this.model, variable.getTypeInfo().getGenericType().get());
                        list = method.body().decl((JType)varType, "list" + i);
                        method.body().assign((JAssignmentTarget)list, (JExpression)JExpr.cast((JType)varType, (JExpression)map.invoke("get").arg("#result-set-" + i)));
                        obj = method.body().decl((JType)this.model.directClass(variable.getTypeInfo().getType()), "obj" + i);
                        condition = method.body()._if(list.invoke("size").eq(JExpr.lit((int)1)));
                        condition._then().assign((JAssignmentTarget)obj, (JExpression)this.model.directClass(Optional.class.getCanonicalName()).staticInvoke("of").arg((JExpression)list.invoke("get").arg(JExpr.lit((int)0))));
                        condition = condition._elseif(list.invoke("size").eq(JExpr.lit((int)0)));
                        condition._then().assign((JAssignmentTarget)obj, (JExpression)this.model.directClass(Optional.class.getCanonicalName()).staticInvoke("empty"));
                        condition._else()._throw((JExpression)JExpr._new((JClass)this.model.directClass(MultipleObjectsReturned.class.getCanonicalName())));
                        args.add(obj);
                        continue;
                    }
                    varType = this.model.directClass(variable.getTypeInfo().getType()).narrow(this.model.directClass(genericType.get()));
                    list = method.body().decl((JType)varType, "list" + i);
                    method.body().assign((JAssignmentTarget)list, (JExpression)JExpr.cast((JType)varType, (JExpression)map.invoke("get").arg("#result-set-" + i)));
                    args.add(list);
                    continue;
                }
                varType = CodeModelUtil.getGenericList(this.model, variable.getTypeInfo().getType());
                list = method.body().decl((JType)varType, "list" + i);
                method.body().assign((JAssignmentTarget)list, (JExpression)JExpr.cast((JType)varType, (JExpression)map.invoke("get").arg("#result-set-" + i)));
                obj = method.body().decl((JType)this.model.directClass(variable.getTypeInfo().getType()), "obj" + i);
                condition = method.body()._if(list.invoke("size").eq(JExpr.lit((int)1)));
                condition._then().assign((JAssignmentTarget)obj, (JExpression)list.invoke("get").arg(JExpr.lit((int)0)));
                if (variable.useNullInsteadOfAnException()) {
                    condition = condition._elseif(list.invoke("size").eq(JExpr.lit((int)0)));
                    condition._then().assign((JAssignmentTarget)obj, JExpr._null());
                    condition._else()._throw((JExpression)JExpr._new((JClass)this.model.directClass(MultipleObjectsReturned.class.getCanonicalName())));
                } else {
                    condition = condition._elseif(list.invoke("size").eq(JExpr.lit((int)0)));
                    condition._then()._throw((JExpression)JExpr._new((JClass)this.model.directClass(ObjectDoesNotExist.class.getCanonicalName())));
                    condition._else()._throw((JExpression)JExpr._new((JClass)this.model.directClass(MultipleObjectsReturned.class.getCanonicalName())));
                }
                args.add(obj);
            }
            args.forEach(arg_0 -> ((JInvocation)resultSetsInvoke).arg(arg_0));
            method.body()._return((JExpression)resultSetsInvoke);
        }

        private void singleResultSet(StoredProcedureMethod storedProcedureMethod, JClass returnClass, JMethod method, JInvocation execute, JVar interceptorIdObject) {
            if (storedProcedureMethod.getReturnTypeInfo().getGenericType().isPresent()) {
                if (Optional.class.getCanonicalName().equals(storedProcedureMethod.getReturnTypeInfo().getType())) {
                    String genericClassType = storedProcedureMethod.getReturnTypeInfo().getGenericType().get();
                    JVar list = method.body().decl((JType)CodeModelUtil.getGenericList(this.model, genericClassType), "list");
                    method.body().assign((JAssignmentTarget)list, (JExpression)JExpr.cast((JType)this.model.ref(List.class).narrow(this.model.ref(genericClassType)), (JExpression)execute.invoke("get").arg("#result-set-0")));
                    this.addInterceptorCallAfter(storedProcedureMethod, method, execute, interceptorIdObject);
                    JConditional condition = method.body()._if(list.invoke("size").eq(JExpr.lit((int)1)));
                    condition._then()._return((JExpression)this.model.directClass(Optional.class.getCanonicalName()).staticInvoke("of").arg((JExpression)list.invoke("get").arg(JExpr.lit((int)0))));
                    condition = condition._elseif(list.invoke("size").eq(JExpr.lit((int)0)));
                    condition._then()._return((JExpression)this.model.directClass(Optional.class.getCanonicalName()).staticInvoke("empty"));
                    condition._else()._throw((JExpression)JExpr._new((JClass)this.model.directClass(MultipleObjectsReturned.class.getCanonicalName())));
                } else {
                    JVar map = method.body().decl((JType)CodeModelUtil.getMapStringObject(this.model), "map");
                    method.body().assign((JAssignmentTarget)map, (JExpression)execute);
                    this.addInterceptorCallAfter(storedProcedureMethod, method, execute, interceptorIdObject);
                    method.body()._return((JExpression)JExpr.cast((JType)returnClass, (JExpression)map.invoke("get").arg("#result-set-0")));
                }
            } else {
                JVar list = method.body().decl((JType)CodeModelUtil.getGenericList(this.model, storedProcedureMethod.getReturnTypeInfo().getType()), "list");
                method.body().assign((JAssignmentTarget)list, (JExpression)JExpr.cast((JType)this.model.ref(List.class).narrow(returnClass), (JExpression)execute.invoke("get").arg("#result-set-0")));
                this.addInterceptorCallAfter(storedProcedureMethod, method, execute, interceptorIdObject);
                JConditional condition = method.body()._if(list.invoke("size").eq(JExpr.lit((int)1)));
                condition._then()._return((JExpression)list.invoke("get").arg(JExpr.lit((int)0)));
                if (storedProcedureMethod.useNullInsteadOfAnException()) {
                    condition = condition._elseif(list.invoke("size").eq(JExpr.lit((int)0)));
                    condition._then()._return(JExpr._null());
                    condition._else()._throw((JExpression)JExpr._new((JClass)this.model.directClass(MultipleObjectsReturned.class.getCanonicalName())));
                } else {
                    condition = condition._elseif(list.invoke("size").eq(JExpr.lit((int)0)));
                    condition._then()._throw((JExpression)JExpr._new((JClass)this.model.directClass(ObjectDoesNotExist.class.getCanonicalName())));
                    condition._else()._throw((JExpression)JExpr._new((JClass)this.model.directClass(MultipleObjectsReturned.class.getCanonicalName())));
                }
            }
        }

        private void addInterceptorCallAfter(StoredProcedureMethod storedProcedureMethod, JMethod method, JInvocation execute, JVar interceptorIdObject) {
            if (interceptorIdObject != null) {
                JInvocation after = this.model.ref(this.config.getProperty("interceptor")).staticInvoke("after");
                after.arg((JExpression)interceptorIdObject);
                after.arg(JExpr.lit((String)storedProcedureMethod.getStoredProcedureName()));
                for (JExpression arg : execute.listArgs()) {
                    after.arg(arg);
                }
                method.body().add((JStatement)after);
            }
        }

        private void addAnnotationParam(JAnnotationUse jAnnotationUse, AnnotationValueInfo annotationValueInfo) throws JClassAlreadyExistsException {
            Object value = annotationValueInfo.getValue();
            String annotationName = annotationValueInfo.getName();
            switch (annotationValueInfo.getKind()) {
                case BASIC: {
                    if (value instanceof Boolean) {
                        jAnnotationUse.param(annotationName, ((Boolean)value).booleanValue());
                        break;
                    }
                    if (value instanceof Byte) {
                        jAnnotationUse.param(annotationName, ((Byte)value).byteValue());
                        break;
                    }
                    if (value instanceof Character) {
                        jAnnotationUse.param(annotationName, ((Character)value).charValue());
                        break;
                    }
                    if (value instanceof Double) {
                        jAnnotationUse.param(annotationName, ((Double)value).doubleValue());
                        break;
                    }
                    if (value instanceof Float) {
                        jAnnotationUse.param(annotationName, ((Float)value).floatValue());
                        break;
                    }
                    if (value instanceof Long) {
                        jAnnotationUse.param(annotationName, ((Long)value).longValue());
                        break;
                    }
                    if (value instanceof Short) {
                        jAnnotationUse.param(annotationName, ((Short)value).shortValue());
                        break;
                    }
                    if (value instanceof Integer) {
                        jAnnotationUse.param(annotationName, ((Integer)value).intValue());
                        break;
                    }
                    if (!(value instanceof String)) break;
                    jAnnotationUse.param(annotationName, (String)value);
                    break;
                }
                case DECLARED_TYPE: {
                    jAnnotationUse.param(annotationName, (JType)this.model.ref(value.toString()));
                    break;
                }
                case ELEMENT: {
                    String qualifiedEnumName = StringUtil.getPackage(annotationValueInfo.getType());
                    JPackage dtoJPackage = new JCodeModel()._package(StringUtil.getPackage(qualifiedEnumName));
                    JDefinedClass definedClass = dtoJPackage._class(StringUtil.getSimpleClassName(qualifiedEnumName));
                    jAnnotationUse.param(annotationName, definedClass.enumConstant(value.toString()));
                    break;
                }
                case LIST: {
                    JAnnotationArrayMember jAnnotationArrayMember = jAnnotationUse.paramArray(annotationName);
                    List list = (List)value;
                    for (AnnotationValueInfo valueInfo : list) {
                        this.addAnnotationArrayMemberParam(jAnnotationArrayMember, valueInfo);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Failed to addAnnotationParam, because the kind is unknown: " + (Object)((Object)annotationValueInfo.getKind()));
                }
            }
        }

        private void addAnnotationArrayMemberParam(JAnnotationArrayMember jAnnotationArrayMember, AnnotationValueInfo annotationValueInfo) {
            Object value = annotationValueInfo.getValue();
            try {
                switch (annotationValueInfo.getKind()) {
                    case BASIC: {
                        if (value instanceof Boolean) {
                            jAnnotationArrayMember.param(((Boolean)value).booleanValue());
                            break;
                        }
                        if (value instanceof Byte) {
                            jAnnotationArrayMember.param(((Byte)value).byteValue());
                            break;
                        }
                        if (value instanceof Character) {
                            jAnnotationArrayMember.param(((Character)value).charValue());
                            break;
                        }
                        if (value instanceof Double) {
                            jAnnotationArrayMember.param(((Double)value).doubleValue());
                            break;
                        }
                        if (value instanceof Float) {
                            jAnnotationArrayMember.param(((Float)value).floatValue());
                            break;
                        }
                        if (value instanceof Long) {
                            jAnnotationArrayMember.param(((Long)value).longValue());
                            break;
                        }
                        if (value instanceof Short) {
                            jAnnotationArrayMember.param(((Short)value).shortValue());
                            break;
                        }
                        if (value instanceof Integer) {
                            jAnnotationArrayMember.param(((Integer)value).intValue());
                            break;
                        }
                        if (value instanceof String) {
                            jAnnotationArrayMember.param((String)value);
                        }
                        break;
                    }
                    case DECLARED_TYPE: {
                        jAnnotationArrayMember.param((JType)this.model.ref(value.toString()));
                        break;
                    }
                    case ELEMENT: {
                        String qualifiedEnumName = StringUtil.getPackage(value.toString());
                        JPackage dtoJPackage = this.model._package(StringUtil.getPackage(qualifiedEnumName));
                        JDefinedClass definedClass = dtoJPackage._class(StringUtil.getSimpleClassName(qualifiedEnumName));
                        jAnnotationArrayMember.param(definedClass.enumConstant(value.toString()));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Failed to addAnnotationParam, because the kind is unknown: " + (Object)((Object)annotationValueInfo.getKind()));
                    }
                }
            }
            catch (JClassAlreadyExistsException e) {
                throw new RuntimeException("JClassAlreadyExistsException", e);
            }
        }
    }
}

