/*
 * Decompiled with CFR 0.152.
 */
package at.rseiler.spbee.core.collector;

import at.rseiler.spbee.core.annotation.MappingConstructor;
import at.rseiler.spbee.core.annotation.ReturnNull;
import at.rseiler.spbee.core.annotation.RowMapper;
import at.rseiler.spbee.core.pojo.ResultSetClass;
import at.rseiler.spbee.core.pojo.ResultSetVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

public class ResultSetCollector {
    private final Set<? extends Element> elements;
    private final Map<String, ResultSetClass> resultSetMap = new HashMap<String, ResultSetClass>();

    public ResultSetCollector(Set<? extends Element> elements) {
        this.elements = elements;
    }

    public Map<String, ResultSetClass> getResultSetMap() {
        return this.resultSetMap;
    }

    public ResultSetCollector collect() {
        for (Element element2 : this.elements) {
            List<ResultSetVariable> types = element2.getEnclosedElements().stream().filter(this.isField()).map(element -> new ResultSetVariable(element.getSimpleName().toString(), element.asType().toString(), element.getAnnotation(RowMapper.class), element.getAnnotation(ReturnNull.class), element.getAnnotation(MappingConstructor.class))).collect(Collectors.toList());
            String name = element2.toString();
            this.resultSetMap.put(name, new ResultSetClass(name, types));
        }
        return this;
    }

    private Predicate<Element> isField() {
        return element -> element.getKind() == ElementKind.FIELD;
    }
}

