/*
 * Decompiled with CFR 0.152.
 */
package at.rseiler.spbee.core.collector;

import at.rseiler.spbee.core.annotation.MappingConstructor;
import at.rseiler.spbee.core.pojo.MapperClass;
import at.rseiler.spbee.core.pojo.Variable;
import at.rseiler.spbee.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

public class EntityClassCollector {
    private final ProcessingEnvironment processingEnv;
    private final Set<? extends Element> elements;
    private final List<MapperClass> mapperClasses = new ArrayList<MapperClass>();

    public EntityClassCollector(ProcessingEnvironment processingEnv, Set<? extends Element> elements) {
        this.processingEnv = processingEnv;
        this.elements = elements;
    }

    public List<MapperClass> getMapperClasses() {
        return this.mapperClasses;
    }

    public EntityClassCollector collect() {
        for (Element element : this.elements) {
            String qualifiedClassName = element.toString();
            boolean hasMappingConstructor = this.hasMappingConstructor(element);
            List<Element> elementList = element.getEnclosedElements().stream().filter(this.isApplicableConstructor(hasMappingConstructor)).collect(Collectors.toList());
            if (hasMappingConstructor || elementList.size() == 1) {
                elementList.forEach(this.collectMappingConstructor(qualifiedClassName));
                continue;
            }
            if (elementList.isEmpty()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "No public constructor for the Entity class '" + qualifiedClassName + "'");
                continue;
            }
            if (elementList.size() > 1) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "More than one public constructor and none of these has a @MappingConstructor annotation for '" + qualifiedClassName + "'");
                continue;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "No applicable constructor for '" + qualifiedClassName + "'");
        }
        return this;
    }

    private Predicate<Element> isApplicableConstructor(boolean annotatedMappingConstructorExists) {
        return element -> {
            boolean valid = !annotatedMappingConstructorExists || element.getAnnotation(MappingConstructor.class) != null;
            return element.getKind() == ElementKind.CONSTRUCTOR && element.getModifiers().contains((Object)Modifier.PUBLIC) && valid;
        };
    }

    private Consumer<Element> collectMappingConstructor(String qualifiedClassName) {
        return element -> {
            MappingConstructor mappingConstructor = element.getAnnotation(MappingConstructor.class);
            String name = mappingConstructor != null ? mappingConstructor.value() : "Default";
            String qualifiedMapperClassName = StringUtil.getQualifiedMapperClassName(qualifiedClassName, name);
            MapperClass mapperClass = new MapperClass(qualifiedMapperClassName, qualifiedClassName);
            for (VariableElement variableElement : ((ExecutableElement)element).getParameters()) {
                mapperClass.addVariable(new Variable(variableElement.getSimpleName().toString(), variableElement.asType().toString()));
            }
            this.mapperClasses.add(mapperClass);
        };
    }

    private boolean hasMappingConstructor(Element entityClassElement) {
        return entityClassElement.getEnclosedElements().stream().anyMatch(element -> this.isMappingConstructor((Element)element));
    }

    private boolean isMappingConstructor(Element element) {
        return element.getKind() == ElementKind.CONSTRUCTOR && element.getModifiers().contains((Object)Modifier.PUBLIC) && element.getAnnotation(MappingConstructor.class) != null;
    }
}

