/*
 * Decompiled with CFR 0.152.
 */
package at.rseiler.spbee.core.collector;

import at.rseiler.spbee.core.annotation.MappingConstructor;
import at.rseiler.spbee.core.annotation.ReturnNull;
import at.rseiler.spbee.core.annotation.RowMapper;
import at.rseiler.spbee.core.annotation.StoredProcedure;
import at.rseiler.spbee.core.pojo.DtoClass;
import at.rseiler.spbee.core.pojo.StoredProcedureMethod;
import at.rseiler.spbee.core.pojo.Variable;
import at.rseiler.spbee.core.util.StringUtil;
import com.sun.codemodel.JClassAlreadyExistsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class DtoCollector {
    private final Set<? extends Element> elements;
    private List<DtoClass> dtoClasses = new ArrayList<DtoClass>();

    public DtoCollector(Set<? extends Element> elements) {
        this.elements = elements;
    }

    public List<DtoClass> getDtoClasses() {
        return this.dtoClasses;
    }

    public DtoCollector collect() throws JClassAlreadyExistsException, IOException {
        for (Element element : this.elements) {
            boolean hasDataSourceConstructor = element.getEnclosedElements().stream().anyMatch(this.hasDataSourceConstructor());
            DtoClass dtoClass = new DtoClass(element.toString(), element.getKind().isInterface(), hasDataSourceConstructor);
            this.dtoClasses.add(dtoClass);
            element.getEnclosedElements().stream().filter(this.isStoredProcedureMethod()).forEach(this.collectDtoMethod(dtoClass));
        }
        return this;
    }

    private Predicate<Element> hasDataSourceConstructor() {
        return element -> {
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                ExecutableElement executableElement = (ExecutableElement)element;
                List<? extends VariableElement> parameters = executableElement.getParameters();
                return parameters.size() == 1 && "javax.sql.DataSource".equals(parameters.get(0).asType().toString());
            }
            return false;
        };
    }

    private Predicate<Element> isStoredProcedureMethod() {
        return element -> element.getKind() == ElementKind.METHOD && element.getAnnotation(StoredProcedure.class) != null;
    }

    private Consumer<Element> collectDtoMethod(DtoClass dtoClass) {
        return element -> {
            ExecutableElement executableElement = (ExecutableElement)element;
            StoredProcedureMethod storedProcedureMethod = new StoredProcedureMethod.Builder().dtoClassName(dtoClass.getQualifiedClassName()).methodName(executableElement.getSimpleName().toString()).returnTypeInfo(StringUtil.getTypeInfo(executableElement.getReturnType().toString())).annotations(this.getAnnotations(executableElement)).storedProcedure(executableElement.getAnnotation(StoredProcedure.class)).rowMapper(executableElement.getAnnotation(RowMapper.class)).returnNull(executableElement.getAnnotation(ReturnNull.class)).mappingConstructor(executableElement.getAnnotation(MappingConstructor.class)).build();
            for (VariableElement variableElement : executableElement.getParameters()) {
                storedProcedureMethod.addArgument(this.getVariable(variableElement));
            }
            dtoClass.add(storedProcedureMethod);
        };
    }

    private List<AnnotationMirror> getAnnotations(ExecutableElement executableElement) {
        return executableElement.getAnnotationMirrors().stream().filter(annotationMirror -> !annotationMirror.getAnnotationType().toString().startsWith("at.rseiler.spbee.core.annotation")).collect(Collectors.toList());
    }

    private Variable getVariable(VariableElement variableElement) {
        return new Variable(variableElement.getSimpleName().toString(), variableElement.asType().toString());
    }
}

