/*
 * Decompiled with CFR 0.152.
 */
package at.rseiler.spbee.core;

import at.rseiler.spbee.core.annotation.Dao;
import at.rseiler.spbee.core.annotation.Entity;
import at.rseiler.spbee.core.annotation.ResultSet;
import at.rseiler.spbee.core.collector.DtoCollector;
import at.rseiler.spbee.core.collector.EntityClassCollector;
import at.rseiler.spbee.core.collector.ResultSetCollector;
import at.rseiler.spbee.core.generator.DtoGenerator;
import at.rseiler.spbee.core.generator.MapperGenerator;
import at.rseiler.spbee.core.generator.StoredProcedureGenerator;
import at.rseiler.spbee.core.pojo.AnnotationProcessingContext;
import at.rseiler.spbee.core.pojo.DtoClass;
import at.rseiler.spbee.core.pojo.MapperClass;
import at.rseiler.spbee.core.pojo.ResultSetClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"at.rseiler.spbee.core.annotation.ResultSet", "at.rseiler.spbee.core.annotation.Entity", "at.rseiler.spbee.core.annotation.Dao"})
public class SPBeeAnnotationProcessor
extends AbstractProcessor {
    public static final String SPBEE_ANNOTATION_PREFIX = "at.rseiler.spbee.core.annotation";
    public static final String DATA_FILE = "at/rseiler/spbee/context.data";
    public static final String CONFIG = "spbee.properties";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        try {
            if (!annotations.isEmpty()) {
                Properties config = this.loadConfig();
                AnnotationProcessingContext context = this.loadPreviousContext(config);
                context = this.collectData(config, annotations, roundEnvironment, context);
                this.generateCode(context);
                this.storeContext(context);
            }
        }
        catch (RuntimeException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, SPBeeAnnotationProcessor.getStackTrace(e));
        }
        return true;
    }

    private Properties loadConfig() {
        Properties config = new Properties();
        try {
            FileObject resource = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", CONFIG);
            if (new File(resource.toUri()).exists()) {
                config.load(resource.openInputStream());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AnnotationProcessingContext loadPreviousContext(Properties config) {
        try {
            FileObject resource = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", DATA_FILE);
            if (!new File(resource.toUri()).exists()) return new AnnotationProcessingContext(config, new HashMap<String, ResultSetClass>(), new ArrayList<MapperClass>(), new ArrayList<DtoClass>());
            try (ObjectInputStream objectInputStream = new ObjectInputStream(resource.openInputStream());){
                AnnotationProcessingContext annotationProcessingContext = (AnnotationProcessingContext)objectInputStream.readObject();
                return annotationProcessingContext;
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to read file:" + SPBeeAnnotationProcessor.getStackTrace(e));
            return new AnnotationProcessingContext(config, new HashMap<String, ResultSetClass>(), new ArrayList<MapperClass>(), new ArrayList<DtoClass>());
        }
        catch (ClassNotFoundException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to deserialize the data file: " + SPBeeAnnotationProcessor.getStackTrace(e));
        }
        return new AnnotationProcessingContext(config, new HashMap<String, ResultSetClass>(), new ArrayList<MapperClass>(), new ArrayList<DtoClass>());
    }

    private AnnotationProcessingContext collectData(Properties config, Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment, AnnotationProcessingContext context) {
        Map<String, ResultSetClass> resultSetsMap = new HashMap<String, ResultSetClass>();
        List<MapperClass> mapperClasses = new ArrayList<MapperClass>();
        List<DtoClass> dtoClasses = new ArrayList<DtoClass>();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(typeElement);
            try {
                if (typeElement.toString().equals(ResultSet.class.getCanonicalName())) {
                    resultSetsMap = new ResultSetCollector(elements).collect().getResultSetMap();
                    continue;
                }
                if (typeElement.toString().equals(Entity.class.getCanonicalName())) {
                    mapperClasses = new EntityClassCollector(this.processingEnv, elements).collect().getMapperClasses();
                    continue;
                }
                if (!typeElement.toString().equals(Dao.class.getCanonicalName())) continue;
                dtoClasses = new DtoCollector(elements).collect().getDtoClasses();
            }
            catch (JClassAlreadyExistsException | IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.toString() + SPBeeAnnotationProcessor.getStackTrace((Exception)e));
            }
        }
        for (Map.Entry entry : context.getResultSetsMap().entrySet()) {
            resultSetsMap.putIfAbsent((String)entry.getKey(), (ResultSetClass)entry.getValue());
        }
        context = new AnnotationProcessingContext(config, resultSetsMap, mapperClasses, dtoClasses);
        return context;
    }

    private void generateCode(AnnotationProcessingContext context) {
        try {
            new MapperGenerator(this.processingEnv).generateMappers(context.getMapperClasses());
            new StoredProcedureGenerator(this.processingEnv, context.getResultSetsMap()).generateStoredProcedureClasses(context.getDtoClasses());
            new DtoGenerator(this.processingEnv, context.getConfig(), context.getResultSetsMap()).generateDtoClasses(context.getDtoClasses());
        }
        catch (JClassAlreadyExistsException | IOException | ClassNotFoundException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, SPBeeAnnotationProcessor.getStackTrace((Exception)e));
        }
    }

    private void storeContext(AnnotationProcessingContext context) {
        try {
            FileObject resource = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", DATA_FILE, new Element[0]);
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(resource.openOutputStream());){
                objectOutputStream.writeObject(context);
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, SPBeeAnnotationProcessor.getStackTrace(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStackTrace(Exception exception) {
        StringWriter sw = new StringWriter();
        try {
            exception.printStackTrace(new PrintWriter(sw));
            String string = sw.toString();
            return string;
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException iOException) {}
        }
    }
}

