/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.sparql.spring;

import akka.actor.ActorSystem;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import won.matcher.service.common.config.ClusterConfig;
import won.matcher.service.common.spring.SpringExtension;
import won.matcher.sparql.config.SparqlMatcherConfig;

@Configuration
@PropertySource(value={"file:${WON_CONFIG_DIR}/matcher-sparql.properties", "file:${WON_CONFIG_DIR}/cluster-node.properties"})
@ComponentScan(value={"won.matcher.sparql.spring", "won.matcher.service.common.config", "won.matcher.service.common.service.http", "won.matcher.sparql.actor", "won.matcher.sparql.config", "won.matcher.sparql.index", "won.matcher.sparql.query", "won.matcher.sparql.hints"})
@ImportResource(value={"classpath:/spring/component/matcher-service/ehcache/spring-node-ehcache.xml", "classpath:/matcher-sparql-security.xml", "classpath:/spring/component/cryptographyServices.xml", "classpath:/spring/component/wonNodeInformationService.xml"})
public class MatcherSparqlAppConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ClusterConfig clusterConfig;
    @Autowired
    private SparqlMatcherConfig matcherConfig;

    @Bean
    public ActorSystem actorSystem() {
        String seedNodes = "[";
        for (String seed : this.clusterConfig.getSeedNodes()) {
            seedNodes = seedNodes + "\"akka.tcp://" + this.clusterConfig.getName() + "@" + seed.trim() + "\",";
        }
        seedNodes = seedNodes + "]";
        Config applicationConf = ConfigFactory.load();
        Config config = ConfigFactory.parseString((String)("akka.cluster.seed-nodes=" + seedNodes)).withFallback((ConfigMergeable)ConfigFactory.parseString((String)("akka.remote.netty.tcp.bind-port=" + this.clusterConfig.getLocalPort()))).withFallback((ConfigMergeable)ConfigFactory.parseString((String)("akka.remote.netty.tcp.hostname=" + this.clusterConfig.getNodeHost()))).withFallback((ConfigMergeable)ConfigFactory.parseString((String)("akka.remote.netty.tcp.port=" + this.clusterConfig.getLocalPort()))).withFallback((ConfigMergeable)ConfigFactory.parseString((String)"akka.cluster.roles=[matcher]")).withFallback((ConfigMergeable)ConfigFactory.load((Config)applicationConf));
        ActorSystem system = ActorSystem.create((String)this.clusterConfig.getName(), (Config)config);
        LoggingAdapter log = Logging.getLogger((ActorSystem)system, (Object)this);
        log.info("Using Akka system settings: " + system.settings().toString());
        ((SpringExtension.SpringExt)SpringExtension.SpringExtProvider.get(system)).initialize(this.applicationContext);
        return system;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertyConfigInDev() {
        return new PropertySourcesPlaceholderConfigurer();
    }
}

