/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.sparql.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.OneForOneStrategy;
import akka.actor.SupervisorStrategy;
import akka.actor.UntypedActor;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.japi.Function;
import com.github.jsonldjava.core.JsonLdError;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelExtract;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StatementBoundary;
import org.apache.jena.rdf.model.StatementBoundaryBase;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_StrContains;
import org.apache.jena.sparql.expr.E_StrLowerCase;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.nodevalue.NodeValueBoolean;
import org.apache.jena.sparql.expr.nodevalue.NodeValueString;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.Path;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import scala.concurrent.duration.Duration;
import won.matcher.service.common.event.BulkHintEvent;
import won.matcher.service.common.event.BulkNeedEvent;
import won.matcher.service.common.event.HintEvent;
import won.matcher.service.common.event.NeedEvent;
import won.matcher.sparql.config.SparqlMatcherConfig;
import won.protocol.util.NeedModelWrapper;
import won.protocol.util.linkeddata.LinkedDataSource;

@Component
@Scope(value="prototype")
public class SparqlMatcherActor
extends UntypedActor {
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private ActorRef pubSubMediator;
    @Autowired
    private SparqlMatcherConfig config;
    @Autowired
    private LinkedDataSource linkedDataSource;
    private static final Var resultName = Var.alloc((String)"result");

    public void preStart() throws IOException {
        this.pubSubMediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
    }

    public void onReceive(Object o) throws Exception {
        if (o instanceof NeedEvent) {
            NeedEvent needEvent = (NeedEvent)o;
            if (needEvent.getEventType().equals((Object)NeedEvent.TYPE.ACTIVE)) {
                this.processActiveNeedEvent(needEvent);
            } else if (needEvent.getEventType().equals((Object)NeedEvent.TYPE.INACTIVE)) {
                this.processInactiveNeedEvent(needEvent);
            } else {
                this.unhandled(o);
            }
        } else if (o instanceof BulkNeedEvent) {
            this.log.info("received bulk need event, processing {} need events ...", (Object)((BulkNeedEvent)o).getNeedEvents().size());
            for (NeedEvent event : ((BulkNeedEvent)o).getNeedEvents()) {
                this.processActiveNeedEvent(event);
            }
        } else {
            this.unhandled(o);
        }
    }

    protected void processInactiveNeedEvent(NeedEvent needEvent) throws IOException, JsonLdError {
        this.log.info("Received inactive need.");
    }

    private static String hashFunction(Object input) {
        return Integer.toHexString(input.hashCode());
    }

    private static BasicPattern createDetailsQuery(Model model) {
        BasicPattern pattern = new BasicPattern();
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(model.listStatements(), 4096), true).map(statement -> {
            Triple triple = statement.asTriple();
            RDFNode object = statement.getObject();
            Node newSubject = NodeFactory.createVariable((String)SparqlMatcherActor.hashFunction(triple.getSubject()));
            Node newObject = triple.getObject();
            if (object.isAnon()) {
                newObject = NodeFactory.createVariable((String)SparqlMatcherActor.hashFunction(newObject));
            }
            return new Triple(newSubject, triple.getPredicate(), newObject);
        }).filter(p -> p != null).forEach(arg_0 -> ((BasicPattern)pattern).add(arg_0));
        return pattern;
    }

    private static Op createNeedQuery(Model model, final Statement parentStatement, Node newPredicate) {
        StatementBoundaryBase boundary = new StatementBoundaryBase(){

            public boolean stopAt(Statement s) {
                return parentStatement.getSubject().equals((Object)s.getSubject());
            }
        };
        Model subModel = new ModelExtract((StatementBoundary)boundary).extract(parentStatement.getObject().asResource(), model);
        BasicPattern pattern = SparqlMatcherActor.createDetailsQuery(subModel);
        if (pattern.isEmpty()) {
            return null;
        }
        pattern.add(new Triple(resultName.asNode(), newPredicate, NodeFactory.createVariable((String)SparqlMatcherActor.hashFunction(parentStatement.getObject()))));
        return new OpBGP(pattern);
    }

    private static Op createSearchQuery(String searchString) {
        Node blank = NodeFactory.createURI((String)"");
        P_Link blankPath = new P_Link(blank);
        P_NegPropSet negation = new P_NegPropSet();
        negation.add((P_Path0)blankPath);
        P_Alt any = new P_Alt((Path)blankPath, (Path)negation);
        P_Link isPath = new P_Link(NodeFactory.createURI((String)"http://purl.org/webofneeds/model#is"));
        P_Link seeksPath = new P_Link(NodeFactory.createURI((String)"http://purl.org/webofneeds/model#seeks"));
        Path searchPath = (Path)Collections.nCopies(5, new P_ZeroOrOne((Path)any)).stream().reduce(new P_Alt((Path)isPath, (Path)seeksPath), P_Seq::new);
        Var textSearchTarget = Var.alloc((String)"textSearchTarget");
        OpPath pathOp = new OpPath(new TriplePath(resultName.asNode(), searchPath, textSearchTarget.asNode()));
        Expr filterExpression = Arrays.stream(searchString.toLowerCase().split(" ")).map(searchPart -> new E_StrContains((Expr)new E_StrLowerCase((Expr)new ExprVar(textSearchTarget)), (Expr)new NodeValueString(searchPart))).reduce((left, right) -> new E_LogicalOr(left, right)).orElse((Expr)new NodeValueBoolean(true));
        return OpFilter.filterBy((ExprList)new ExprList(filterExpression), (Op)pathOp);
    }

    protected void processActiveNeedEvent(NeedEvent needEvent) throws IOException {
        NeedModelWrapper need = new NeedModelWrapper(needEvent.deserializeNeedDataset());
        this.log.debug("starting sparql-based matching for need {}", (Object)need.getNeedUri());
        Set<NeedModelWrapper> matches = this.queryNeed(need);
        Map<NeedModelWrapper, Set> filteredNeeds = Stream.of(new AbstractMap.SimpleEntry<NeedModelWrapper, Set<NeedModelWrapper>>(need, matches)).map(entry -> {
            Set filteredMatches = ((Set)entry.getValue()).stream().filter(f -> this.postFilter((NeedModelWrapper)entry.getKey(), (NeedModelWrapper)f)).collect(Collectors.toSet());
            return new AbstractMap.SimpleEntry(entry.getKey(), filteredMatches);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        BulkHintEvent bulkHintEvent = new BulkHintEvent();
        filteredNeeds.forEach((hintTarget, hints) -> hints.stream().limit(this.config.getLimitResults()).forEach(hint -> bulkHintEvent.addHintEvent(new HintEvent(hintTarget.getWonNodeUri(), hintTarget.getNeedUri(), hint.getWonNodeUri(), hint.getNeedUri(), this.config.getMatcherUri(), 1.0))));
        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(bulkHintEvent.getClass().getName(), (Object)bulkHintEvent), this.getSelf());
        this.log.debug("finished sparql-based matching for need {} (found {} matches)", (Object)need.getNeedUri(), (Object)bulkHintEvent.getHintEvents().size());
    }

    private Optional<Op> clientSuppliedQuery(String queryString) {
        Query query = QueryFactory.create((String)queryString);
        if (query.getQueryType() != 111) {
            return Optional.empty();
        }
        if (!query.getProjectVars().contains(resultName)) {
            return Optional.empty();
        }
        Op op = Algebra.compile((Query)query);
        return Optional.of(new OpDistinct(op));
    }

    private Optional<Op> defaultQuery(NeedModelWrapper need) {
        Statement search;
        Op isQuery;
        Statement is;
        Op seeksQuery;
        Model model = need.getNeedModel();
        String needURI = need.getNeedUri();
        ArrayList<Op> queries = new ArrayList<Op>(3);
        Statement seeks = model.getProperty(model.createResource(needURI), model.createProperty("http://purl.org/webofneeds/model#seeks"));
        if (seeks != null && (seeksQuery = SparqlMatcherActor.createNeedQuery(model, seeks, NodeFactory.createURI((String)"http://purl.org/webofneeds/model#is"))) != null) {
            queries.add(seeksQuery);
        }
        if ((is = model.getProperty(model.createResource(needURI), model.createProperty("http://purl.org/webofneeds/model#is"))) != null && (isQuery = SparqlMatcherActor.createNeedQuery(model, is, NodeFactory.createURI((String)"http://purl.org/webofneeds/model#seeks"))) != null) {
            queries.add(isQuery);
        }
        if ((search = model.getProperty(model.createResource(needURI), model.createProperty("http://purl.org/webofneeds/model#hasSearchString"))) != null) {
            String searchString = search.getString();
            queries.add(SparqlMatcherActor.createSearchQuery(searchString));
        }
        return queries.stream().reduce((left, right) -> new OpUnion(left, right)).map(union -> new OpDistinct((Op)new OpProject(union, Arrays.asList(resultName))));
    }

    private Set<NeedModelWrapper> queryNeed(NeedModelWrapper need) {
        return this.queryNeed(need, Optional.empty());
    }

    private Set<NeedModelWrapper> queryNeed(NeedModelWrapper need, Optional<String> needUriToMatch) {
        Model model = need.getNeedModel();
        String needURI = need.getNeedUri();
        Optional userQuery = need.getQuery();
        Optional<Op> query = userQuery.isPresent() ? this.clientSuppliedQuery((String)userQuery.get()) : this.defaultQuery(need);
        Set needs = query.map(q -> {
            try {
                Query compiledQuery = OpAsQuery.asQuery((Op)q);
                if (needUriToMatch.isPresent()) {
                    Binding binding = BindingFactory.binding((Var)resultName, (Node)new ResourceImpl((String)needUriToMatch.get()).asNode());
                    compiledQuery.setValuesDataBlock(Collections.singletonList(resultName), Collections.singletonList(binding));
                }
                compiledQuery.setLimit(this.config.getLimitResults() * 2L);
                QueryExecution execution = QueryExecutionFactory.sparqlService((String)this.config.getSparqlEndpoint(), (Query)compiledQuery);
                ResultSet result = execution.execSelect();
                Stream<QuerySolution> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(result, 4096), false);
                Set matchedNeeds = stream.map(querySolution -> {
                    String foundNeedURI = querySolution.get(resultName.getName()).toString();
                    try {
                        return new NeedModelWrapper(this.linkedDataSource.getDataForResource(new URI(foundNeedURI)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }).filter(foundNeed -> foundNeed != null).collect(Collectors.toSet());
                return matchedNeeds;
            }
            catch (Exception e) {
                this.log.info("caught exception during sparql-based matching (more info on loglevel 'debug'): {} ", (Object)e.getMessage());
                this.log.debug("full exception:", (Object)e);
                return Collections.EMPTY_SET;
            }
        }).orElse(new HashSet());
        return needs;
    }

    private static Set<String> getMatchingContexts(NeedModelWrapper need) {
        Model model = need.getNeedModel();
        Resource needURI = model.createResource(need.getNeedUri());
        Property matchingContextProperty = model.createProperty("http://purl.org/webofneeds/model#hasMatchingContext");
        Stream<RDFNode> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(model.listObjectsOfProperty(needURI, matchingContextProperty), 4096), false);
        return stream.map(node -> node.asLiteral().getString()).collect(Collectors.toSet());
    }

    private boolean postFilter(NeedModelWrapper need, NeedModelWrapper foundNeed) {
        try {
            if (need.getNeedUri().equals(foundNeed.getNeedUri())) {
                return false;
            }
            if (need.hasFlag(ResourceFactory.createResource((String)"http://purl.org/webofneeds/model#NoHintForMe"))) {
                return false;
            }
            if (foundNeed.hasFlag(ResourceFactory.createResource((String)"http://purl.org/webofneeds/model#NoHintForCounterpart"))) {
                return false;
            }
            Set<String> needContexts = SparqlMatcherActor.getMatchingContexts(need);
            if (!needContexts.isEmpty()) {
                Set<String> foundNeedContexts = SparqlMatcherActor.getMatchingContexts(foundNeed);
                foundNeedContexts.retainAll(needContexts);
                if (foundNeedContexts.isEmpty()) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.log.info("caught Exception during post-filtering, ignoring match", (Object)e);
            return false;
        }
    }

    public SupervisorStrategy supervisorStrategy() {
        OneForOneStrategy supervisorStrategy = new OneForOneStrategy(0, (Duration)Duration.Zero(), (Function)new Function<Throwable, SupervisorStrategy.Directive>(){

            public SupervisorStrategy.Directive apply(Throwable t) throws Exception {
                SparqlMatcherActor.this.log.warning("Actor encountered error: {}", (Object)t);
                return SupervisorStrategy.escalate();
            }
        });
        return supervisorStrategy;
    }
}

