/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.sparql.actor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import akka.actor.OneForOneStrategy;
import akka.actor.PoisonPill;
import akka.actor.SupervisorStrategy;
import akka.actor.UntypedActor;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.japi.Function;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import won.matcher.service.common.event.BulkHintEvent;
import won.matcher.service.common.event.BulkNeedEvent;
import won.matcher.service.common.event.HintEvent;
import won.matcher.service.common.event.LoadNeedEvent;
import won.matcher.service.common.event.NeedEvent;
import won.matcher.service.common.spring.SpringExtension;
import won.matcher.sparql.actor.SparqlMatcherActor;
import won.matcher.sparql.config.SparqlMatcherConfig;

@Component
@Scope(value="prototype")
public class MatcherPubSubActor
extends UntypedActor {
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private ActorRef pubSubMediator;
    private ActorRef matcherActor;
    @Autowired
    private SparqlMatcherConfig config;
    private static final String TICK = "tick";
    private static final String APP_STATE_PROPERTIES_FILE_NAME = "state.config.properties";
    private static final String LAST_SEEN_NEED_DATE_PROPERTY_NAME = "lastSeenNeedDate";
    private boolean needsUpdateRequestReceived = false;
    private Properties appStateProps = new Properties();
    private Optional<Cancellable> scheduledTick = Optional.empty();

    public void preStart() throws IOException {
        this.pubSubMediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
        this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Subscribe(NeedEvent.class.getName(), this.getSelf()), this.getSelf());
        this.matcherActor = this.getContext().actorOf(((SpringExtension.SpringExt)SpringExtension.SpringExtProvider.get(this.getContext().system())).fromConfigProps(SparqlMatcherActor.class), "SparqlMatcherPool");
        this.scheduledTick = Optional.of(this.getContext().system().scheduler().schedule(Duration.create((long)30L, (TimeUnit)TimeUnit.SECONDS), Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS), this.getSelf(), (Object)TICK, (ExecutionContext)this.getContext().dispatcher(), null));
        FileInputStream in = null;
        try {
            in = new FileInputStream(APP_STATE_PROPERTIES_FILE_NAME);
            this.appStateProps.load(in);
            this.log.info("loaded properties file {}, property '{}' is set to " + this.appStateProps.getProperty(LAST_SEEN_NEED_DATE_PROPERTY_NAME), (Object)APP_STATE_PROPERTIES_FILE_NAME, (Object)LAST_SEEN_NEED_DATE_PROPERTY_NAME);
        }
        catch (FileNotFoundException e) {
            this.log.info("properties file {} not found, create file", (Object)APP_STATE_PROPERTIES_FILE_NAME);
        }
        catch (IOException e) {
            this.log.error("cannot read properties file {}", (Object)APP_STATE_PROPERTIES_FILE_NAME);
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (this.appStateProps.getProperty(LAST_SEEN_NEED_DATE_PROPERTY_NAME) == null) {
                this.appStateProps.setProperty(LAST_SEEN_NEED_DATE_PROPERTY_NAME, String.valueOf(-1));
                this.saveLastSeenNeedDate();
            }
        }
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        if (this.matcherActor != null) {
            this.matcherActor.tell((Object)PoisonPill.getInstance(), this.getSelf());
        }
        this.cancelScheduledTick();
    }

    public void postStop() throws Exception {
        this.cancelScheduledTick();
    }

    private void cancelScheduledTick() {
        if (this.scheduledTick.isPresent()) {
            this.scheduledTick.get().cancel();
        }
    }

    public void saveLastSeenNeedDate() throws IOException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(APP_STATE_PROPERTIES_FILE_NAME);
            this.appStateProps.store(out, null);
        }
    }

    public void onReceive(Object o) throws Exception {
        if (o.equals(TICK)) {
            if (!this.needsUpdateRequestReceived) {
                LoadNeedEvent loadNeedEvent;
                long lastSeenNeedDate = Long.valueOf(this.appStateProps.getProperty(LAST_SEEN_NEED_DATE_PROPERTY_NAME));
                if (lastSeenNeedDate == -1L) {
                    loadNeedEvent = new LoadNeedEvent(1);
                } else {
                    this.log.info("request missed needs from matching service with crawl date > {}", (Object)lastSeenNeedDate);
                    loadNeedEvent = new LoadNeedEvent(lastSeenNeedDate, Long.MAX_VALUE);
                }
                this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(loadNeedEvent.getClass().getName(), (Object)loadNeedEvent), this.getSelf());
            }
        } else if (o instanceof NeedEvent) {
            NeedEvent needEvent = (NeedEvent)o;
            this.log.info("NeedEvent received: " + needEvent);
            if (this.needsUpdateRequestReceived) {
                long lastSeenNeedDate = Long.valueOf(this.appStateProps.getProperty(LAST_SEEN_NEED_DATE_PROPERTY_NAME));
                if (needEvent.getCrawlDate() > lastSeenNeedDate) {
                    this.appStateProps.setProperty(LAST_SEEN_NEED_DATE_PROPERTY_NAME, String.valueOf(needEvent.getCrawlDate()));
                    this.saveLastSeenNeedDate();
                }
            }
            this.matcherActor.tell((Object)needEvent, this.getSelf());
        } else if (o instanceof BulkNeedEvent) {
            this.needsUpdateRequestReceived = true;
            BulkNeedEvent bulkNeedEvent = (BulkNeedEvent)o;
            this.log.info("BulkNeedEvent received with {} need events", (Object)bulkNeedEvent.getNeedEvents().size());
            for (NeedEvent needEvent : ((BulkNeedEvent)o).getNeedEvents()) {
                long lastSeenNeedDate = Long.valueOf(this.appStateProps.getProperty(LAST_SEEN_NEED_DATE_PROPERTY_NAME));
                if (needEvent.getCrawlDate() > lastSeenNeedDate) {
                    this.appStateProps.setProperty(LAST_SEEN_NEED_DATE_PROPERTY_NAME, String.valueOf(needEvent.getCrawlDate()));
                    this.saveLastSeenNeedDate();
                }
                this.matcherActor.tell((Object)needEvent, this.getSelf());
            }
        } else if (o instanceof HintEvent) {
            HintEvent hintEvent = (HintEvent)o;
            this.log.info("Publish hint event: " + hintEvent);
            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(hintEvent.getClass().getName(), (Object)hintEvent), this.getSelf());
        } else if (o instanceof BulkHintEvent) {
            BulkHintEvent bulkHintEvent = (BulkHintEvent)o;
            this.log.info("Publish bulk hint event: " + bulkHintEvent);
            this.pubSubMediator.tell((Object)new DistributedPubSubMediator.Publish(bulkHintEvent.getClass().getName(), (Object)bulkHintEvent), this.getSelf());
        } else {
            this.unhandled(o);
        }
    }

    public SupervisorStrategy supervisorStrategy() {
        OneForOneStrategy supervisorStrategy = new OneForOneStrategy(0, (Duration)Duration.Zero(), (Function)new Function<Throwable, SupervisorStrategy.Directive>(){

            public SupervisorStrategy.Directive apply(Throwable t) throws Exception {
                MatcherPubSubActor.this.log.warning("Actor encountered error: {}", (Object)t);
                return SupervisorStrategy.escalate();
            }
        });
        return supervisorStrategy;
    }
}

