/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.solr.utils;

import java.util.LinkedList;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class Kneedle {
    private double sensitivity = 1.0;

    public Kneedle() {
        this.sensitivity = 1.0;
    }

    public Kneedle(double sensitivity) {
        this.sensitivity = sensitivity;
    }

    public int[] detectKneePoints(double[] x, double[] y) {
        return this.detectKneeOrElbowPoints(x, y, false);
    }

    public int[] detectElbowPoints(double[] x, double[] y) {
        return this.detectKneeOrElbowPoints(x, y, true);
    }

    private int[] detectKneeOrElbowPoints(double[] x, double[] y, boolean detectElbows) {
        int i;
        this.checkConstraints(x, y);
        LinkedList kneeIndices = new LinkedList();
        LinkedList<Integer> lmxIndices = new LinkedList<Integer>();
        LinkedList<Double> lmxThresholds = new LinkedList<Double>();
        double[] xn = this.normalize(x);
        double[] yn = this.normalize(y);
        double[] yDiff = new double[y.length];
        for (int i2 = 0; i2 < y.length; ++i2) {
            yDiff[i2] = yn[i2] - xn[i2];
        }
        if (detectElbows) {
            DescriptiveStatistics stats = new DescriptiveStatistics(yDiff);
            for (i = 0; i < yDiff.length; ++i) {
                yDiff[i] = stats.getMax() - yDiff[i];
            }
        }
        boolean detectKneeForLastLmx = false;
        for (i = 1; i < y.length - 1; ++i) {
            if (yDiff[i] > yDiff[i - 1] && yDiff[i] > yDiff[i + 1]) {
                lmxIndices.add(i);
                double tlmx = yDiff[i] - this.sensitivity / (double)(xn.length - 1);
                lmxThresholds.add(tlmx);
                detectKneeForLastLmx = true;
            }
            if (!detectKneeForLastLmx || !(yDiff[i + 1] < (Double)lmxThresholds.get(lmxThresholds.size() - 1))) continue;
            kneeIndices.add(lmxIndices.get(lmxIndices.size() - 1));
            detectKneeForLastLmx = false;
        }
        int[] knees = new int[kneeIndices.size()];
        for (int i3 = 0; i3 < kneeIndices.size(); ++i3) {
            knees[i3] = (Integer)kneeIndices.get(i3);
        }
        return knees;
    }

    private double[] normalize(double[] values) {
        double[] normalized = new double[values.length];
        DescriptiveStatistics stats = new DescriptiveStatistics(values);
        for (int i = 0; i < values.length; ++i) {
            normalized[i] = (values[i] - stats.getMin()) / (stats.getMax() - stats.getMin());
        }
        return normalized;
    }

    private void checkConstraints(double[] x, double[] y) {
        if (x.length != y.length || x.length < 2) {
            throw new IllegalArgumentException("x and y arrays must have size > 1 and the same number of elements");
        }
        for (int i = 0; i < x.length - 1; ++i) {
            if (!(x[i + 1] <= x[i])) continue;
            throw new IllegalArgumentException("x values must be sorted and increasing");
        }
    }
}

