/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.solr.query.factory;

import java.util.Collection;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Resource;
import won.matcher.solr.query.factory.BasicNeedQueryFactory;
import won.protocol.model.NeedContentPropertyType;

public class DefaultNeedQueryFactory
extends BasicNeedQueryFactory {
    public DefaultNeedQueryFactory(Dataset need) {
        super(need);
        for (Resource contentNode : this.needModelWrapper.getContentNodes(NeedContentPropertyType.IS)) {
            this.addTermsToQuery(contentNode, NeedContentPropertyType.SEEKS);
            this.addLocationFilters(contentNode, NeedContentPropertyType.SEEKS);
        }
        for (Resource contentNode : this.needModelWrapper.getContentNodes(NeedContentPropertyType.SEEKS)) {
            this.addTermsToQuery(contentNode, NeedContentPropertyType.IS);
            this.addTermsToQuery(contentNode, NeedContentPropertyType.SEEKS_SEEKS);
            this.addLocationFilters(contentNode, NeedContentPropertyType.IS);
            this.addLocationFilters(contentNode, NeedContentPropertyType.SEEKS_SEEKS);
        }
        for (Resource contentNode : this.needModelWrapper.getContentNodes(NeedContentPropertyType.SEEKS_SEEKS)) {
            this.addTermsToQuery(contentNode, NeedContentPropertyType.SEEKS);
            this.addLocationFilters(contentNode, NeedContentPropertyType.SEEKS);
        }
    }

    private void addTermsToQuery(Resource contentNode, NeedContentPropertyType fieldType) {
        Collection titles = this.needModelWrapper.getTitles(contentNode);
        Collection descriptions = this.needModelWrapper.getDescriptions(contentNode);
        Collection tags = this.needModelWrapper.getTags(contentNode);
        String tagsTerms = "\"" + String.join((CharSequence)"\" \"", tags) + "\"";
        titles.stream().forEach(title -> this.addTermsToTitleQuery((String)title, fieldType, 4.0));
        this.addTermsToTitleQuery(tagsTerms, fieldType, 2.0);
        this.addTermsToTagQuery(tagsTerms, fieldType, 4.0);
        titles.stream().forEach(title -> this.addTermsToTagQuery((String)title, fieldType, 2.0));
        titles.stream().forEach(title -> this.addTermsToDescriptionQuery((String)title, fieldType, 2.0));
        this.addTermsToDescriptionQuery(tagsTerms, fieldType, 2.0);
        descriptions.stream().forEach(descr -> this.addTermsToDescriptionQuery((String)descr, fieldType, 1.0));
    }
}

