/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.solr.index;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import won.matcher.service.common.service.http.HttpService;
import won.matcher.solr.config.SolrMatcherConfig;
import won.protocol.model.Coordinate;
import won.protocol.model.NeedContentPropertyType;
import won.protocol.util.DefaultNeedModelWrapper;
import won.protocol.util.NeedModelWrapper;
import won.protocol.vocabulary.WON;

@Component
@Scope(value="prototype")
public class NeedIndexer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String SOLR_IS_LOCATION_COORDINATES_FIELD = "is_need_location";
    public static final String SOLR_SEEKS_LOCATION_COORDINATES_FIELD = "seeks_need_location";
    public static final String SOLR_SEEKS_SEEKS_LOCATION_COORDINATES_FIELD = "seeksSeeks_need_location";
    private static final String NEED_INDEX_QUERY = "prefix won: <http://purl.org/webofneeds/model#> construct { ?a ?b ?c .} where { GRAPH ?graph { ?need a won:Need. ?a ?b ?c. } }";
    @Autowired
    private SolrMatcherConfig config;
    @Autowired
    private HttpService httpService;

    public void index(Dataset dataset) throws IOException, JsonLdError {
        Query query = QueryFactory.create((String)NEED_INDEX_QUERY);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        Model needModel = qexec.execConstruct();
        NeedModelWrapper needModelWrapper = new NeedModelWrapper(needModel, null);
        String needUri = needModelWrapper.getNeedUri();
        needModel = needModelWrapper.normalizeNeedModel();
        boolean usedForTesting = needModelWrapper.hasFlag(WON.USED_FOR_TESTING);
        this.indexNeedModel(needModel, needUri, usedForTesting);
    }

    public void indexNeedModel(Model needModel, String id, boolean useTestCore) throws IOException, JsonLdError {
        Coordinate coordinate;
        StringWriter sw = new StringWriter();
        RDFDataMgr.write((StringWriter)sw, (Model)needModel, (Lang)Lang.JSONLD);
        String jsonld = sw.toString();
        Object jsonObject = JsonUtils.fromString((String)jsonld);
        Object frame = JsonUtils.fromString((String)(" {\"@type\": \"" + WON.NEED + "\"} "));
        JsonLdOptions options = new JsonLdOptions();
        Map framed = JsonLdProcessor.frame((Object)jsonObject, (Object)frame, (JsonLdOptions)options);
        framed.put("id", id);
        DefaultNeedModelWrapper needModelWrapper = new DefaultNeedModelWrapper(needModel, null);
        for (Resource contentNode : needModelWrapper.getContentNodes(NeedContentPropertyType.IS)) {
            coordinate = needModelWrapper.getLocationCoordinate(contentNode);
            if (coordinate == null) continue;
            framed.put(SOLR_IS_LOCATION_COORDINATES_FIELD, String.valueOf(coordinate.getLatitude()) + "," + String.valueOf(coordinate.getLongitude()));
        }
        for (Resource contentNode : needModelWrapper.getContentNodes(NeedContentPropertyType.SEEKS)) {
            coordinate = needModelWrapper.getLocationCoordinate(contentNode);
            if (coordinate == null) continue;
            framed.put(SOLR_SEEKS_LOCATION_COORDINATES_FIELD, String.valueOf(coordinate.getLatitude()) + "," + String.valueOf(coordinate.getLongitude()));
        }
        for (Resource contentNode : needModelWrapper.getContentNodes(NeedContentPropertyType.SEEKS_SEEKS)) {
            coordinate = needModelWrapper.getLocationCoordinate(contentNode);
            if (coordinate == null) continue;
            framed.put(SOLR_SEEKS_SEEKS_LOCATION_COORDINATES_FIELD, String.valueOf(coordinate.getLatitude()) + "," + String.valueOf(coordinate.getLongitude()));
        }
        sw = new StringWriter();
        JsonUtils.writePrettyPrint((Writer)sw, (Object)framed);
        String needJson = sw.toString();
        String indexUri = this.config.getSolrEndpointUri(useTestCore);
        indexUri = indexUri + "update/json/docs";
        if (this.config.isCommitIndexedNeedImmediately()) {
            indexUri = indexUri + "?commit=" + this.config.isCommitIndexedNeedImmediately();
        }
        this.log.debug("Post need to solr index. \n Solr URI: {} \n Need (JSON): {}", (Object)indexUri, (Object)needJson);
        this.httpService.postJsonRequest(indexUri, needJson);
    }
}

