/*
 * Decompiled with CFR 0.152.
 */
package won.matcher.solr.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ImportResource(value={"classpath:/spring/component/scheduling/matcher-service-scheduling.xml"})
@PropertySource(value={"file:${WON_CONFIG_DIR}/matcher-solr.properties"})
public class SolrMatcherConfig {
    @Value(value="${matcher.solr.uri.solr.server}")
    private String solrServerUri;
    @Value(value="${matcher.solr.core}")
    private String solrCore;
    @Value(value="${matcher.solr.test.core}")
    private String solrTestCore;
    @Value(value="${matcher.solr.uri.solr.server.public}")
    private String solrServerPublicUri;
    @Value(value="${matcher.solr.query.maxHints}")
    private int maxHints;
    @Value(value="${matcher.solr.query.maxHintsForCounterparts}")
    private int maxHintsForCounterparts;
    @Value(value="${matcher.solr.index.commit}")
    private boolean commitIndexedNeedImmediately;
    @Value(value="${matcher.solr.query.score.threshold}")
    private float scoreThreshold;
    @Value(value="${matcher.solr.query.cutAfterIthElbowInScore}")
    private int cutAfterIthElbowInScore;
    @Value(value="${matcher.solr.query.score.normalizationFactor}")
    private float scoreNormalizationFactor;

    public float getScoreThreshold() {
        return this.scoreThreshold;
    }

    public String getSolrServerUri() {
        return this.solrServerUri;
    }

    public int getMaxHints() {
        return this.maxHints;
    }

    public int getMaxHintsForCounterparts() {
        return this.maxHintsForCounterparts;
    }

    public boolean isCommitIndexedNeedImmediately() {
        return this.commitIndexedNeedImmediately;
    }

    public String getSolrServerPublicUri() {
        return this.solrServerPublicUri;
    }

    public int getCutAfterIthElbowInScore() {
        return this.cutAfterIthElbowInScore;
    }

    public float getScoreNormalizationFactor() {
        return this.scoreNormalizationFactor;
    }

    public String getSolrCore() {
        return this.solrCore;
    }

    public String getSolrTestCore() {
        return this.solrTestCore;
    }

    public String getSolrEndpointUri(boolean useTestCore) {
        String core;
        String server = this.getSolrServerUri();
        if (!server.endsWith("/")) {
            server = server + "/";
        }
        if (!(core = server + (useTestCore ? this.getSolrTestCore() : this.getSolrCore())).endsWith("/")) {
            core = core + "/";
        }
        return core;
    }
}

