/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.vocabulary;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import won.protocol.model.AtomState;
import won.protocol.model.ConnectionState;

public class WON {
    public static final String BASE_URI = "https://w3id.org/won/core#";
    public static final String DEFAULT_PREFIX = "won";
    private static Model m = ModelFactory.createDefaultModel();
    public static final Resource Atom = m.createResource("https://w3id.org/won/core#Atom");
    public static final Property wonNode = m.createProperty("https://w3id.org/won/core#", "wonNode");
    public static final Property defaultGraphSigningMethod = m.createProperty("https://w3id.org/won/core#", "defaultGraphSigningMethod");
    public static final Property nodeQueue = m.createProperty("https://w3id.org/won/core#", "nodeQueue");
    public static final Property ownerQueue = m.createProperty("https://w3id.org/won/core#", "ownerQueue");
    public static final Property matcherQueue = m.createProperty("https://w3id.org/won/core#", "matcherQueue");
    public static final Property atomCreatedTopic = m.createProperty("https://w3id.org/won/core#", "atomCreatedTopic");
    public static final Property atomActivatedTopic = m.createProperty("https://w3id.org/won/core#", "atomActivatedTopic");
    public static final Property atomDeactivatedTopic = m.createProperty("https://w3id.org/won/core#", "atomDeactivatedTopic");
    public static final Property atomDeletedTopic = m.createProperty("https://w3id.org/won/core#", "atomDeletedTopic");
    public static final Property uriPrefixSpecification = m.createProperty("https://w3id.org/won/core#", "uriPrefixSpecification");
    public static final Property atomUriPrefix = m.createProperty("https://w3id.org/won/core#", "atomUriPrefix");
    public static final Property connectionUriPrefix = m.createProperty("https://w3id.org/won/core#", "connectionUriPrefix");
    public static final Property eventUriPrefix = m.createProperty("https://w3id.org/won/core#", "eventUriPrefix");
    public static final Property atomList = m.createProperty("https://w3id.org/won/core#", "atomList");
    public static final Property supportsWonProtocolImpl = m.createProperty("https://w3id.org/won/core#supportsWonProtocolImpl");
    public static final Resource WonOverActiveMq = m.createResource("https://w3id.org/won/core#WonOverActiveMq");
    public static final Property brokerUri = m.createProperty("https://w3id.org/won/core#", "brokerUri");
    public static final Property atomState = m.createProperty("https://w3id.org/won/core#", "atomState");
    public static final Property contentGraph = m.createProperty("https://w3id.org/won/core#", "contentGraph");
    public static final Property derivedGraph = m.createProperty("https://w3id.org/won/core#", "derivedGraph");
    public static final Property socket = m.createProperty("https://w3id.org/won/core#", "socket");
    public static final Property defaultSocket = m.createProperty("https://w3id.org/won/core#", "defaultSocket");
    public static final Resource Socket = m.createResource("https://w3id.org/won/core#Socket");
    public static final Property compatibleSocketDefinition = m.createProperty("https://w3id.org/won/core#compatibleSocketDefinition");
    public static final Property socketDefinition = m.createProperty("https://w3id.org/won/core#", "socketDefinition");
    public static final Property derivesAtomProperty = m.createProperty("https://w3id.org/won/core#derivesAtomProperty");
    public static final Property derivesInverseAtomProperty = m.createProperty("https://w3id.org/won/core#derivesInverseAtomProperty");
    public static final Property socketCapacity = m.createProperty("https://w3id.org/won/core#", "socketCapacity");
    public static final Property autoOpen = m.createProperty("https://w3id.org/won/core#", "autoOpen");
    public static final Property targetSocket = m.createProperty("https://w3id.org/won/core#targetSocket");
    public static final Property connections = m.createProperty("https://w3id.org/won/core#", "connections");
    public static final Resource ConnectionContainer = m.createResource("https://w3id.org/won/core#ConnectionContainer");
    public static final Resource Connection = m.createResource("https://w3id.org/won/core#Connection");
    public static final Property connectionState = m.createProperty("https://w3id.org/won/core#", "connectionState");
    public static final Property targetConnection = m.createProperty("https://w3id.org/won/core#", "targetConnection");
    public static final Property targetAtom = m.createProperty("https://w3id.org/won/core#", "targetAtom");
    public static final Property sourceAtom = m.createProperty("https://w3id.org/won/core#", "sourceAtom");
    public static final Property messageContainer = m.createProperty("https://w3id.org/won/core#", "messageContainer");
    public static final Resource MessageContainer = m.createResource("https://w3id.org/won/core#MessageContainer");
    public static final Property timeStamp = m.createProperty("https://w3id.org/won/core#", "timeStamp");
    public static final Property additionalData = m.createProperty("https://w3id.org/won/core#", "additionalData");
    public static final Property goal = m.createProperty("https://w3id.org/won/core#", "goal");
    public static final Property shapesGraph = m.createProperty("https://w3id.org/won/core#", "shapesGraph");
    public static final Property dataGraph = m.createProperty("https://w3id.org/won/core#", "dataGraph");
    public static final Resource ATOM_STATE_ACTIVE = m.createResource(AtomState.ACTIVE.getURI().toString());
    public static final Resource ATOM_STATE_INACTIVE = m.createResource(AtomState.INACTIVE.getURI().toString());
    public static final Resource ATOM_STATE_DELETED = m.createResource(AtomState.DELETED.getURI().toString());
    public static final Resource CONNECTION_STATE_SUGGESTED = m.createResource(ConnectionState.SUGGESTED.getURI().toString());
    public static final Resource CONNECTION_STATE_REQUEST_SENT = m.createResource(ConnectionState.REQUEST_SENT.getURI().toString());
    public static final Resource CONNECTION_STATE_REQUEST_RECEIVED = m.createResource(ConnectionState.REQUEST_RECEIVED.getURI().toString());
    public static final Resource CONNECTION_STATE_CONNECTED = m.createResource(ConnectionState.CONNECTED.getURI().toString());
    public static final Resource CONNECTION_STATE_CLOSED = m.createResource(ConnectionState.CLOSED.getURI().toString());
    public static final Resource CONNECTION_STATE_DELETED = m.createResource(ConnectionState.DELETED.getURI().toString());
    public static final Property suggestedCount = m.createProperty("https://w3id.org/won/core#", "suggestedCount");
    public static final Property requestReceivedCount = m.createProperty("https://w3id.org/won/core#", "requestReceivedCount");
    public static final Property requestSentCount = m.createProperty("https://w3id.org/won/core#", "requestSentCount");
    public static final Property connectedCount = m.createProperty("https://w3id.org/won/core#", "connectedCount");
    public static final Property closedCount = m.createProperty("https://w3id.org/won/core#", "closedCount");
    public static final Property deletedCount = m.createProperty("https://w3id.org/won/core#", "deletedCount");
    public static final Property unreadSuggested = m.createProperty("https://w3id.org/won/core#unreadSuggested");
    public static final Property unreadRequestSent = m.createProperty("https://w3id.org/won/core#unreadRequestSent");
    public static final Property unreadRequestReceived = m.createProperty("https://w3id.org/won/core#unreadRequestReceived");
    public static final Property unreadConnected = m.createProperty("https://w3id.org/won/core#unreadConnected");
    public static final Property unreadClosed = m.createProperty("https://w3id.org/won/core#unreadClosed");
    public static final Property unreadOldestTimestamp = m.createProperty("https://w3id.org/won/core#unreadOldestTimestamp");
    public static final Property unreadNewestTimestamp = m.createProperty("https://w3id.org/won/core#unreadNewestTimestamp");
    public static final Property unreadCount = m.createProperty("https://w3id.org/won/core#unreadCount");
    public static final Resource ECCPublicKey = m.createResource("https://w3id.org/won/core#ECCPublicKey");
    public static final Property ecc_curveId = m.createProperty("https://w3id.org/won/core#", "ecc_curveId");
    public static final Property ecc_algorithm = m.createProperty("https://w3id.org/won/core#", "ecc_algorithm");
    public static final Property ecc_qx = m.createProperty("https://w3id.org/won/core#", "ecc_qx");
    public static final Property ecc_qy = m.createProperty("https://w3id.org/won/core#", "ecc_qy");
    public static final String CLIENT_CERTIFICATE_HEADER = "X-Client-Certificate";

    public static String getURI() {
        return BASE_URI;
    }

    public static Resource toResource(AtomState state) {
        switch (state) {
            case ACTIVE: {
                return ATOM_STATE_ACTIVE;
            }
            case INACTIVE: {
                return ATOM_STATE_INACTIVE;
            }
            case DELETED: {
                return ATOM_STATE_DELETED;
            }
        }
        throw new IllegalArgumentException("No case specified for " + state.name());
    }

    public static Resource toResource(ConnectionState type) {
        switch (type) {
            case SUGGESTED: {
                return CONNECTION_STATE_SUGGESTED;
            }
            case REQUEST_SENT: {
                return CONNECTION_STATE_REQUEST_SENT;
            }
            case REQUEST_RECEIVED: {
                return CONNECTION_STATE_REQUEST_RECEIVED;
            }
            case CONNECTED: {
                return CONNECTION_STATE_CONNECTED;
            }
            case CLOSED: {
                return CONNECTION_STATE_CLOSED;
            }
        }
        throw new IllegalArgumentException("No such case specified for " + type.name());
    }
}

