/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.vocabulary;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GRDeliveryMethod {
    DELIVERY_MODE_DIRECT_DOWNLOAD("DeliveryModeDirectDownload"),
    DELIVERY_MODE_FREIGHT("DeliveryModeFreight"),
    DELIVERY_MODE_MAIL("DeliveryModeMail"),
    DELIVERY_MODE_OWN_FLEET("DeliveryModeOwnFleet"),
    DELIVERY_MODE_PICK_UP("DeliveryModePickUp");

    private static final Logger logger;
    private String name;

    private GRDeliveryMethod(String name) {
        this.name = name;
    }

    public URI getURI() {
        return URI.create("http://purl.org/goodrelations/v1#" + this.name);
    }

    public static GRDeliveryMethod parseString(String fragment) {
        for (GRDeliveryMethod state : GRDeliveryMethod.values()) {
            if (!state.name.equals(fragment)) continue;
            return state;
        }
        logger.warn("No enum could be matched for: {}", (Object)fragment);
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

