/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.validation;

import java.lang.invoke.MethodHandles;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.tdb.TDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WonSparqlValidator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Var SELECT_VALIDATION_VARIABLE = Var.alloc((String)"check");
    public static final String SELECT_VALIDATION_PASSED_VALUE = "OK";
    private Query constraint;
    private String name = "unknown";

    public WonSparqlValidator(Query constraint) {
        if (!constraint.isAskType() && !constraint.isSelectType()) {
            throw new IllegalArgumentException("Wrong constraint type!");
        }
        this.constraint = constraint;
    }

    public WonSparqlValidator(Query constraint, String name) {
        if (!constraint.isAskType() && !constraint.isSelectType()) {
            throw new IllegalArgumentException("Wrong constraint type!");
        }
        this.constraint = constraint;
        this.name = name;
    }

    public ValidationResult validate(Dataset input) {
        if (logger.isDebugEnabled()) {
            logger.debug("validating constraint of WonSparqlValidator '{}'", (Object)this.name);
        }
        try {
            input.begin(ReadWrite.READ);
            if (this.constraint.isAskType()) {
                ValidationResult validationResult = this.validateAsk(input);
                return validationResult;
            }
            if (this.constraint.isSelectType()) {
                ValidationResult validationResult = this.validateSelect(input);
                return validationResult;
            }
        }
        finally {
            input.end();
        }
        return new ValidationResult(false, "Invalid constraint: " + this.constraint.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ValidationResult validateSelect(Dataset input) {
        Throwable throwable = null;
        try (QueryExecution qe = QueryExecutionFactory.create((Query)this.constraint, (Dataset)input);){
            qe.getContext().set(TDB.symUnionDefaultGraph, true);
            ResultSet result = qe.execSelect();
            if (!result.hasNext() && this.constraint.getProjectVars().stream().noneMatch(var -> "check".equals(var.getVarName()))) {
                ValidationResult validationResult = new ValidationResult();
                return validationResult;
            }
            if (!result.hasNext()) throw new IllegalStateException("No result obtained from query, there seems to be some problem with the constraint: " + this.constraint.toString(Syntax.syntaxSPARQL_11));
            Binding binding = result.nextBinding();
            Node node = binding.get(SELECT_VALIDATION_VARIABLE);
            if (node != null) {
                if (node.isLiteral()) {
                    String resultString = node.getLiteralValue().toString();
                    if (SELECT_VALIDATION_PASSED_VALUE.equals(resultString)) {
                        ValidationResult validationResult = new ValidationResult();
                        return validationResult;
                    }
                    ValidationResult validationResult = new ValidationResult(false, "SELECT query produced this binding: " + binding.toString());
                    return validationResult;
                }
            } else {
                String errorMessage = "SPARQL query produced this solution, which indicates a problem: " + binding.toString() + ", query: " + this.constraint.toString(Syntax.syntaxSPARQL_11);
                if (result.hasNext()) {
                    errorMessage = errorMessage + ". Note: this is only the first solution. There are more problems.";
                }
                ValidationResult validationResult = new ValidationResult(false, errorMessage);
                return validationResult;
            }
            try {
                throw new IllegalStateException("We should have returned a result earlier. Bindings: " + binding.toString() + ", Constraint: " + this.constraint.toString(Syntax.syntaxSPARQL_11));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private void printResult(ResultSet result) {
        System.out.println(ResultSetFormatter.asText((ResultSet)result));
    }

    private ValidationResult validateAsk(Dataset input) {
        try (QueryExecution qe = QueryExecutionFactory.create((Query)this.constraint, (Dataset)input);){
            if (qe.execAsk()) {
                ValidationResult validationResult = new ValidationResult(false, "ASK query returned true");
                return validationResult;
            }
            ValidationResult validationResult = new ValidationResult();
            return validationResult;
        }
    }

    public String getName() {
        return this.name;
    }

    public static class ValidationResult {
        private boolean valid = true;
        private String errorMessage = null;

        public ValidationResult() {
        }

        public ValidationResult(boolean valid, String errorMessage) {
            this.valid = valid;
            this.errorMessage = errorMessage;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

