/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import won.protocol.validation.WonSparqlValidator;

public class ValidationUtils {
    public static List<WonSparqlValidator> loadResources(PathMatchingResourcePatternResolver resolver, String dirString) throws IOException {
        Resource[] resources;
        ArrayList<WonSparqlValidator> validators = new ArrayList<WonSparqlValidator>();
        for (Resource resource : resources = resolver.getResources("classpath:" + dirString + "*.rq")) {
            try {
                String queryString = ValidationUtils.loadQueryFromResource(resource);
                Query constraint = QueryFactory.create((String)queryString);
                WonSparqlValidator validator = new WonSparqlValidator(constraint, resource.getFilename());
                validators.add(validator);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error loading query from resource " + resource.toString() + ": " + e.getMessage(), e);
            }
        }
        return validators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadQueryFromResource(Resource resource) {
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(resource.getInputStream(), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

