/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.validation;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.query.Dataset;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import won.protocol.validation.ValidationUtils;
import won.protocol.validation.WonSparqlValidator;

public abstract class BaseValidator {
    protected Map<String, List<WonSparqlValidator>> dirToValidator = new LinkedHashMap<String, List<WonSparqlValidator>>();

    public final boolean validate(Dataset input) {
        for (String dir : this.dirToValidator.keySet()) {
            List<WonSparqlValidator> validators = this.dirToValidator.get(dir);
            for (WonSparqlValidator validator : validators) {
                if (validator.validate(input).isValid()) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean validate(Dataset input, StringBuilder causePlaceholder) {
        for (String dir : this.dirToValidator.keySet()) {
            List<WonSparqlValidator> validators = this.dirToValidator.get(dir);
            for (WonSparqlValidator validator : validators) {
                WonSparqlValidator.ValidationResult result = validator.validate(input);
                if (result.isValid()) continue;
                causePlaceholder.append(dir);
                causePlaceholder.append(validator.getName());
                causePlaceholder.append(": ").append(result.getErrorMessage());
                return false;
            }
        }
        return true;
    }

    protected void loadSparqlValidatorsFromDirectories(String[] dirs) {
        HashMap<String, List<WonSparqlValidator>> validatorsPerDir = new HashMap<String, List<WonSparqlValidator>>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (String dir : dirs) {
            try {
                List<WonSparqlValidator> validators = ValidationUtils.loadResources(resolver, dir);
                validatorsPerDir.put(dir, Collections.unmodifiableList(validators));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.dirToValidator = Collections.unmodifiableMap(validatorsPerDir);
    }
}

