/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util.linkeddata.impl;

import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Iterator;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.modify.UpdateProcessRemote;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.util.linkeddata.CrawlerCallback;

public class SparqlUpdateCrawlerCallback
implements CrawlerCallback {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    String sparqlEndpoint = null;

    public void setSparqlEndpoint(String sparqlEndpoint) {
        this.sparqlEndpoint = sparqlEndpoint;
    }

    @Override
    public void onDatasetCrawled(URI uri, Dataset dataset) {
        if (null == this.sparqlEndpoint) {
            logger.warn("no SPARQL endpoint defined");
            return;
        }
        Iterator graphNames = dataset.listNames();
        while (graphNames.hasNext()) {
            StringBuilder quadpatterns = new StringBuilder();
            String graphName = (String)graphNames.next();
            Model model = dataset.getNamedModel(graphName);
            StringWriter sw = new StringWriter();
            RDFDataMgr.write((StringWriter)sw, (Model)model, (Lang)Lang.NTRIPLES);
            quadpatterns.append("\nINSERT DATA { GRAPH <").append(graphName).append("> { ").append(sw).append("}};\n");
            logger.info(quadpatterns.toString());
            UpdateRequest update = UpdateFactory.create((String)quadpatterns.toString());
            UpdateProcessRemote riStore = (UpdateProcessRemote)UpdateExecutionFactory.createRemote((UpdateRequest)update, (String)this.sparqlEndpoint);
            riStore.execute();
        }
    }
}

