/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util.linkeddata;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.SimpleSelector;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathParser;
import org.apache.jena.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.model.AtomState;
import won.protocol.model.SocketDefinition;
import won.protocol.model.SocketDefinitionImpl;
import won.protocol.service.WonNodeInfo;
import won.protocol.util.RdfUtils;
import won.protocol.util.WonRdfUtils;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.vocabulary.WON;
import won.protocol.vocabulary.WONMSG;

public class WonLinkedDataUtils {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static URI getConnectionStateforConnectionURI(URI connectionURI, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        Dataset dataset = WonLinkedDataUtils.getDataForResource(connectionURI, linkedDataSource);
        Path propertyPath = PathParser.parse((String)("<" + WON.connectionState + ">"), (PrefixMapping)PrefixMapping.Standard);
        return RdfUtils.getURIPropertyForPropertyPath(dataset, connectionURI, propertyPath);
    }

    public static URI getAtomURIforConnectionURI(URI connectionURI, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        Dataset dataset = WonLinkedDataUtils.getDataForResource(connectionURI, linkedDataSource);
        Path propertyPath = PathParser.parse((String)("<" + WON.sourceAtom + ">"), (PrefixMapping)PrefixMapping.Standard);
        return RdfUtils.getURIPropertyForPropertyPath(dataset, connectionURI, propertyPath);
    }

    public static URI getTargetConnectionURIforConnectionURI(URI connectionURI, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        Dataset dataset = WonLinkedDataUtils.getDataForResource(connectionURI, linkedDataSource);
        Path propertyPath = PathParser.parse((String)("<" + WON.targetConnection + ">"), (PrefixMapping)PrefixMapping.Standard);
        return RdfUtils.getURIPropertyForPropertyPath(dataset, connectionURI, propertyPath);
    }

    public static URI getTargetAtomURIforConnectionURI(URI connectionURI, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        Dataset dataset = WonLinkedDataUtils.getDataForResource(connectionURI, linkedDataSource);
        Path propertyPath = PathParser.parse((String)("<" + WON.targetAtom + ">"), (PrefixMapping)PrefixMapping.Standard);
        return RdfUtils.getURIPropertyForPropertyPath(dataset, connectionURI, propertyPath);
    }

    public static URI getMessageContainerURIforConnectionURI(URI connectionURI, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        Dataset dataset = WonLinkedDataUtils.getDataForResource(connectionURI, linkedDataSource);
        Path propertyPath = PathParser.parse((String)("<" + WON.messageContainer + ">"), (PrefixMapping)PrefixMapping.Standard);
        return RdfUtils.getURIPropertyForPropertyPath(dataset, connectionURI, propertyPath);
    }

    public static URI getMessageContainerURIforAtomURI(URI atomURI, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        Dataset dataset = WonLinkedDataUtils.getDataForResource(atomURI, linkedDataSource);
        Path propertyPath = PathParser.parse((String)("<" + WON.messageContainer + ">"), (PrefixMapping)PrefixMapping.Standard);
        return RdfUtils.getURIPropertyForPropertyPath(dataset, atomURI, propertyPath);
    }

    public static Dataset getConversationAndAtomsDataset(String connectionURI, LinkedDataSource linkedDataSource) {
        return WonLinkedDataUtils.getConversationAndAtomsDataset(URI.create(connectionURI), linkedDataSource);
    }

    public static List<URI> getNodeAtomUris(URI nodeURI, LinkedDataSource linkedDataSource) {
        return WonLinkedDataUtils.getNodeAtomUris(nodeURI, null, null, null, linkedDataSource);
    }

    public static List<URI> getNodeAtomUris(URI nodeURI, ZonedDateTime modifiedAfter, ZonedDateTime createdAfter, AtomState atomState, LinkedDataSource linkedDataSource) {
        String queryPart;
        Dataset nodeDataset = WonLinkedDataUtils.getDataForResource(nodeURI, linkedDataSource);
        WonNodeInfo wonNodeInfo = WonRdfUtils.WonNodeUtils.getWonNodeInfo(nodeURI, nodeDataset);
        URI atomListUri = URI.create(wonNodeInfo.getAtomListURI());
        String newQuery = atomListUri.getQuery();
        if (atomState != null) {
            queryPart = "state=" + modifiedAfter;
            String string = newQuery = newQuery == null ? queryPart : "&" + queryPart;
        }
        if (modifiedAfter != null) {
            queryPart = "modifiedafter=" + modifiedAfter;
            String string = newQuery = newQuery == null ? queryPart : "&" + queryPart;
        }
        if (createdAfter != null) {
            queryPart = "modifiedafter=" + createdAfter;
            newQuery = newQuery == null ? queryPart : "&" + queryPart;
        }
        try {
            atomListUri = new URI(atomListUri.getScheme(), atomListUri.getAuthority(), atomListUri.getPath(), newQuery, atomListUri.getFragment());
        }
        catch (URISyntaxException e) {
            logger.warn("Could not append parameters to nodeURI, proceeding request without parameters");
        }
        Dataset atomListDataset = WonLinkedDataUtils.getDataForResource(atomListUri, linkedDataSource);
        return RdfUtils.visitFlattenedToList(atomListDataset, model -> {
            StmtIterator it = model.listStatements((Resource)null, RDFS.member, (RDFNode)null);
            ArrayList<URI> ret = new ArrayList<URI>();
            while (it.hasNext()) {
                ret.add(URI.create(((Statement)it.next()).getObject().toString()));
            }
            return ret;
        });
    }

    public static Dataset getFullAtomDataset(URI atomURI, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        int depth = 7;
        int maxRequests = 1000;
        ArrayList<Path> propertyPaths = new ArrayList<Path>();
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        pmap.withDefaultMappings(PrefixMapping.Standard);
        pmap.setNsPrefix("won", WON.getURI());
        pmap.setNsPrefix("msg", WONMSG.getURI());
        propertyPaths.add(PathParser.parse((String)"won:connections", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:connections/rdfs:member", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:connections/rdfs:member/won:messageContainer", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:connections/rdfs:member/won:messageContainer/rdfs:member", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:connections/rdfs:member/won:messageContainer/rdfs:member/msg:correspondingRemoteMessage", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:connections/rdfs:member/won:messageContainer/rdfs:member/msg:previousMessage", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:connections/rdfs:member/won:sourceAtom", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:connections/rdfs:member/won:sourceAtom/won:messageContainer", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:connections/rdfs:member/won:sourceAtom/won:messageContainer/rdfs:member", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:connections/rdfs:member/won:sourceAtom/won:messageContainer/rdfs:member/msg:previousMessage", (PrefixMapping)pmap));
        return linkedDataSource.getDataForResourceWithPropertyPath(atomURI, atomURI, propertyPaths, maxRequests, depth);
    }

    public static Dataset getConversationAndAtomsDataset(URI connectionURI, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        int depth = 5;
        int maxRequests = 1000;
        ArrayList<Path> propertyPaths = new ArrayList<Path>();
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        pmap.withDefaultMappings(PrefixMapping.Standard);
        pmap.setNsPrefix("won", WON.getURI());
        pmap.setNsPrefix("msg", WONMSG.getURI());
        propertyPaths.add(PathParser.parse((String)"won:messageContainer", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:messageContainer/rdfs:member", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:messageContainer/rdfs:member/msg:correspondingRemoteMessage", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:messageContainer/rdfs:member/msg:previousMessage", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:sourceAtom", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:sourceAtom/won:messageContainer", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:sourceAtom/won:messageContainer/rdfs:member", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:sourceAtom/won:messageContainer/rdfs:member/msg:previousMessage", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:targetAtom", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:targetAtom/won:messageContainer", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:targetAtom/won:messageContainer/rdfs:member", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:targetAtom/won:messageContainer/rdfs:member/msg:previousMessage", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:targetConnection", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:targetConnection/won:messageContainer", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:targetConnection/won:messageContainer/rdfs:member", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:targetConnection/won:messageContainer/rdfs:member/msg:correspondingRemoteMessage", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:targetConnection/won:messageContainer/rdfs:member/msg:previousMessage", (PrefixMapping)pmap));
        URI requesterWebId = WonLinkedDataUtils.getAtomURIforConnectionURI(connectionURI, linkedDataSource);
        return linkedDataSource.getDataForResourceWithPropertyPath(connectionURI, requesterWebId, propertyPaths, maxRequests, depth);
    }

    public static Dataset getConversationDataset(String connectionURI, LinkedDataSource linkedDataSource) {
        return WonLinkedDataUtils.getConversationDataset(URI.create(connectionURI), linkedDataSource);
    }

    public static Dataset getConversationDataset(URI connectionURI, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        int depth = 5;
        int maxRequests = 1000;
        ArrayList<Path> propertyPaths = new ArrayList<Path>();
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        pmap.withDefaultMappings(PrefixMapping.Standard);
        pmap.setNsPrefix("won", WON.getURI());
        pmap.setNsPrefix("msg", WONMSG.getURI());
        propertyPaths.add(PathParser.parse((String)"won:messageContainer", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:messageContainer/rdfs:member", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:targetConnection", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:targetConnection/won:messageContainer", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:targetConnection/won:messageContainer/rdfs:member", (PrefixMapping)pmap));
        URI requesterWebId = WonLinkedDataUtils.getAtomURIforConnectionURI(connectionURI, linkedDataSource);
        return linkedDataSource.getDataForResourceWithPropertyPath(connectionURI, requesterWebId, propertyPaths, maxRequests, depth);
    }

    public static Dataset getDataForResource(URI connectionURI, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        assert (connectionURI != null) : "connection URI must not be null";
        Dataset dataset = null;
        logger.debug("loading model for connection {}", (Object)connectionURI);
        dataset = linkedDataSource.getDataForResource(connectionURI);
        if (dataset == null) {
            throw new IllegalStateException("failed to load model for Connection " + connectionURI);
        }
        return dataset;
    }

    public static Iterator<Dataset> getModelForURIs(Iterator<URI> uriIterator, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        return new ModelFetchingIterator(uriIterator, linkedDataSource);
    }

    public static URI getWonNodeURIForAtomOrConnectionURI(URI resourceURI, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        logger.debug("fetching WON node URI for resource {} with linked data source {}", (Object)resourceURI, (Object)linkedDataSource);
        return WonLinkedDataUtils.getWonNodeURIForAtomOrConnection(resourceURI, linkedDataSource.getDataForResource(resourceURI));
    }

    public static URI getWonNodeURIForAtomOrConnection(URI resURI, Model resourceModel) {
        assert (resourceModel != null) : "model must not be null";
        logger.debug("getting WON node URI from model");
        Resource baseResource = resourceModel.getResource(resURI.toString());
        logger.debug("resourceModel: {}", (Object)RdfUtils.toString(resourceModel));
        StmtIterator wonNodeStatementIterator = baseResource.listProperties(WON.wonNode);
        if (!wonNodeStatementIterator.hasNext()) {
            logger.debug("base resource {} has no won:wonNode property", (Object)baseResource);
            return null;
        }
        Statement stmt = wonNodeStatementIterator.nextStatement();
        RDFNode wonNodeNode = stmt.getObject();
        if (!wonNodeNode.isResource()) {
            logger.debug("won:wonNode property of base resource {} is not a resource", (Object)baseResource);
            return null;
        }
        URI wonNodeUri = URI.create(wonNodeNode.asResource().getURI().toString());
        logger.debug("obtained WON node URI: {}", (Object)wonNodeUri);
        if (wonNodeStatementIterator.hasNext()) {
            logger.warn("multiple WON node URIs found for resource {}, using first one: {} ", (Object)baseResource, (Object)wonNodeUri);
        }
        return wonNodeUri;
    }

    public static URI getWonNodeURIForAtomOrConnection(final URI resourceURI, Dataset resourceDataset) {
        return RdfUtils.findFirst(resourceDataset, new RdfUtils.ModelVisitor<URI>(){

            @Override
            public URI visit(Model model) {
                return WonLinkedDataUtils.getWonNodeURIForAtomOrConnection(resourceURI, model);
            }
        });
    }

    public static Node getWonNodePropertyForAtomOrConnectionURI(URI resourceURI, Path propertyPath, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        URI wonNodeUri = WonLinkedDataUtils.getWonNodeURIForAtomOrConnectionURI(resourceURI, linkedDataSource);
        Dataset nodeDataset = linkedDataSource.getDataForResource(wonNodeUri);
        return RdfUtils.getNodeForPropertyPath(nodeDataset, wonNodeUri, propertyPath);
    }

    public static Node getPropertyForURI(URI resourceURI, Path propertyPath, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        Dataset dataset = linkedDataSource.getDataForResource(resourceURI);
        return RdfUtils.getNodeForPropertyPath(dataset, resourceURI, propertyPath);
    }

    public static Optional<URI> getDefaultSocket(URI atomURI, boolean returnAnyIfNoDefaultFound, LinkedDataSource linkedDataSource) {
        return WonRdfUtils.SocketUtils.getDefaultSocket(WonLinkedDataUtils.getDataForResource(atomURI, linkedDataSource), atomURI, returnAnyIfNoDefaultFound);
    }

    public static Collection<URI> getSocketsOfType(URI atomURI, URI socketTypeURI, LinkedDataSource linkedDataSource) {
        return WonRdfUtils.SocketUtils.getSocketsOfType(WonLinkedDataUtils.getDataForResource(atomURI, linkedDataSource), atomURI, socketTypeURI);
    }

    public static Set<RdfUtils.Pair<URI>> getCompatibleSocketsForAtoms(LinkedDataSource linkedDataSource, URI firstAtom, URI secondAtom) {
        Dataset dataset = WonLinkedDataUtils.loadDataForAtomWithSocketDefinitions(linkedDataSource, firstAtom);
        RdfUtils.addDatasetToDataset(dataset, WonLinkedDataUtils.loadDataForAtomWithSocketDefinitions(linkedDataSource, secondAtom));
        return WonRdfUtils.SocketUtils.getCompatibleSocketsForAtoms(dataset, firstAtom, secondAtom);
    }

    public static Set<RdfUtils.Pair<URI>> getIncompatibleSocketsForAtoms(LinkedDataSource linkedDataSource, URI firstAtom, URI secondAtom) {
        Dataset dataset = WonLinkedDataUtils.loadDataForAtomWithSocketDefinitions(linkedDataSource, firstAtom);
        RdfUtils.addDatasetToDataset(dataset, WonLinkedDataUtils.loadDataForAtomWithSocketDefinitions(linkedDataSource, secondAtom));
        return WonRdfUtils.SocketUtils.getIncompatibleSocketsForAtoms(dataset, firstAtom, secondAtom);
    }

    public static boolean isCompatibleSockets(LinkedDataSource linkedDataSource, URI firstSocket, URI secondSocket) {
        Optional<URI> firstAtom = WonLinkedDataUtils.getAtomOfSocket(firstSocket, linkedDataSource);
        Optional<URI> secondAtom = WonLinkedDataUtils.getAtomOfSocket(secondSocket, linkedDataSource);
        if (!firstAtom.isPresent()) {
            throw new IllegalStateException("Could not determine atom of socket " + firstSocket);
        }
        if (!secondAtom.isPresent()) {
            throw new IllegalStateException("Could not determine atom of socket " + secondSocket);
        }
        Dataset dataset = WonLinkedDataUtils.loadDataForAtomWithSocketDefinitions(linkedDataSource, firstAtom.get());
        RdfUtils.addDatasetToDataset(dataset, WonLinkedDataUtils.loadDataForAtomWithSocketDefinitions(linkedDataSource, secondAtom.get()));
        return WonRdfUtils.SocketUtils.isSocketsCompatible(dataset, firstSocket, secondSocket);
    }

    public static Dataset loadDataForAtomWithSocketDefinitions(LinkedDataSource linkedDataSource, URI atomURI) {
        Dataset dataset = linkedDataSource.getDataForResource(atomURI);
        Set<URI> sockets = WonRdfUtils.SocketUtils.getSocketsOfAtom(dataset, atomURI);
        sockets.forEach(socket -> RdfUtils.addDatasetToDataset(dataset, WonLinkedDataUtils.loadDataForSocket(linkedDataSource, socket)));
        return dataset;
    }

    public static Dataset loadDataForSocket(LinkedDataSource linkedDataSource, URI socket) {
        Dataset dataset = linkedDataSource.getDataForResource(socket);
        List<URI> configURIs = RdfUtils.getObjectsOfProperty(dataset, socket, URI.create(WON.socketDefinition.getURI()), node -> node.isURIResource() ? URI.create(node.asResource().getURI()) : null);
        if (configURIs.size() > 1) {
            throw new IllegalArgumentException("More than one socket definition found for socket " + socket);
        }
        if (configURIs.size() == 0) {
            throw new IllegalArgumentException("No socket definition found for socket " + socket);
        }
        configURIs.stream().forEach(configURI -> {
            Dataset ds = linkedDataSource.getDataForResource((URI)configURI);
            RdfUtils.addDatasetToDataset(dataset, ds);
        });
        return dataset;
    }

    public static Optional<SocketDefinition> getSocketDefinition(LinkedDataSource linkedDataSource, URI socket) {
        boolean isSocketDefFound;
        Dataset dataset = linkedDataSource.getDataForResource(socket);
        List<URI> configURIs = RdfUtils.getObjectsOfProperty(dataset, socket, URI.create(WON.socketDefinition.getURI()), node -> node.isURIResource() ? URI.create(node.asResource().getURI()) : null);
        if (configURIs.size() > 1) {
            throw new IllegalArgumentException("More than one socket definition found for socket " + socket);
        }
        if (configURIs.size() == 0) {
            throw new IllegalArgumentException("No socket definition found for socket " + socket);
        }
        configURIs.stream().forEach(configURI -> {
            Dataset ds = linkedDataSource.getDataForResource((URI)configURI);
            RdfUtils.addDatasetToDataset(dataset, ds);
        });
        URI socketDefinitionURI = (URI)configURIs.stream().findFirst().get();
        SocketDefinitionImpl socketDef = new SocketDefinitionImpl(socket);
        boolean bl = isSocketDefFound = RdfUtils.findFirst(dataset, model -> {
            if (model.listStatements((Selector)new SimpleSelector(model.createResource(socketDefinitionURI.toString()), null, (RDFNode)null)).hasNext()) {
                return socket;
            }
            return null;
        }) != null;
        if (!isSocketDefFound) {
            throw new IllegalArgumentException("Could not find data for socket definition " + socketDefinitionURI + " of socket " + socket);
        }
        socketDef.setSocketDefinitionURI(socketDefinitionURI);
        WonRdfUtils.SocketUtils.setCompatibleSocketDefinitions(socketDef, dataset, socket);
        WonRdfUtils.SocketUtils.setAutoOpen(socketDef, dataset, socket);
        WonRdfUtils.SocketUtils.setSocketCapacity(socketDef, dataset, socket);
        WonRdfUtils.SocketUtils.setDerivationProperties(socketDef, dataset, socket);
        WonRdfUtils.SocketUtils.setInverseDerivationProperties(socketDef, dataset, socket);
        return Optional.of(socketDef);
    }

    public static Optional<URI> getTypeOfSocket(URI socketURI, LinkedDataSource linkedDataSource) {
        return WonRdfUtils.SocketUtils.getTypeOfSocket(WonLinkedDataUtils.getDataForResource(socketURI, linkedDataSource), socketURI);
    }

    public static Optional<URI> getAtomOfSocket(URI socketURI, LinkedDataSource linkedDataSource) {
        return WonRdfUtils.SocketUtils.getAtomOfSocket(WonLinkedDataUtils.getDataForResource(socketURI, linkedDataSource), socketURI);
    }

    public static Dataset getConnectionNetwork(URI atomURI, LinkedDataSource linkedDataSource) {
        assert (linkedDataSource != null) : "linkedDataSource must not be null";
        int depth = 5;
        int maxRequests = 1000;
        ArrayList<Path> propertyPaths = new ArrayList<Path>();
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        pmap.withDefaultMappings(PrefixMapping.Standard);
        pmap.setNsPrefix("won", WON.getURI());
        pmap.setNsPrefix("msg", WONMSG.getURI());
        propertyPaths.add(PathParser.parse((String)"won:connections", (PrefixMapping)pmap));
        propertyPaths.add(PathParser.parse((String)"won:connections/rdfs:member", (PrefixMapping)pmap));
        return linkedDataSource.getDataForResourceWithPropertyPath(atomURI, atomURI, propertyPaths, maxRequests, depth);
    }

    private static class ModelFetchingIterator
    implements Iterator<Dataset> {
        private Iterator<URI> uriIterator = null;
        private LinkedDataSource linkedDataSource = null;

        private ModelFetchingIterator(Iterator<URI> uriIterator, LinkedDataSource linkedDataSource) {
            this.uriIterator = uriIterator;
            this.linkedDataSource = linkedDataSource;
        }

        @Override
        public Dataset next() {
            URI uri = this.uriIterator.next();
            return this.linkedDataSource.getDataForResource(uri);
        }

        @Override
        public boolean hasNext() {
            return this.uriIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("this iterator cannot remove");
        }
    }
}

