/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util.linkeddata;

import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.expr.nodevalue.NodeValueBoolean;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import won.protocol.rest.DatasetResponseWithStatusCodeAndHeaders;
import won.protocol.rest.LinkedDataFetchingException;
import won.protocol.rest.LinkedDataRestClient;
import won.protocol.util.AuthenticationThreadLocal;
import won.protocol.util.RdfUtils;
import won.protocol.util.linkeddata.LinkedDataSource;

public class LinkedDataSourceBase
implements LinkedDataSource {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected LinkedDataRestClient linkedDataRestClient;
    @Autowired
    private ThreadPoolExecutor parallelRequestsThreadpool;

    public String getPreviousLinkFromDatasetWithHeaders(DatasetResponseWithStatusCodeAndHeaders datasetWithHeaders) {
        String prevLink = null;
        List links = datasetWithHeaders.getResponseHeaders().get((Object)"Link");
        if (links != null) {
            for (String link : links) {
                Pattern pattern = Pattern.compile("<(.+)>; rel=\"?prev\"?");
                Matcher matcher = pattern.matcher(link);
                if (!matcher.find()) continue;
                prevLink = matcher.group(1);
                return prevLink;
            }
        }
        return prevLink;
    }

    public DatasetResponseWithStatusCodeAndHeaders getDatasetWithHeadersForResource(URI resource, HttpHeaders httpHeaders) {
        assert (resource != null) : "resource must not be null";
        logger.debug("fetching linked data for URI {}", (Object)resource);
        return this.linkedDataRestClient.readResourceDataWithHeaders(resource, httpHeaders);
    }

    @Override
    public Dataset getDataForResource(URI resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource must not be null");
        }
        logger.debug("fetching linked data for URI {}", (Object)resource);
        Dataset dataset = DatasetFactory.createGeneral();
        try {
            dataset = this.linkedDataRestClient.readResourceData(resource);
            if (logger.isDebugEnabled()) {
                logger.debug("fetched resource {}:", (Object)resource);
                RDFDataMgr.write((OutputStream)System.out, (Dataset)dataset, (Lang)Lang.TRIG);
            }
        }
        catch (Exception e) {
            logger.debug(String.format("Couldn't fetch resource %s", resource), (Throwable)e);
        }
        return dataset;
    }

    @Override
    public Dataset getDataForResource(URI resource, URI requesterWebID) {
        if (resource == null || requesterWebID == null) {
            throw new IllegalArgumentException("resource and requester must not be null");
        }
        logger.debug("fetching linked data for URI {} requester {}", (Object)resource, (Object)requesterWebID);
        Dataset dataset = DatasetFactory.createGeneral();
        try {
            dataset = this.linkedDataRestClient.readResourceData(resource, requesterWebID);
            if (logger.isDebugEnabled()) {
                logger.debug("fetched resource {} with requesterWebId {}:", (Object)resource, (Object)requesterWebID);
                RDFDataMgr.write((OutputStream)System.out, (Dataset)dataset, (Lang)Lang.TRIG);
            }
        }
        catch (Exception e) {
            logger.debug(String.format("Couldn't fetch resource %s", resource), (Throwable)e);
        }
        return dataset;
    }

    @Override
    public Dataset getDataForResource(URI resourceURI, List<URI> properties, int maxRequest, int maxDepth) {
        return this.getDataForResource(resourceURI, null, properties, maxRequest, maxDepth);
    }

    @Override
    public Dataset getDataForResource(URI resourceURI, URI requesterWebID, List<URI> properties, int maxRequest, int maxDepth) {
        return this.getDataForResource(resourceURI, requesterWebID, maxRequest, maxDepth, (crawledData, crawledUris) -> this.getURIsToCrawl((Dataset)crawledData, (Set<URI>)crawledUris, properties));
    }

    private Set<URI> retainOnlyAllowedAmount(Set<URI> newlyDiscoveredURIs, int maxRequest, int requests) {
        if (newlyDiscoveredURIs.size() + requests > maxRequest) {
            return newlyDiscoveredURIs.stream().collect(Collectors.toList()).subList(0, maxRequest - requests).stream().collect(Collectors.toSet());
        }
        return newlyDiscoveredURIs;
    }

    @Override
    public Dataset getDataForResourceWithPropertyPath(URI resourceURI, List<Path> properties, int maxRequest, int maxDepth, boolean moveAllTriplesInDefaultGraph) {
        Dataset result = DatasetFactory.createGeneral();
        Model m = result.getDefaultModel();
        RdfUtils.toStatementStream(this.getDataForResourceWithPropertyPath(resourceURI, null, properties, maxRequest, maxDepth)).forEach(arg_0 -> ((Model)m).add(arg_0));
        return result;
    }

    @Override
    public Dataset getDataForResourceWithPropertyPath(URI resourceURI, URI requesterWebID, List<Path> properties, int maxRequest, int maxDepth) {
        return this.getDataForResource(resourceURI, requesterWebID, maxRequest, maxDepth, (crawledData, crawledUris) -> this.getURIsToCrawlWithPropertyPath((Dataset)crawledData, resourceURI, (Set<URI>)crawledUris, properties));
    }

    private Dataset getDataForResource(URI resourceURI, URI requesterWebID, int maxRequest, int maxDepth, BiFunction<Dataset, Set<URI>, Set<URI>> findNextUrisFunction) {
        Set<URI> urisToCrawl;
        HashSet<URI> crawledURIs = new HashSet<URI>();
        HashSet<URI> newlyDiscoveredURIs = new HashSet<URI>();
        newlyDiscoveredURIs.add(resourceURI);
        int depth = 0;
        Dataset dataset = LinkedDataSourceBase.makeDataset();
        for (int requests = 0; newlyDiscoveredURIs.size() > 0 && depth < maxDepth && requests < maxRequest; requests += urisToCrawl.size()) {
            Optional crawledDataset;
            urisToCrawl = this.retainOnlyAllowedAmount(newlyDiscoveredURIs, maxRequest, requests);
            Optional<Object> authenticationOpt = AuthenticationThreadLocal.hasValue() ? Optional.of(AuthenticationThreadLocal.getAuthentication()) : Optional.empty();
            Future<Optional> crawledData = this.parallelRequestsThreadpool.submit(() -> urisToCrawl.parallelStream().map(uri -> {
                try {
                    if (authenticationOpt.isPresent()) {
                        AuthenticationThreadLocal.setAuthentication(authenticationOpt.get());
                    }
                    Dataset dataset = requesterWebID == null ? this.getDataForResource((URI)uri) : this.getDataForResource((URI)uri, requesterWebID);
                    return dataset;
                }
                finally {
                    AuthenticationThreadLocal.remove();
                }
            }).reduce((all, current) -> RdfUtils.addDatasetToDataset(all, current)));
            try {
                crawledDataset = crawledData.get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof LinkedDataFetchingException) {
                    throw (LinkedDataFetchingException)cause;
                }
                throw new RuntimeException("Could not retrieve data for multiple URIs", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not retrieve data for multiple URIs", e);
            }
            if (crawledDataset.isPresent()) {
                RdfUtils.addDatasetToDataset(dataset, (Dataset)crawledDataset.get(), true);
            }
            crawledURIs.addAll(urisToCrawl);
            newlyDiscoveredURIs = new HashSet();
            newlyDiscoveredURIs.addAll((Collection<URI>)findNextUrisFunction.apply(dataset, crawledURIs));
            logger.debug("current Depth: " + ++depth);
        }
        return dataset;
    }

    private Set<URI> getURIsToCrawlWithPropertyPath(Dataset dataset, URI resourceURI, Set<URI> excludedUris, List<Path> properties) {
        if (logger.isDebugEnabled()) {
            logger.debug("evaluating property paths on data crawled so far");
            RDFDataMgr.write((OutputStream)System.out, (Dataset)dataset, (Lang)Lang.TRIG);
        }
        HashSet<URI> toCrawl = new HashSet<URI>();
        properties.stream().forEach(path -> {
            Iterator<URI> newURIs = RdfUtils.getURIsForPropertyPathByQuery(dataset, resourceURI, path);
            if (!newURIs.hasNext()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("found no uris starting at {}, using path {}", new Object[]{resourceURI, path});
                }
                return;
            }
            HashSet<URI> newUrisThisIteration = new HashSet<URI>();
            int skipped = 0;
            while (newURIs.hasNext()) {
                URI newUri = newURIs.next();
                boolean skip = excludedUris.contains(newUri);
                if (skip) {
                    ++skipped;
                } else {
                    newUrisThisIteration.add(newUri);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("found uri {} starting at {}, using path {}, will {} ", new Object[]{newUri, resourceURI, path, skip ? "skip" : "fetch"});
            }
            toCrawl.addAll(newUrisThisIteration);
        });
        return toCrawl;
    }

    private Set<URI> getURIsToCrawl(Dataset dataset, Set<URI> excludedUris, List<URI> properties) {
        HashSet<URI> toCrawl = new HashSet<URI>();
        for (int i = 0; i < properties.size(); ++i) {
            final URI property = properties.get(i);
            NodeIterator objectIterator = RdfUtils.visitFlattenedToNodeIterator(dataset, new RdfUtils.ModelVisitor<NodeIterator>(){

                @Override
                public NodeIterator visit(Model model) {
                    Property p = model.createProperty(property.toString());
                    return model.listObjectsOfProperty(p);
                }
            });
            while (objectIterator.hasNext()) {
                URI discoveredUri;
                RDFNode objectNode = objectIterator.next();
                if (!objectNode.isURIResource() || excludedUris.contains(discoveredUri = URI.create(objectNode.asResource().getURI()))) continue;
                toCrawl.add(discoveredUri);
            }
        }
        return toCrawl;
    }

    public void setLinkedDataRestClient(LinkedDataRestClient linkedDataRestClient) {
        this.linkedDataRestClient = linkedDataRestClient;
    }

    public void setParallelRequestsThreadpool(ThreadPoolExecutor parallelRequestsThreadpool) {
        this.parallelRequestsThreadpool = parallelRequestsThreadpool;
    }

    public static Dataset makeDataset() {
        DatasetGraph dsg = TDBFactory.createDatasetGraph();
        dsg.getContext().set(TDB.symUnionDefaultGraph, (Object)new NodeValueBoolean(true));
        return DatasetFactory.wrap((DatasetGraph)dsg);
    }
}

